/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageConfigurationCapabilitiesOfThinProvisioningPoolInstrumentation
extends BaseInstrumentation {
    private static final UnsignedInteger16[] SYNC_ASYNC_ACTIONS = new UnsignedInteger16[]{ProviderConstants.UINT16_THREE, ProviderConstants.UINT16_FOUR, ProviderConstants.UINT16_FIVE, ProviderConstants.UINT16_SIX};

    private String createInstanceID(RMIObjectCache rmiObj) throws Exception {
        StringBuilder sb = new StringBuilder(rmiObj.getSMISMappingContainer().getStorageSystemName());
        sb.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        sb.append("ThinProvisioningPool");
        return sb.toString();
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"InstanceID", "SystemName"});
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        String nameVal = "HITACHI_StorageConfigurationCapabilitiesOfThinProvisioningPool".substring("HITACHI_".length());
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("SupportedStorageElementTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_FIVE}, false), new CIMProperty("ThinProvisionedClientSettableReserve", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("ThinProvisionedDefaultReserve", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("SupportedSynchronousActions", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0], false), new CIMProperty("SupportedAsynchronousActions", CIMDataType.UINT16_ARRAY_T, (Object)SYNC_ASYNC_ACTIONS, false), new CIMProperty("SupportedStoragePoolFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_THREE, ProviderConstants.UINT16_SIX}, false), new CIMProperty("SupportedStorageElementFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_THREE}, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)nameVal, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)nameVal, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)nameVal, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_StorageConfigurationCapabilitiesOfThinProvisioningPool");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String instID = this.createInstanceID(rmiObj);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageConfigurationCapabilitiesOfThinProvisioningPool", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String idVal;
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null != instID && instID.equals(idVal = this.createInstanceID(device.getRMIObject()))) {
                return this.generateInstance(op, propertyList, device.getRMIObject());
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, "Could not find instance matching : " + op);
    }
}

