/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.FCPortCallbackHandler;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class StorageProcessorSystemDeviceSCSIPEInstrumentation
extends BaseAssocInstrumentation {
    protected StorageProcessorSystemDeviceSCSIPEInstrumentation() {
        super("HITACHI_StorageProcessorSystemDeviceSCSIProtocolEndpoint", "HITACHI_StorageProcessorSystem", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProcessorSystemInstrumentation"), "HITACHI_SCSIProtocolEndpoint", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolEndpointInstrumentation"));
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                FCPortCallbackHandler<FCPort> callback = new FCPortCallbackHandler<FCPort>(deviceIter, isObjectPath, refInfo, op, propertyList, FCPort.PortTypeRequested.OPEN, this);
                FCPort.getFCPorts(device.getRMIObject(), callback, isObjectPath, propertyList != null && propertyList.length != 0, null, null);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opSCSIPE) {
        String cvSystemName;
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        CIMProperty cpSystemName = null != opSCSIPE ? opSCSIPE.getKey("SystemName") : null;
        String string = cvSystemName = null != cpSystemName ? (String)cpSystemName.getValue() : null;
        if (null != cvSystemName) {
            hTable.put("Name", cvSystemName);
            hTable.put("SystemName", cvSystemName);
        }
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opStorageProcessorSystem) {
        String cvName;
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        CIMProperty cpName = null != opStorageProcessorSystem ? opStorageProcessorSystem.getKey("Name") : null;
        String string = cvName = null != cpName ? (String)cpName.getValue() : null;
        if (null != cvName) {
            hTable.put("SystemName", cvName);
        }
        return hTable;
    }
}

