/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class StorageSystemDeviceImportingSCSIPCInstrumentation
extends BaseAssocInstrumentation {
    protected StorageSystemDeviceImportingSCSIPCInstrumentation() {
        super("HITACHI_StorageSystemDeviceImportingSCSIPC", "HITACHI_StorageSystem", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), "HITACHI_ImportingSCSIProtocolController", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ImportingSCSIProtocolControllerInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_StorageSystemDeviceImportingSCSIPC".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath opImportingSCSIProtocolController = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, opStorageSystem, opImportingSCSIProtocolController));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, opStorageSystem, opImportingSCSIProtocolController));
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        block6: {
            try {
                CIMInstance instImportingSCSIPC;
                CIMObjectPath opStorageSystem;
                block7: {
                    String ssNameImportingSCSIPC;
                    String ssName;
                    CIMObjectPath opImportingSCSIPC;
                    String cpnStorageSystem = this.getReference1PropertyName();
                    opStorageSystem = op.getKey(cpnStorageSystem) != null ? (CIMObjectPath)op.getKey(cpnStorageSystem).getValue() : null;
                    String cpnImportingSCSIPC = this.getReference2PropertyName();
                    CIMObjectPath cIMObjectPath = opImportingSCSIPC = op.getKey(cpnImportingSCSIPC) != null ? (CIMObjectPath)op.getKey(cpnImportingSCSIPC).getValue() : null;
                    if (null == opImportingSCSIPC || null == opStorageSystem) break block6;
                    String string = ssName = opStorageSystem.getKey("Name") != null && opStorageSystem.getKey("Name").getValue() != null ? (String)opStorageSystem.getKey("Name").getValue() : null;
                    if (null == ssName) break block6;
                    String string2 = ssNameImportingSCSIPC = opImportingSCSIPC.getKey("SystemName") != null && opImportingSCSIPC.getKey("SystemName").getValue() != null ? (String)opImportingSCSIPC.getKey("SystemName").getValue() : null;
                    if (!ssName.equalsIgnoreCase(ssNameImportingSCSIPC)) break block6;
                    instImportingSCSIPC = null;
                    try {
                        instImportingSCSIPC = this.getReference2Instrumentation().getInstance(opImportingSCSIPC, null);
                    }
                    catch (WBEMException we) {
                        if (we.getID() == 6) break block7;
                        throw we;
                    }
                }
                if (null != instImportingSCSIPC) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageSystem, "Name");
                    opStorageSystem = this.getReference1Instrumentation().generateObjectPath(opStorageSystem, device.getRMIObject());
                    return this.generateInstance(op, propertyList, opStorageSystem, instImportingSCSIPC.getObjectPath());
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean isObjectNameRef1;
            if (null != assocName && "HITACHI_StorageSystemDeviceImportingSCSIPC".equalsIgnoreCase(assocName.getObjectName()) && ((isObjectNameRef1 = objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName())) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName) || objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName))) {
                String prop2Examine = isObjectNameRef1 ? "Name" : "SystemName";
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, prop2Examine);
                CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                CIMObjectPath opImportingSCSIProtocolController = this.getReference2Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(objectName, opStorageSystem, opImportingSCSIProtocolController));
                } else {
                    iter.add(this.generateInstance(objectName, propertyList, opStorageSystem, opImportingSCSIProtocolController));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

