/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.common.TierInfo;
import com.hitachi.smi.instrumentation.StoragePoolInstrumentation;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageTierInstrumentation
extends StoragePoolInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"InstanceID", "SystemName"});
        try {
            short poolID = -1;
            if (null != expectedValues) {
                if (1 != devices.size()) {
                    throw new WBEMException("CIM_SystemSpecificCollection.enumerate called for association but found insf. managed devices. Found devices: " + devices.size() + ", expectedValues: " + expectedValues);
                }
                String expPoolID = (String)expectedValues.get("PoolID");
                if (null != expPoolID) {
                    try {
                        poolID = Short.parseShort(expPoolID);
                    }
                    catch (NumberFormatException nfe) {
                        throw new WBEMException(1, "Unable to convert " + expPoolID + " to short", null, (Throwable)nfe);
                    }
                }
            }
            for (RMIObjectMapping device : devices) {
                CommonClassAsList<ThinPool> callback = new CommonClassAsList<ThinPool>();
                ThinPool.getThinPoolsTierAllocationOn(device.getRMIObject(), callback, poolID);
                LinkedList<ThinPool> thinPools = callback.getReturnValue();
                for (ThinPool thinPool : thinPools) {
                    for (TierInfo tierInfo : thinPool.getTierInfo()) {
                        if (null != refInfo) {
                            refInfo.addReference(iter, this.generateObjectPath(op, tierInfo));
                            continue;
                        }
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(op, tierInfo));
                            continue;
                        }
                        iter.add(this.generateInstance(op, propertyList, tierInfo));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath p, String[] propList, Object ... o) throws Exception {
        if (null == o || o.length != 1) {
            throw new IllegalArgumentException(ProviderConstants.GENERATE_INSTANCE_ILLEGAL_ARGUMENT + " " + "CIM_SystemSpecificCollection");
        }
        TierInfo tierInfo = (TierInfo)o[0];
        String caption = tierInfo.getStorageTierInstanceID();
        UnsignedInteger16 cpvRelativePerformanceOrder = new UnsignedInteger16(tierInfo.getTierOrder());
        try {
            CIMObjectPath retOP = this.generateObjectPath(p, tierInfo);
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] retProps = new CIMProperty[]{keys[0], new CIMProperty("RelativePerformanceOrder", CIMDataType.UINT16_T, (Object)cpvRelativePerformanceOrder, false), new CIMProperty("StorageObjectType", CIMDataType.UINT16_T, null, false), new CIMProperty("Technology", CIMDataType.UINT16_T, null, false), new CIMProperty("State", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("Dynamic", CIMDataType.BOOLEAN_T, null, false), new CIMProperty("DeleteOnEmptyStorageTier", CIMDataType.BOOLEAN_T, null, false), new CIMProperty("Percentage", CIMDataType.UINT16_T, null, false), new CIMProperty("TotalCapacity", CIMDataType.UINT64_T, null, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)caption, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)caption, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)caption, false)};
            return new CIMInstance(retOP, retProps).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        if (null == o || o.length != 1) {
            throw new IllegalArgumentException(ProviderConstants.GENERATE_OBJECTPATH_ILLEGAL_ARGUMENT + " " + "CIM_SystemSpecificCollection");
        }
        TierInfo tierInfo = (TierInfo)o[0];
        try {
            String instanceID = tierInfo.getStorageTierInstanceID();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instanceID, true)};
            return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageTier", keys, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            short[] instanceIDVals;
            String cpvInstanceID;
            String string = cpvInstanceID = op.getKey("InstanceID") != null ? (String)op.getKey("InstanceID").getValue() : null;
            if (null != cpvInstanceID && null != (instanceIDVals = TierInfo.getStorageTierInstanceIDValues(cpvInstanceID, null))) {
                TierInfo[] tierInfos;
                short poolID = instanceIDVals[0];
                short tierOrder = instanceIDVals[1];
                ThinPool thinPool = ThinPool.find(device.getRMIObject(), poolID, true);
                if (null != thinPool && null != (tierInfos = thinPool.getTierInfo()) && tierInfos.length > tierOrder) {
                    return this.generateInstance(op, propertyList, tierInfos[tierOrder]);
                }
            }
        }
        catch (WBEMException we) {
            if (6 == we.getID() || 1 == we.getID()) {
                throw we;
            }
            throw new WBEMException(1, we.toString(), null, (Throwable)we);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

