/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DedupInfo;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.PoolNickChanged;
import com.hitachi.smi.common.PoolNickname;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.StoragePoolInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import sanproject.serverux.data.SANRmiException;

public class ThinProvisioningPoolInstrumentation
extends StoragePoolInstrumentation
implements CacheUpdateNotifier {
    private PoolNickChanged nickNameListener;

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                ThinPool tp = (ThinPool)pObj;
                if (tp.isAOUPool()) {
                    CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_ThinProvisioningPool", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                    CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_ThinProvisioningPool added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                ThinPool tp = (ThinPool)pObj;
                if (tp.isAOUPool()) {
                    CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_ThinProvisioningPool", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                    CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_ThinProvisioningPool deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                ThinPool tp = (ThinPool)pObj;
                if (tp.isAOUPool()) {
                    RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber());
                    CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_ThinProvisioningPool", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                    CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                    ThinPool newInst = ThinPool.find(device.getRMIObject(), tp.getPoolID(), ThinPool.ThinPoolType.AOU);
                    if (newInst != null) {
                        CIMInstance sourceInstance = this.generateInstance(op, null, newInst);
                        IndicationHelper helper = new IndicationHelper(mHandle);
                        CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                        mHandle.deliverEvent(indication, null);
                    } else {
                        mLogger.severe("Unable to find a ThinPool that with ID: " + tp.getPoolID());
                    }
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_ThinProvisioningPool modified indication instance", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
        try {
            short poolID = -1;
            if (null != expectedValues) {
                String instID;
                if (1 != devices.size()) {
                    throw new WBEMException("HITACHI_SCSIProtocolController.enumerate called for association but found insf. managed devices. Found devices: " + devices.size() + ", expectedValues: " + expectedValues);
                }
                String expPoolID = (String)expectedValues.get("PoolID");
                if (expPoolID != null) {
                    try {
                        poolID = Short.parseShort(expPoolID);
                    }
                    catch (NumberFormatException nfe) {
                        throw new WBEMException(1, "Unable to convert " + expPoolID + " to short", null, (Throwable)nfe);
                    }
                }
                if (expectedValues.containsKey("InstanceID") && (expPoolID = ProviderLibs.getEndString(instID = (String)expectedValues.get("InstanceID"))) != null && !expPoolID.equals("ThinProvisioningPool")) {
                    try {
                        poolID = Short.parseShort(expPoolID);
                    }
                    catch (NumberFormatException nfe) {
                        throw new WBEMException(1, "Unable to convert " + expPoolID + " to short", null, (Throwable)nfe);
                    }
                }
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ThinPool> callback = new CallbackHandler<ThinPool>(deviceIter, isObjectPath, refInfo, op, propertyList);
                ThinPool.getThinPools(device.getRMIObject(), callback, poolID, true);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    protected UnsignedInteger32 extrinsic_GetSupportedSizeRange(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger64 maxVolSize;
        UnsignedInteger64 minVolSize;
        UnsignedInteger64 volumeSizeDivisor;
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        ThinPool tp = ProviderLibs.getThinPool(pOp);
        if (tp != null) {
            if (tp.isOPENPool()) {
                String msg;
                volumeSizeDivisor = new UnsignedInteger64("44040192");
                minVolSize = ProviderConstants.THIN_VOLUME_MIN_ALLOWED_SIZE;
                maxVolSize = ProviderConstants.THIN_VOLUME_MAX_ALLOWED_SIZE;
                CIMObjectPath goal = null;
                UnsignedInteger16 elementType = null;
                for (CIMArgument<?> arg : pInArgs) {
                    if (arg.getName().equalsIgnoreCase("Goal")) {
                        goal = (CIMObjectPath)arg.getValue();
                        continue;
                    }
                    if (!arg.getName().equalsIgnoreCase("ElementType")) continue;
                    elementType = (UnsignedInteger16)arg.getValue();
                }
                if (elementType == null) {
                    msg = "ElementType can not be null";
                    mLogger.severe("ElementType can not be null");
                    minVolSize = maxVolSize = ProviderConstants.UINT64_ZED;
                } else if (5 != elementType.intValue() && 3 != elementType.intValue()) {
                    msg = "ElementType must have a value of 5, passed in value is " + elementType;
                    mLogger.severe(msg);
                    minVolSize = maxVolSize = ProviderConstants.UINT64_ZED;
                    ret = ProviderConstants.UINT32_THREE;
                } else if (3 == tp.getUsage().intValue()) {
                    mLogger.log(Level.FINE, "ThinPool {0} is restricted", tp.getPoolID());
                    minVolSize = maxVolSize = ProviderConstants.UINT64_ZED;
                }
                if (maxVolSize.longValue() != 0L && goal != null) {
                    if (!ProviderLibs.checkSettingGoal(goal, tp, mHandle)) {
                        minVolSize = maxVolSize = ProviderConstants.UINT64_ZED;
                    }
                    goal = null;
                }
            } else {
                volumeSizeDivisor = new UnsignedInteger64("1048576");
                minVolSize = maxVolSize = ProviderConstants.UINT64_ZED;
            }
        } else {
            throw new WBEMException(6, "Could not find ThinProvisoningPool matches: " + pOp);
        }
        pOutArgs[0] = new CIMArgument("MinimumVolumeSize", CIMDataType.UINT64_T, (Object)minVolSize);
        pOutArgs[1] = new CIMArgument("MaximumVolumeSize", CIMDataType.UINT64_T, (Object)maxVolSize);
        pOutArgs[2] = new CIMArgument("VolumeSizeDivisor", CIMDataType.UINT64_T, (Object)volumeSizeDivisor);
        return ret;
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath p, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(p, o);
        ThinPool tp = (ThinPool)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber());
        try {
            DedupInfo di;
            ArrayList<CIMProperty> props = new ArrayList<CIMProperty>();
            CIMProperty[] keys = retOP.getKeys();
            props.add(keys[0]);
            StringBuilder poolID = new StringBuilder("ThinProvisioningPool");
            poolID = poolID.append(':');
            poolID = poolID.append(device.getStorageSystemName());
            poolID = poolID.append(".");
            poolID = poolID.append(tp.getPoolID());
            String tpStrID = poolID.toString();
            UnsignedInteger16 consistsOfVal = tp.getConsistsOfAsU16();
            props.add(new CIMProperty("ConsistsOf", CIMDataType.UINT16_T, (Object)consistsOfVal, false));
            UnsignedInteger16 usage = tp.getUsage();
            String label = null;
            try {
                PoolNickname poolLabel = PoolNickname.find(device.getRMIObject(), tp.getPoolID());
                if (poolLabel != null) {
                    label = poolLabel.getNickname();
                }
            }
            catch (WBEMException e) {
                mLogger.log(Level.SEVERE, "Error trying to get Pool Label: " + (Object)((Object)e), e);
            }
            props.add(new CIMProperty("Label", CIMDataType.STRING_T, (Object)label, false));
            props.add(new CIMProperty("Usage", CIMDataType.UINT16_T, (Object)usage, false));
            props.add(new CIMProperty("PoolID", CIMDataType.STRING_T, (Object)tpStrID, false));
            props.add(new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)false, false));
            long capacity = tp.getPoolCapaAsBytes();
            long freeCapacity = capacity - tp.getPoolUsed() * 1024L * 1024L;
            BigInteger calc = BigInteger.valueOf(capacity);
            UnsignedInteger64 cvTotalManagedSpace = new UnsignedInteger64(calc);
            props.add(new CIMProperty("TotalManagedSpace", CIMDataType.UINT64_T, (Object)cvTotalManagedSpace, false));
            calc = null;
            calc = BigInteger.valueOf(freeCapacity);
            UnsignedInteger64 cvRemaningManagedSpace = new UnsignedInteger64(calc);
            props.add(new CIMProperty("RemainingManagedSpace", CIMDataType.UINT64_T, (Object)cvRemaningManagedSpace, false));
            calc = null;
            props.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)tpStrID, false));
            props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false));
            props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
            props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)tp.getHealthState(), false));
            props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)tpStrID, false));
            props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)tpStrID, false));
            props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)(null == label || 0 == label.length() ? tpStrID : label), false));
            props.add(new CIMProperty("SpaceLimitDetermination", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_THREE, false));
            props.add(new CIMProperty("SpaceLimit", CIMDataType.UINT64_T, (Object)cvTotalManagedSpace, false));
            props.add(new CIMProperty("ThinProvisionMetaDataSpace", CIMDataType.UINT64_T, (Object)new UnsignedInteger64("4404019200"), false));
            props.add(new CIMProperty("ElementsShareSpace", CIMDataType.BOOLEAN_T, (Object)Boolean.TRUE, false));
            props.add(new CIMProperty("ReservedSpace", CIMDataType.UINT64_T, (Object)new UnsignedInteger64("4404019200"), false));
            props.add(new CIMProperty("CompressionActive", CIMDataType.BOOLEAN_T, (Object)this.isCompressed(device.getRMIObject(), tp), false));
            props.add(new CIMProperty("CompressionState", CIMDataType.UINT16_T, null, false));
            props.add(new CIMProperty("CompressionRate", CIMDataType.UINT16_T, null, false));
            try {
                di = new DedupInfo(device.getRMIObject(), tp);
            }
            catch (WBEMException e) {
                Throwable t = e;
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                mLogger.log(Level.SEVERE, "Exception obtaining DeDup info", t);
                di = null;
            }
            props.add(new CIMProperty("CompressionPercent", CIMDataType.UINT16_T, (Object)(null != di ? new UnsignedInteger16(di.getCompressionPercent()) : null), false));
            props.add(new CIMProperty("DedupActive", CIMDataType.BOOLEAN_T, (Object)tp.isDeduplication(), false));
            props.add(new CIMProperty("DedupPercent", CIMDataType.UINT16_T, (Object)(di != null ? new UnsignedInteger16(di.getDedupPercent()) : null), false));
            return new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{ThinPool.class}, o, "HITACHI_ThinProvisioningPool");
        ThinPool tp = (ThinPool)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber());
        try {
            String systemName = device.getStorageSystemName();
            String keyValue = systemName + "." + tp.getPoolID();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)keyValue, true)};
            return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_ThinProvisioningPool", keys, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        block7: {
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
            try {
                CIMProperty key = op.getKey("InstanceID");
                String value = (String)key.getValue();
                if (null == value) break block7;
                String strPoolID = ProviderLibs.getEndString(value, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                try {
                    short poolID = Short.parseShort(strPoolID);
                    ThinPool data = ThinPool.find(device.getRMIObject(), poolID, ThinPool.ThinPoolType.AOU);
                    if (data != null) {
                        return this.generateInstance(op, propertyList, data);
                    }
                }
                catch (NumberFormatException nfe) {}
            }
            catch (WBEMException we) {
                if (6 == we.getID() || 1 == we.getID()) {
                    throw we;
                }
                throw new WBEMException(1, we.toString(), null, (Throwable)we);
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, op.toString());
    }

    private synchronized PoolNickChanged getNicknameListener() {
        if (this.nickNameListener == null) {
            this.nickNameListener = new PoolNickChanged(this);
        }
        return this.nickNameListener;
    }

    @Override
    public UnsignedInteger64 getTotalManagedSpace(RMIObjectMapping device) throws RemoteException, SANRmiException, WBEMException {
        return ProviderConstants.UINT64_ZED;
    }

    @Override
    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 oRet = null;
        if ("GetSupportedSizes".equalsIgnoreCase(pMethodName)) {
            UnsignedInteger64[] emptyArray = new UnsignedInteger64[]{};
            pOutArgs[0] = new CIMArgument("Sizes", CIMDataType.UINT64_ARRAY_T, (Object)emptyArray);
            oRet = ProviderConstants.UINT32_TWO;
        } else if ("GetSupportedSizeRange".equalsIgnoreCase(pMethodName)) {
            oRet = pOp.getObjectName().contains("Primordial") ? ProviderConstants.UINT32_TWO : this.extrinsic_GetSupportedSizeRange(pOp, pInArgs, pOutArgs);
        } else {
            throw new WBEMException(17, "StoragePool does not know about the method: " + pMethodName);
        }
        return oRet;
    }

    private Boolean isCompressed(RMIObjectCache rmiObj, ThinPool tp) {
        Boolean ret = false;
        ClosableAddableIteratorCB<DeviceNumber> callback = new ClosableAddableIteratorCB<DeviceNumber>();
        try {
            DeviceNumber.getDNs(rmiObj, callback, tp.getPoolID(), false, VolumeTypeEnum.AOUVOL);
            CloseableAddableIterator<DeviceNumber> iter = callback.getWrappedCloseableAddableIter();
            while (iter.hasNext()) {
                DeviceNumber dn = (DeviceNumber)iter.next();
                ret = dn.isCompressed(rmiObj);
                if (!ret.booleanValue()) continue;
                iter.done();
                break;
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Error finding DN created by pool " + tp.getPoolID(), e);
        }
        return ret;
    }

    @Override
    public void modifyInstance(CIMInstance modifiedInst, String[] propertyList) throws WBEMException {
        CIMInstance currentInst;
        String propName;
        if (null != propertyList && 1 != propertyList.length) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)modifiedInst.getObjectPath(), (String)"Can only modify ElementName", (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"ModifyInstance");
        }
        String string = propName = null == propertyList ? null : propertyList[0];
        if (!"ElementName".equalsIgnoreCase(propName)) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)modifiedInst.getObjectPath(), (String)("can not modify " + propName), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"ModifyInstance");
        }
        ThinPool tp = ProviderLibs.getThinPool(modifiedInst.getObjectPath());
        if (tp != null) {
            try {
                currentInst = this.generateInstance(modifiedInst.getObjectPath(), propertyList, tp);
            }
            catch (Throwable t) {
                if (t instanceof WBEMException) {
                    throw (WBEMException)t;
                }
                throw new WBEMException(1, "Error generating instance for modification", null, t);
            }
        } else {
            throw new WBEMException(6, modifiedInst.getObjectPath().toString());
        }
        ProviderLibs.modifyElementName(currentInst, modifiedInst, tp, mHandle.getProperty("javax.wbem.provider.Principal"), modifiedInst.getObjectPath().getHost(), "HITACHI_AffectedJobElementThinProvisioningPool", "HITACHI_StorageCSOwningJobElement");
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_StoragePool".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_StoragePool".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(true);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StoragePool".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(true);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StoragePool AND SourceInstance.CIM_StoragePool::TotalManagedSpace <> PreviousInstance.CIM_StoragePool::TotalManagedSpace".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.THINPOOL, this, null);
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.NICKNAME, this.getNicknameListener(), null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.THINPOOL, this, null);
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.NICKNAME, this.getNicknameListener(), null);
        }
    }

    private class CallbackHandler<E extends ThinPool>
    extends IteratorCallbackIMPL<E> {
        private CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block6: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E tp = item;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, ThinProvisioningPoolInstrumentation.this.generateObjectPath(this.mOP, tp));
                            break block6;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(ThinProvisioningPoolInstrumentation.this.generateObjectPath(this.mOP, tp));
                            break block6;
                        }
                        this.mIter.add(ThinProvisioningPoolInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, tp));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

