/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;

public class TierDomainInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "Name", expectedValues, new String[]{"Name", "SystemName"});
        try {
            String expPoolID;
            short poolID = -1;
            String string = expPoolID = null != expectedValues ? (String)expectedValues.get("PoolID") : null;
            if (expPoolID != null) {
                try {
                    poolID = Short.parseShort(expPoolID);
                }
                catch (NumberFormatException nfe) {
                    throw new WBEMException(1, "Unable to convert " + expPoolID + " to short", null, (Throwable)nfe);
                }
            }
            for (RMIObjectMapping device : devices) {
                CommonClassAsList<ThinPool> callback = new CommonClassAsList<ThinPool>();
                ThinPool.getThinPoolsTierAllocationOn(device.getRMIObject(), callback, poolID);
                LinkedList<ThinPool> thinPools = callback.getReturnValue();
                for (ThinPool thinPool : thinPools) {
                    if (null != refInfo) {
                        refInfo.addReference(iter, this.generateObjectPath(op, thinPool));
                        continue;
                    }
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, thinPool));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, thinPool));
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        ThinPool thinPool = (ThinPool)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(thinPool.getSerialNumber());
        String caption = device.getStorageSystemName() + ProviderConstants.ID_SEPERATOR_AS_CHAR + thinPool.getPoolID();
        String[] otherIDInfo = new String[]{"TIER"};
        String[] idDesc = new String[]{"SNIA:DetailedType"};
        try {
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], new CIMProperty("DataMovement", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("DataMovementState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("NameFormat", CIMDataType.STRING_T, (Object)"Other", false), new CIMProperty("OtherIdentifyingInfo", CIMDataType.STRING_ARRAY_T, (Object)otherIDInfo, false), new CIMProperty("IdentifyingDescriptions", CIMDataType.STRING_ARRAY_T, (Object)idDesc, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)caption, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)caption, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)caption, false)};
            return new CIMInstance(retOP, props).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{ThinPool.class}, o, "HITACHI_TierDomain");
        ThinPool thinPool = (ThinPool)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(thinPool.getSerialNumber());
        String name = device.getStorageSystemName() + ProviderConstants.ID_SEPERATOR_AS_CHAR + thinPool.getPoolID();
        try {
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_TierDomain", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)name, true)};
            return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_TierDomain", keys, op.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "Name");
        try {
            String name;
            String string = name = op.getKey("Name") != null ? (String)op.getKey("Name").getValue() : null;
            if (null != name) {
                String sPoolID = ProviderLibs.getEndString(name, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                try {
                    short poolID = Short.parseShort(sPoolID);
                    ThinPool thinPool = ThinPool.find(device.getRMIObject(), poolID, true);
                    return this.generateInstance(op, propertyList, thinPool);
                }
                catch (NumberFormatException nfe) {}
            }
        }
        catch (WBEMException we) {
            if (6 == we.getID() || 1 == we.getID()) {
                throw we;
            }
            throw new WBEMException(1, we.toString(), null, (Throwable)we);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 ret = null;
        if (pInArgs == null || pInArgs.length == 0) {
            mLogger.log(Level.WARNING, "input arguments are null or empty");
            ret = ProviderConstants.UINT32_FIVE;
        } else if ("RequestDataMovementStateChange".equalsIgnoreCase(pMethodName)) {
            ret = ProviderConstants.UINT32_ONE;
        } else {
            throw new WBEMException(17, "TierDomain doesn't know the method: " + pMethodName);
        }
        return ret;
    }
}

