/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation.iSCSI;

import com.hitachi.smi.common.CHAInfo;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSIreadAllPortInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class HostedStorageProcessorSystemTCPProtocolEndpointInstrumentation
extends BaseAssocInstrumentation {
    public HostedStorageProcessorSystemTCPProtocolEndpointInstrumentation() {
        super("HITACHI_HostedStorageProcessorSystemTCPProtocolEndpoint", "HITACHI_StorageProcessorSystem", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProcessorSystemInstrumentation"), "HITACHI_TCPProtocolEndpoint", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.iSCSI.TCPProtocolEndpointInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_HostedStorageProcessorSystemTCPProtocolEndpoint".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        this.getDependentObjects(objectName, isObjectPath, propertyList, iter);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Dependent")) && (null == resultRole || resultRole.equalsIgnoreCase("Antecedent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    this.getAntecedentObjects(objectName, isObjectPath, propertyList, iter);
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                ClosableAddableIteratorCB<ISCSIreadAllPortInfo> callback = new ClosableAddableIteratorCB<ISCSIreadAllPortInfo>();
                ISCSIreadAllPortInfo.getISCSIAllPortInfo(device.getRMIObject(), callback, -1);
                CloseableAddableIterator<ISCSIreadAllPortInfo> portIter = callback.getWrappedCloseableAddableIter();
                while (portIter.hasNext()) {
                    ISCSIreadAllPortInfo iSCSI = (ISCSIreadAllPortInfo)portIter.next();
                    FCPort fcPort = FCPort.find((short)iSCSI.getId(), FCPort.PortTypeRequested.iSCSI, device.getRMIObject());
                    if (null != fcPort) {
                        CIMObjectPath storProcOP = this.getReference1Instrumentation().generateObjectPath(op, fcPort);
                        CIMObjectPath ipOP = this.getReference2Instrumentation().generateObjectPath(op, fcPort, iSCSI);
                        iter.add(this.generateInstance(op, propertyList, storProcOP, ipOP));
                        continue;
                    }
                    mLogger.log(Level.SEVERE, "iSCSI port {0} has no assocaited FCPort", iSCSI);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    private void getAntecedentObject(CIMObjectPath objectName, boolean isObjectPath, String[] propertyList, CustomCloseableIterator<?> iter) throws Exception {
        CIMObjectPath opFCPort = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_TCPProtocolEndpoint", objectName.getKeys(), objectName.getXmlSchemaName());
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
        String portID = (String)objectName.getKey("Name").getValue();
        FCPort port = FCPort.find(Short.parseShort(portID), FCPort.PortTypeRequested.iSCSI, device.getRMIObject());
        if (null != port) {
            CIMObjectPath opStorageProcessorSystem = this.getReference1Instrumentation().generateObjectPath(objectName, port);
            if (isObjectPath) {
                iter.add(this.generateObjectPath(objectName, opStorageProcessorSystem, opFCPort));
            } else {
                iter.add(this.generateInstance(objectName, propertyList, opStorageProcessorSystem, opFCPort));
            }
        }
    }

    private void getAntecedentObjects(CIMObjectPath objectName, boolean isObjectPath, String[] propertyList, CustomCloseableIterator<?> iter) throws Exception {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
        CIMProperty cpSysName = objectName.getKey("SystemName");
        if (null != cpSysName && null != cpSysName.getValue()) {
            String ctrID = ProviderLibs.getEndString((String)cpSysName.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR);
            CHAInfo chaInfo = CHAInfo.find(Integer.parseInt(ctrID), device.getRMIObject());
            if (isObjectPath) {
                iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, chaInfo));
            } else {
                try {
                    iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, chaInfo));
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
        }
    }

    private void getDependentObject(CIMObjectPath objectName, boolean isObjectPath, String[] propertyList, CustomCloseableIterator<?> iter) throws WBEMException {
        String ctrID;
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
        CIMProperty cpName = objectName.getKey("Name");
        if (null != cpName && null != cpName.getValue() && null != (ctrID = ProviderLibs.getEndString((String)cpName.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR))) {
            try {
                CIMObjectPath opStorageProcessorSystem = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_StorageProcessorSystem", objectName.getKeys(), objectName.getXmlSchemaName());
                short sCtrID = Short.parseShort(ctrID);
                CommonClassAsList<FCPort> callback = new CommonClassAsList<FCPort>();
                FCPort.getFCPorts(device.getRMIObject(), callback, isObjectPath, propertyList != null && propertyList.length != 0, null, null);
                LinkedList<FCPort> portList = callback.getReturnValue();
                callback = null;
                FCPort port = portList.poll();
                while (port != null) {
                    if (sCtrID == port.getControlID()) {
                        ISCSIreadAllPortInfo iSCSI = ISCSIreadAllPortInfo.find(device.getRMIObject(), port.getPort());
                        CIMObjectPath opFCPort = this.getReference2Instrumentation().generateObjectPath(objectName, port, iSCSI);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, opStorageProcessorSystem, opFCPort));
                        } else {
                            iter.add(this.generateInstance(objectName, propertyList, opStorageProcessorSystem, opFCPort));
                        }
                    }
                    port = portList.poll();
                }
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
    }

    private void getDependentObjects(CIMObjectPath objectName, boolean isObjectPath, String[] propertyList, CustomCloseableIterator<?> iter) throws WBEMException {
        String ctrID;
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
        CIMProperty cpName = objectName.getKey("Name");
        if (null != cpName && null != cpName.getValue() && null != (ctrID = ProviderLibs.getEndString((String)cpName.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR))) {
            try {
                short sCtrID = Short.parseShort(ctrID);
                CommonClassAsList<FCPort> callback = new CommonClassAsList<FCPort>();
                FCPort.getFCPorts(device.getRMIObject(), callback, false, true, null, null);
                LinkedList<FCPort> portList = callback.getReturnValue();
                callback = null;
                FCPort port = portList.poll();
                while (port != null) {
                    if (sCtrID == port.getControlID()) {
                        ISCSIreadAllPortInfo iSCSI = ISCSIreadAllPortInfo.find(device.getRMIObject(), port.getPort());
                        if (isObjectPath) {
                            iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, port, iSCSI));
                        } else {
                            iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, port, iSCSI));
                        }
                    }
                    port = portList.poll();
                }
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_HostedStorageProcessorSystemTCPProtocolEndpoint".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        this.getDependentObject(objectName, isObjectPath, propertyList, iter);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Dependent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    this.getAntecedentObject(objectName, isObjectPath, propertyList, iter);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter) {
                iter.done();
            }
        }
    }
}

