/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CreateModifyNormalPool;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class CoalescedCreateModifyNormalPool
extends Coalescable {
    private void checkIndividualPGs(RMIObjectCache rmiObj, SanList response) throws WBEMException, SanDataException {
        Iterator<AbstractJobImpl> childIter = this.getAbstractJobImpls().iterator();
        int x = 0;
        while (childIter.hasNext()) {
            SanObject result;
            SanObject errorInfo;
            int errorCode;
            CreateModifyNormalPool child = (CreateModifyNormalPool)childIter.next();
            if (0 == (errorCode = (errorInfo = (result = response.getObj(x++)).getObj("ErrorInfo")).getInt("ErrorCode"))) continue;
            int[] msgID = errorInfo.getIntArray("MessageId");
            String msg = String.format("ErrorCode: %d, Message: %d-%d", msgID[0], msgID[0], msgID[1]);
            child.setError(new Throwable(msg));
        }
    }

    private Queue<SanData> createRMIObjects(RMIObjectCache rmiObj, SanRemote sanRemote) throws WBEMException {
        LinkedList<SanData> ret = new LinkedList<SanData>();
        try {
            ArrayList<CIMObjectPath> affectedElements = new ArrayList<CIMObjectPath>();
            SanData generalParam = null;
            SanRequest sanrequest = null;
            SanList pgs = null;
            int x = 0;
            Iterator<AbstractJobImpl> iter = this.getAbstractJobImpls().iterator();
            while (iter.hasNext()) {
                Throwable t;
                AbstractJobImpl childJob = iter.next();
                if (!(childJob instanceof CreateModifyNormalPool)) {
                    String msg = "Expected all elements of the list to contain instances of CreateModifyNormalPool, however this job had a " + childJob.getClass().getSimpleName();
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    continue;
                }
                if (0 == x) {
                    try {
                        generalParam = rmiObj.keyValueAPI_GetStorageInfoParam(sanRemote, childJob.getClientIP());
                        sanrequest = sanRemote.newRequest(generalParam, "MNTcreateParityGroups");
                        pgs = sanrequest.newList("ParityGroups");
                        if (null == pgs) {
                            throw new SanDataException("SanRequest.newList failed");
                        }
                    }
                    catch (SanDataException | SanRmiException e) {
                        t = e;
                        while (null != t.getCause()) {
                            t = t.getCause();
                        }
                        throw new WBEMException(1, "Error getting key/value objects", null, t);
                    }
                }
                childJob.setResultIndex(x);
                try {
                    SanObject pg = pgs.addObj();
                    CreateModifyNormalPool child = (CreateModifyNormalPool)childJob;
                    pg.putIntArray("Id", new int[]{child.getFb4(), child.getPg()});
                    pg.putInt("RaidLevel", child.getRaidLvl());
                    pg.putBoolean("Encryption", false);
                    pg.putBoolean("Copyback", true);
                    pg.newObj("Clpr").putInt("Id", 0);
                    pg.putInt("EmulationType", 625);
                    SanList drives = pg.newList("Drives");
                    Object datas = child.getActionItem();
                    Iterator i$ = datas.iterator();
                    while (i$.hasNext()) {
                        PDEVInfoEntry data = (PDEVInfoEntry)i$.next();
                        SanObject drive = drives.addObj();
                        drive.putIntArray("Id", new int[]{data.getCdev(), data.getRdev()});
                        ++x;
                    }
                }
                catch (SanDataException e) {
                    t = e;
                    while (null != t.getCause()) {
                        t = t.getCause();
                    }
                    throw new WBEMException(1, "Error getting key/value object for LDEV", null, t);
                }
                affectedElements.add(childJob.getJob().getCIMObjectPath(this.getOwningElement()));
            }
            this.setAffectedElements(affectedElements);
            ret.offer(generalParam);
            ret.offer((SanData)sanrequest);
        }
        catch (RemoteException re) {
            String msg = "Remote Exception with backend: " + re;
            mLogger.log(Level.SEVERE, msg, re);
            throw new WBEMException(1, msg, null, (Throwable)re);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeJob(List<AbstractJobImpl> actionItems) throws WBEMException {
        try {
            SanRemote sanRemote;
            this.setAbstractJobImpls(actionItems);
            this.createConcreteJobFromAbstractJobs();
            mLogger.log(Level.INFO, "CoalescedJob {0} starting", this.getJob().getInstanceID());
            this.markServerJobStarted(0);
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber());
            RMIObjectCache rmiObj = device.getRMIObject();
            try {
                sanRemote = rmiObj.keyValueAPI_GetSanRemote();
            }
            catch (NotBoundException | RemoteException e) {
                Throwable t = e;
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                throw new WBEMException(1, "Error getting SanRemote object", null, t);
            }
            Queue<SanData> rmiObjects = this.createRMIObjects(rmiObj, sanRemote);
            this.getHitachiJobServiceObject().updateServerJobPercentComplete(50, true);
            this.updateChildrenJobPercentComplete(25);
            SanResponse response = this.invoke(rmiObj, rmiObjects.poll(), (SanRequest)rmiObjects.poll(), sanRemote);
            try {
                if (0 != response.errorCode()) {
                    SanObject errorInfo = response.getObj("ErrorInfo");
                    int[] message = errorInfo.getIntArray("MessageId");
                    String msg = String.format("Creating ParityGroup failed with code %d, message %d-%d", response.errorCode(), message[0], message[1]);
                    throw new WBEMException(msg);
                }
                this.getHitachiJobServiceObject().updateServerJobPercentComplete(75, true);
                this.updateChildrenJobPercentComplete(50);
                this.checkIndividualPGs(rmiObj, response.getList("ParityGroups"));
            }
            catch (SanDataException e) {
                throw new WBEMException(1, e.toString(), null, (Throwable)e);
            }
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            this.setResult(t);
        }
        finally {
            this.markServerJobDone();
        }
    }
}

