/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedDeleteNormalPool;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import com.ws.wbem.CloseableAddableIterator;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class DeleteNormalPool
extends AbstractJobImpl
implements HitachiJobCallbackIF {
    private final int fb4;
    private final int pg;

    public DeleteNormalPool(String pUserName, String pIPAddress, CIMObjectPath owningService, ChassisArrayGroup cag) throws WBEMException {
        super(cag.getSerialNumber(), "DeleteStoragePool", pUserName, pIPAddress, owningService, "HITACHI_AffectedJobElementDiskExtent", "HITACHI_StorageCSOwningJobElement", null);
        this.setCallback(this);
        this.fb4 = cag.getFb4();
        this.pg = cag.getPg();
        this.setAffectedElements(cag);
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedDeleteNormalPool();
    }

    public int getFB4() {
        return this.fb4;
    }

    public int getPG() {
        return this.pg;
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted(25);
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                break;
            }
            case AFTER_TRANSACTION: {
                this.processResult();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    private void processResult() {
        WBEMException we = null;
        try {
            this.verifyPoolDeleted();
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (ClassCastException cce) {
            we = new WBEMException(1, cce.toString(), null, (Throwable)cce);
        }
        catch (Throwable t) {
            we = new WBEMException(1, t.toString(), null, t);
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    private void setAffectedElements(ChassisArrayGroup cag) throws WBEMException {
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerial());
        RMIObjectCache rmiObj = device.getRMIObject();
        BaseInstrumentation bi = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskExtentInstrumentation");
        ClosableAddableIteratorCB<PDEVInfoEntry> callback = new ClosableAddableIteratorCB<PDEVInfoEntry>();
        PDEVInfoEntry.getPDEVInfoEntry(rmiObj, callback, -1, -1, null, cag.getFb4(), cag.getPg());
        CloseableAddableIterator<PDEVInfoEntry> pdevs = callback.getWrappedCloseableAddableIter();
        ArrayList<CIMObjectPath> affectedOPs = new ArrayList<CIMObjectPath>();
        while (pdevs.hasNext()) {
            PDEVInfoEntry pdev = (PDEVInfoEntry)pdevs.next();
            try {
                affectedOPs.add(bi.generateObjectPath(this.getOwningElement(), pdev));
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Unable to generate object path for {0}, will not be listed as an affected element", t);
            }
        }
        super.setAffectedElements(affectedOPs.toArray(new CIMObjectPath[affectedOPs.size()]));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteNormalPool Parameters [");
        builder.append(this.getActionItem());
        builder.append("]");
        return builder.toString();
    }

    private void verifyPoolDeleted() throws WBEMException {
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerial());
        ChassisArrayGroup cached = ChassisArrayGroup.find(device.getRMIObject(), this.fb4, this.pg, false);
        for (int retryCount = -1; cached != null && retryCount < 20; ++retryCount) {
            try {
                this.getHitachiJobServiceObject().updateElapsedTime();
                mLogger.fine("Pool(" + cached.getChassisArrayID() + ") still in cache, will retry in " + 30 + " seconds.");
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie) {
                mLogger.log(Level.FINEST, "transaction sleep interrupted - this is OK", ie);
            }
            cached = ChassisArrayGroup.find(device.getRMIObject(), this.fb4, this.pg, false);
        }
        if (cached != null) {
            throw new WBEMException("Pool (" + this.fb4 + "." + this.pg + ") was not removed from cache");
        }
    }
}

