/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedDeleteVolumeJob;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class DeleteVolume
extends AbstractJobImpl
implements HitachiJobCallbackIF {
    public DeleteVolume(String pUserName, String pIPAddress, CIMObjectPath owningService, DeviceNumber dn2Del) throws WBEMException {
        super(dn2Del.getSerialNumber(), "ReturnToStoragePool", pUserName, pIPAddress, owningService, "HITACHI_AffectedJobElementStoragePool", "HITACHI_StorageCSOwningJobElement", null);
        if (dn2Del.isAOUVol() || dn2Del.isQSVvol()) {
            throw new WBEMException("Must pass in a DeviceNumber which is not a Thin or Snapshot volume");
        }
        this.setActionItem(dn2Del);
        this.setCallback(this);
        this.setAffectedElements(dn2Del);
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedDeleteVolumeJob();
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted(5);
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                break;
            }
            case AFTER_TRANSACTION: {
                this.processResult();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    private void processResult() {
        WBEMException we = null;
        try {
            this.getRMIResult();
            this.verifyVolumeDeleted();
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (Throwable t) {
            we = new WBEMException(1, t.toString(), null, t);
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    private void setAffectedElements(DeviceNumber dn) throws WBEMException {
        CommonClassAsList<ChassisArrayGroup> cb = new CommonClassAsList<ChassisArrayGroup>();
        ChassisArrayGroup.getChassisArrayGroup(RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerial()).getRMIObject(), cb, false, dn.getFb4(), dn.getPg(), dn.getVdev(), -1);
        LinkedList<ChassisArrayGroup> cags = cb.getReturnValue();
        cb = null;
        ArrayList<CIMObjectPath> paths = new ArrayList<CIMObjectPath>();
        BaseInstrumentation bi = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolInstrumentation");
        ChassisArrayGroup cag = cags.poll();
        while (cag != null) {
            CIMObjectPath path;
            try {
                path = bi.generateObjectPath(this.getOwningElement(), cag);
            }
            catch (Exception e) {
                throw new WBEMException(1, "Exception generating storagepool path", null, (Throwable)e);
            }
            paths.add(path);
            cag = cags.poll();
        }
        super.setAffectedElements(paths.toArray(new CIMObjectPath[paths.size()]));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteVolume Parameters [");
        builder.append(this.getActionItem());
        builder.append("]");
        return builder.toString();
    }

    private void verifyVolumeDeleted() throws WBEMException {
        DeviceNumber dn2Del = (DeviceNumber)this.getActionItem();
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerial());
        DeviceNumber dn = DeviceNumber.find(dn2Del.getDNAsString(), false, device.getRMIObject());
        for (int retryCount = -1; dn != null && retryCount < 20; ++retryCount) {
            try {
                this.getHitachiJobServiceObject().updateElapsedTime();
                mLogger.fine("Volume(" + dn2Del.getDNAsString() + ") still in cache, will retry in " + 30 + " seconds.");
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie) {
                mLogger.log(Level.FINEST, "transaction sleep interrupted - this is OK", ie);
            }
            dn = DeviceNumber.find(dn2Del.getDNAsString(), false, device.getRMIObject());
        }
        if (dn != null) {
            throw new WBEMException("Volume (" + dn2Del.getDNAsString() + ") was not removed from cache");
        }
    }
}

