/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs.workers;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.keyvalueapis.KeyValueAPIBaseObject;
import java.util.List;
import javax.wbem.WBEMException;

public class DeleteNormalVolumes
extends KeyValueAPIBaseObject {
    private final SanList ldevs2Delete;

    public DeleteNormalVolumes(RMIObjectCache rmiObj, DeviceNumber dn2Delete, String clientIP) throws WBEMException {
        this(rmiObj, clientIP);
        this.addDN(dn2Delete);
    }

    public DeleteNormalVolumes(RMIObjectCache rmiObj, List<DeviceNumber> dns2Delete, String clientIP) throws WBEMException {
        this(rmiObj, clientIP);
        this.addDNs(dns2Delete);
    }

    public DeleteNormalVolumes(RMIObjectCache rmiObj, String clientIP) throws WBEMException {
        super(rmiObj, clientIP, "MNTdeleteLdevs", false);
        try {
            this.ldevs2Delete = this.getRequest().newList("Ldevs");
            if (null == this.ldevs2Delete) {
                throw new WBEMException("Error creating Key/Value list");
            }
        }
        catch (SanDataException e) {
            throw new WBEMException(1, "Error creating Key/Value list: " + (Object)((Object)e), null, (Throwable)e);
        }
    }

    public void addDN(DeviceNumber dn2Delete) throws WBEMException {
        if (dn2Delete.isAOUVol() || dn2Delete.isQSVvol()) {
            throw new WBEMException(4, "Passed in volume is not a 'normal' volume " + dn2Delete);
        }
        try {
            SanObject ldev = this.ldevs2Delete.addObj();
            ldev.putIntArray("Id", new int[]{dn2Delete.getLdkc(), dn2Delete.getCu(), dn2Delete.getLdev()});
            ldev.putIntArray("ParityGroupId", new int[]{dn2Delete.getFb4(), dn2Delete.getPg()});
        }
        catch (SanDataException e) {
            throw new WBEMException(1, "Error creating LDEV Key/Value object: " + (Object)((Object)e), null, (Throwable)e);
        }
    }

    public void addDNs(List<DeviceNumber> dns2Delete) throws WBEMException {
        if (null != dns2Delete) {
            for (DeviceNumber dn : dns2Delete) {
                this.addDN(dn);
            }
        } else {
            logger.info("The passed in list is null, ignoring");
        }
    }
}

