@echo off
setlocal
SET CMN_DIR=%~dp0
SET WORK_DIR=%CD%

SET PROCESS=%1
SET STATUS=%STATUS_STOPPED%
SET STATUS_CODE=%CODE_STOPPED%
SET TRB_ID=%CMN_TRB_ID%

SET OUTPUT_STATUS=%CMN_DIR%\output_status.bat
SET TRB_BAT=..\dkc200\mp\pc\TroubleshootLogOperation.bat

REM -------------Get Defined Parameters-------------
SET FIXED_DISP=
SET SERVICE_NAME=
SET MODULE_ID=
SET TRB_ID_STOPPED_NORMAL=
SET SUMMARY_STOPPED_NORMAL=
SET TRB_ID_STOPPED_ABNORMAL=
SET SUMMARY_STOPPED_ABNORMAL=
SET TRB_ID_FAILED_UNHANDLED=
SET SUMMARY_FAILED_UNHANDLED=
CALL :GET_STATUS_DEFINE_DATA
REM -----------------------------------------------

SET /A READ_RETRY=0
IF EXIST %STATUS_FILE% GOTO READ_STATUS

REM -----Case: status.properties was not found-----
IF %PROCESS% EQU %EXISTS% ( 
 SET STATUS=%STATUS_INIT%
) ELSE ( 
 SET STATUS=%STATUS_STOPPED%
)
SET TRB_ID=

GOTO END
REM -----------------------------------------------

REM -------Case: status.properties was found-------

:READ_STATUS
CALL :GET_STATUS_FILE_DATA
CALL :CHECK_STATUS_SPELL %FILE_STATUS%
IF ERRORLEVEL %FAILURE% SET FILE_STATUS=

IF %PROCESS% EQU %EXISTS% ( 
 IF "%FILE_STATUS%" EQU "" ( 
  SET STATUS=%STATUS_WARN%
  SET TRB_ID=%CMN_TRB_ID%
 ) ELSE (
  CALL :SWITCH_PROCESS_EXISTS
 )
 
) ELSE (
 IF "%FILE_STATUS%" EQU "" ( 
   IF %READ_RETRY% LSS %READ_RETRY_MAX% (
   SET /A READ_RETRY = %READ_RETRY% + 1
   TIMEOUT 1
   GOTO :READ_STATUS
  )
  SET STATUS=%STATUS_STOPPED%
  SET TRB_ID=%TRB_ID_FAILED_UNHANDLED%
  CALL :RECOVERY_STATUS %LOG_ERROR% "%TRB_ID_FAILED_UNHANDLED%" "%SUMMARY_FAILED_UNHANDLED%"
  CALL :RECOVERY_STATUS %LOG_ERROR% "%TRB_ID_STOPPED_ABNORMAL%" "%SUMMARY_STOPPED_ABNORMAL%"
 ) ELSE (
  CALL :SWITCH_PROCESS_NOT_EXISTS
 )
)

:END
IF "" EQU "%FIXED_DISP%" (
 IF "" EQU "%FILE_DISP_NAME%" (
  SET DISP_NAME=%SERVICE_NAME%
 ) ELSE (
  SET DISP_NAME=%FILE_DISP_NAME%
 )
) ELSE (
 SET DISP_NAME=%FIXED_DISP%
)
CALL %OUTPUT_STATUS% "%DISP_NAME%" %STATUS% %TRB_ID%

endlocal
exit /b %SUCCESS%

REM ----------Process:Exist, File:Exist----------
:SWITCH_PROCESS_EXISTS
SET CASE_PROCESS_EXISTS=CASE_EX_%FILE_STATUS%
GOTO %CASE_PROCESS_EXISTS%

:CASE_EX_Stopped
 SET STATUS=%STATUS_INIT%
 SET TRB_ID=
 GOTO SWITCH_PROCESS_EXISTS_END
 
:CASE_EX_Initializing
:CASE_EX_Ready
:CASE_EX_Stopping
 SET STATUS=%FILE_STATUS%
 SET TRB_ID=
 GOTO SWITCH_PROCESS_EXISTS_END

:CASE_EX_Warning
:CASE_EX_Failed
 SET STATUS=%FILE_STATUS%
 IF "%FILE_TRB_ID%" EQU "" ( 
  SET TRB_ID=%CMN_TRB_ID%
 ) ELSE ( 
  SET TRB_ID=%FILE_TRB_ID%
 )
 GOTO SWITCH_PROCESS_EXISTS_END
  
:SWITCH_PROCESS_EXISTS_END
exit /b
REM ----------------------------------------------
 
REM --------Process:Not Exist, File:Exist---------
:SWITCH_PROCESS_NOT_EXISTS
SET CASE_PROCESS_NOT_EXISTS=CASE_NEX_%FILE_STATUS%
GOTO %CASE_PROCESS_NOT_EXISTS%

:CASE_NEX_Stopping
 CALL :RECOVERY_STATUS %LOG_INFO% "%TRB_ID_STOPPED_NORMAL%" "%SUMMARY_STOPPED_NORMAL%"
 SET STATUS=%STATUS_STOPPED%
 IF "%FILE_TRB_ID%" EQU "" ( 
  SET TRB_ID=
 ) ELSE ( 
  SET TRB_ID=%FILE_TRB_ID%
 )
 GOTO SWITCH_PROCESS_NOT_EXISTS_END

:CASE_NEX_Initializing
:CASE_NEX_Ready
:CASE_NEX_Warning
 CALL :RECOVERY_STATUS %LOG_ERROR% "%TRB_ID_FAILED_UNHANDLED%" "%SUMMARY_FAILED_UNHANDLED%"
 CALL :RECOVERY_STATUS %LOG_ERROR% "%TRB_ID_STOPPED_ABNORMAL%" "%SUMMARY_STOPPED_ABNORMAL%"
 SET STATUS=%STATUS_STOPPED%
 SET TRB_ID=%TRB_ID_FAILED_UNHANDLED%
 GOTO SWITCH_PROCESS_NOT_EXISTS_END

:CASE_NEX_Stopped
 SET STATUS=%STATUS_STOPPED%
 IF "%FILE_TRB_ID%" EQU "" ( 
  SET TRB_ID=
 ) ELSE ( 
  SET TRB_ID=%FILE_TRB_ID%
 )
 GOTO SWITCH_PROCESS_NOT_EXISTS_END

:CASE_NEX_Failed
 CALL :RECOVERY_STATUS %LOG_ERROR% "%TRB_ID_STOPPED_ABNORMAL%" "%SUMMARY_STOPPED_ABNORMAL%"
 SET STATUS=%STATUS_STOPPED%
 IF "%FILE_TRB_ID%" EQU "" ( 
  SET TRB_ID=
 ) ELSE ( 
  SET TRB_ID=%FILE_TRB_ID%
 )
 GOTO SWITCH_PROCESS_NOT_EXISTS_END
  
:SWITCH_PROCESS_NOT_EXISTS_END
exit /b
REM ----------------------------------------------

REM %1:LogLevel,%2:TrbID,%3:Summary
:RECOVERY_STATUS
CALL %TRB_BAT% %1 "%SERVICE_NAME%" "%~2" "%~3" "%MODULE_ID%"
CD /D %WORK_DIR%
exit /b

:GET_STATUS_FILE_DATA
FOR /F "usebackq tokens=1,2 delims==" %%i IN (`type %STATUS_FILE%`) DO (
 IF %%i EQU %KEY_DISP_NAME% SET FILE_DISP_NAME=%%j
 IF %%i EQU %KEY_STATUS% SET FILE_STATUS=%%j
 IF %%i EQU %KEY_TRB_ID% SET FILE_TRB_ID=%%j
)
exit /b

:GET_STATUS_DEFINE_DATA
FOR /F "usebackq tokens=1,2 delims==" %%i IN (`type %DEFINE_FILE%`) DO (
 IF %%i EQU %KEY_SERVICE_NAME% SET SERVICE_NAME=%%j
 IF %%i EQU %KEY_MODULE_ID% SET MODULE_ID=%%j
 IF %%i EQU %KEY_FIXED_DISP% SET FIXED_DISP=%%j
 IF %%i EQU %KEY_TRB_ID_STOPPED_NORMAL% SET TRB_ID_STOPPED_NORMAL=%%j
 IF %%i EQU %KEY_SUMMARY_STOPPED_NORMAL% SET SUMMARY_STOPPED_NORMAL=%%j
 IF %%i EQU %KEY_TRB_ID_STOPPED_ABNORMAL% SET TRB_ID_STOPPED_ABNORMAL=%%j
 IF %%i EQU %KEY_SUMMARY_STOPPED_ABNORMAL% SET SUMMARY_STOPPED_ABNORMAL=%%j
 IF %%i EQU %KEY_TRB_ID_FAILED_UNHANDLED% SET TRB_ID_FAILED_UNHANDLED=%%j
 IF %%i EQU %KEY_SUMMARY_FAILED_UNHANDLED% SET SUMMARY_FAILED_UNHANDLED=%%j
)
exit /b

:CHECK_STATUS_SPELL
IF "%1" EQU "%STATUS_STOPPED%" exit /b %SUCCESS%
IF "%1" EQU "%STATUS_INIT%" exit /b %SUCCESS%
IF "%1" EQU "%STATUS_READY%" exit /b %SUCCESS%
IF "%1" EQU "%STATUS_STOPPING%" exit /b %SUCCESS%
IF "%1" EQU "%STATUS_WARN%" exit /b %SUCCESS%
IF "%1" EQU "%STATUS_FAILED%" exit /b %SUCCESS%
exit /b %FAILURE%
