/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities;

import com.ws.utilities.FileDecrypt;
import com.ws.utilities.WSIStandardMessages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DecryptResults {
    private static final String ZIP_FILE = "results.zip";
    private static final String DECRYPTED_FILE = "index.html";
    private static final String ENCRYPTED_FILE = "results.encrypted";
    private static String ARG_INPUT = "-i";
    private static String ARG_OUTPUT = "-o";
    private static String ARG_HELP = "-h";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecryptResults(String[] args) {
        Hashtable<Object, Object> clArgs = new Hashtable();
        clArgs = this.checkCommandLine(args);
        String inFile = null != clArgs.get(ARG_INPUT) ? (String)clArgs.get(ARG_INPUT) : ZIP_FILE;
        String outDir = null != clArgs.get(ARG_OUTPUT) ? (String)clArgs.get(ARG_OUTPUT) : ".";
        String encryptedFile = outDir + File.separator + ENCRYPTED_FILE;
        boolean foundEncyptedFile = false;
        try {
            foundEncyptedFile = this.unzip(inFile, outDir);
            if (!foundEncyptedFile) {
                Object[] o = new Object[]{ENCRYPTED_FILE, inFile};
                System.out.println(WSIStandardMessages.getMessage("ERROR_ENCRYPTED_FILE_NOT_FOUND", o));
            } else {
                String decryptedFile = outDir + File.separator + DECRYPTED_FILE;
                new FileDecrypt().decryptFile(encryptedFile, decryptedFile);
            }
        }
        catch (Exception we) {
            System.out.println(we.getMessage());
        }
        finally {
            if (foundEncyptedFile) {
                File file = new File(encryptedFile);
                file.deleteOnExit();
            }
        }
    }

    private boolean unzip(String zipFilePath, String destDir) {
        boolean foundEncryptedFile = false;
        File dir = new File(destDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        byte[] buffer = new byte[1024];
        try {
            FileInputStream fis = new FileInputStream(zipFilePath);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(destDir + File.separator + fileName);
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                zis.closeEntry();
                ze = zis.getNextEntry();
                if (!ENCRYPTED_FILE.equals(fileName)) continue;
                foundEncryptedFile = true;
            }
            zis.closeEntry();
            zis.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return foundEncryptedFile;
    }

    public static void main(String[] args) {
        new DecryptResults(args);
    }

    private Hashtable<String, String> checkCommandLine(String[] argv) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        int i = -1;
        while (i + 1 < argv.length) {
            if (argv[++i].equals(ARG_HELP)) {
                this.showUsage();
                System.exit(1);
            }
            if (argv[i].equals(ARG_INPUT)) {
                if (++i >= argv.length) {
                    this.showUsage();
                    System.exit(1);
                }
                ht.put(ARG_INPUT, argv[i]);
                continue;
            }
            if (argv[i].equals(ARG_OUTPUT)) {
                if (++i >= argv.length) {
                    this.showUsage();
                    System.exit(1);
                }
                ht.put(ARG_OUTPUT, argv[i]);
                continue;
            }
            this.showUsage();
            System.exit(1);
        }
        return ht;
    }

    private void showUsage() {
        System.out.println(WSIStandardMessages.getMessage("USAGE_DECRYPTRESULTS", null));
    }
}

