/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.baseinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import sanproject.client.base.RJBasePanel;
import sanproject.client.baseinfo.RJBaseInfoPanel;
import sanproject.client.baseinfo.com.RJBaseInfoDataSupplier;
import sanproject.client.baseinfo.com.RJBaseInfoDef;
import sanproject.client.baseinfo.com.RJBaseInfoException;
import sanproject.client.baseinfo.com.RJBaseInfoTabPanel;
import sanproject.client.com.RJClientFileAccess;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcButton;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcEventQueue;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcSouthPanel;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;

public class RJBaseInfoFrame
extends JFrame
implements RJBaseInfoDef {
    public static final int DIALOG_H = 700;
    public static final int DIALOG_W = 840;
    private boolean opened = false;
    private JButton m_ButtonClose = null;
    private JButton m_ButtonExport = null;
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    private Vector buttonVector = null;
    private int dummyPosition = 0;
    private Point windowLocation = null;
    protected RJBasePanel basePanel = null;
    private RJBaseInfoDataSupplier supplier;
    private RJBaseInfoPanel funcPanel;

    public RJBaseInfoFrame(RJDataControl rJDataControl, RJBasePanel rJBasePanel) {
        this.enableEvents(64L);
        this.basePanel = rJBasePanel;
        this.supplier = new RJBaseInfoDataSupplier(rJBasePanel);
        this.initInstance();
        this.funcPanel.setBasePanel(rJBasePanel);
    }

    protected void initInstance() {
        JPanel jPanel;
        this.putLog("[Frame]", "initInstance() start", 0);
        this.setName("WebConsoleBasicInfoWindow");
        RJcEventQueue.addTopWindow(this);
        this.setDefaultCloseOperation(1);
        this.setTitle(RJcGuide.text("BasicInfo/FrameTitle") + this.basePanel.getExtensionTitle());
        this.setResizable(true);
        this.setSize(840, 700);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        jPanel2.setBorder(border);
        JPanel jPanel3 = this.createCenterComponent();
        if (jPanel3 != null) {
            jPanel2.add((Component)jPanel3, "Center");
        }
        if ((jPanel = this.createSouthComponent()) != null) {
            if (jPanel instanceof RJcSouthPanel) {
                ((RJcSouthPanel)jPanel).arrangeSouthPanel();
            }
            jPanel2.add((Component)jPanel, "South");
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.getContentPane().add(jScrollPane);
        this.setLocation(this.getWindowLocation());
        this.putLog("[Frame]", "initInstance() end", 0);
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean bl) {
        this.opened = bl;
    }

    public void setVisible(boolean bl) {
        this.putLog("[Frame]", "setVisible(" + bl + ")", 0);
        super.setVisible(bl);
        if (bl) {
            this.toFront();
            this.open();
        }
        this.setOpened(bl);
    }

    protected void open() {
        if (!this.isOpened()) {
            this.setOpened(true);
            this.refresh();
        }
    }

    public void refresh() {
        try {
            this.setTitle(RJcGuide.text("BasicInfo/FrameTitle") + this.basePanel.getExtensionTitle());
            this.funcPanel.showPanel(false);
            this.repaint();
        }
        catch (RJBaseInfoException rJBaseInfoException) {
            // empty catch block
        }
    }

    public void dispose() {
        this.setOpened(false);
        super.dispose();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.windowClosing();
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    public void windowClosing() {
        this.putLog("[Frame]", "windowClosing()", 0);
        RJBaseInfoFrame rJBaseInfoFrame = this;
        rJBaseInfoFrame.basePanel.removeBasicInfo();
    }

    private void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.windowClosing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportButton_actionPerformed(ActionEvent actionEvent) {
        this.putLog("[Frame]", "exportButton_actionPerformed()", 0);
        RJClientFileAccess rJClientFileAccess = this.showFileChooser();
        ExportRunnable exportRunnable = new ExportRunnable(rJClientFileAccess);
        if (rJClientFileAccess != null) {
            Object[] objectArray;
            try {
                this.supplier.waitCursor(this);
                objectArray = this.supplier.createWaitingDialog(this);
                objectArray.show(exportRunnable);
                objectArray.dispose();
            }
            finally {
                this.supplier.defaultCursor(this);
            }
            if (!exportRunnable.isNormal()) {
                objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
                RJDataMsg rJDataMsg = this.supplier.getMessage(10, rJClientFileAccess.getLastError());
                int n = this.supplier.showMessage(this, rJDataMsg, 0, objectArray, objectArray[0]);
            }
            this.setVisible(true);
        }
    }

    private RJClientFileAccess showFileChooser() {
        RJClientFileAccess rJClientFileAccess = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setFileSelectionMode(0);
        CSVFileFilter cSVFileFilter = new CSVFileFilter();
        jFileChooser.addChoosableFileFilter(cSVFileFilter);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        String string = this.funcPanel.getSelectedTabTitle();
        String string2 = "BasicInformation_" + string + ".csv";
        File file = new File(string2);
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog(this);
        File file2 = jFileChooser.getSelectedFile();
        if (file2 != null && n == 0) {
            String string3 = file2.getName();
            File file3 = file2;
            if (!string3.toLowerCase().endsWith(".csv")) {
                string3 = string3 + ".csv";
                file3 = new File(file2.getParentFile(), string3);
            }
            if ((rJClientFileAccess = new RJClientFileAccess(file3)).isFile(file3)) {
                Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
                RJDataMsg rJDataMsg = this.supplier.getMessage(10, rJClientFileAccess.getLastError());
                int n2 = this.supplier.showMessage(this, rJDataMsg, 0, objectArray, objectArray[0]);
                if (n2 != 0) {
                    rJClientFileAccess = null;
                }
            }
        }
        return rJClientFileAccess;
    }

    protected JPanel createCenterComponent() {
        this.funcPanel = new RJBaseInfoPanel(this.supplier);
        return this.funcPanel;
    }

    protected JPanel createSouthComponent() {
        RJcSouthPanel rJcSouthPanel = new RJcSouthPanel();
        this.m_ButtonClose = this.newButton("BasicInfo/CloseBtn");
        this.m_ButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJBaseInfoFrame.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.m_ButtonExport = this.newButton("BasicInfo/ExportBtn");
        this.m_ButtonExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJBaseInfoFrame.this.exportButton_actionPerformed(actionEvent);
            }
        });
        rJcSouthPanel.addComponent(this.m_ButtonExport, 1);
        rJcSouthPanel.addComponent(this.m_ButtonClose, 0);
        return rJcSouthPanel;
    }

    public void setWindowLocation(Point point) {
        this.windowLocation = point;
    }

    public Point getWindowLocation() {
        Point point = this.windowLocation;
        if (point == null) {
            point = this.calcWindowLocation();
        }
        return point;
    }

    protected Point calcWindowLocation() {
        Point point = null;
        Window window = this.getOwner();
        if (window != null) {
            Point point2 = window.getLocationOnScreen();
            Dimension dimension = window.getSize();
            Dimension dimension2 = this.getSize();
            point2.x += (dimension.width - dimension2.width) / 2;
            point2.y += (dimension.height - dimension2.height) / 2;
            point = new Point(point2);
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension3 = this.getSize();
            if (dimension3.height > dimension.height) {
                dimension3.height = dimension.height;
            }
            if (dimension3.width > dimension.width) {
                dimension3.width = dimension.width;
            }
            point = new Point((dimension.width - dimension3.width) / 2, (dimension.height - dimension3.height) / 2);
        }
        return point;
    }

    public JButton newButton(String string) {
        RJcButton rJcButton = new RJcButton(string);
        rJcButton.setFont(RJcConst.boldFont);
        rJcButton.setActionCommand(string);
        rJcButton.setName(string);
        Dimension dimension = rJcButton.getPreferredSize();
        dimension.height = 24;
        if (dimension.width < 80) {
            dimension.width = 80;
        }
        rJcButton.setPreferredSize(new Dimension(dimension.width, dimension.height));
        rJcButton.setMinimumSize(new Dimension(dimension.width, dimension.height));
        return rJcButton;
    }

    public void putLog(String string, String string2, int n) {
        RJCom.putLog("[BasicInfo]", string, string2, n);
    }

    private class CSVFileFilter
    extends FileFilter {
        private CSVFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".csv");
        }

        public String getDescription() {
            return "CSV file(*.csv)";
        }
    }

    private class ExportRunnable
    implements Runnable {
        private RJClientFileAccess accessFile;
        private boolean normal = true;

        ExportRunnable(RJClientFileAccess rJClientFileAccess) {
            this.accessFile = rJClientFileAccess;
        }

        public void run() {
            RJBaseInfoTabPanel rJBaseInfoTabPanel = (RJBaseInfoTabPanel)RJBaseInfoFrame.this.funcPanel.getActiveComPanel();
            String string = rJBaseInfoTabPanel.collectExportData();
            this.normal = this.accessFile.saveStringToFile(string);
        }

        public boolean isNormal() {
            return this.normal;
        }
    }
}

