/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import sanproject.client.com.RJCom;
import sanproject.client.data.RJDataControl;

public final class RJComImagePanel
extends JPanel {
    private ImageType mimtType;

    private RJComImagePanel(ImageType imageType) {
        this.mimtType = imageType;
        this.setOpaque(false);
    }

    public static RJComImagePanel createImagePanel(ImageType imageType) {
        RJComImagePanel rJComImagePanel = new RJComImagePanel(imageType);
        return rJComImagePanel;
    }

    public static RJComImagePanel createUpArrowPanel(final RJDataControl rJDataControl) {
        ImageType imageType = new ImageType(){
            private Image image;
            {
                this.image = this.loadImage(rJDataControl, "vertical_arrow.gif");
            }

            protected void printImage(Component component, Graphics graphics) {
                Dimension dimension = component.getSize();
                int n = dimension.width;
                int n2 = dimension.height;
                int n3 = this.image.getWidth(null);
                int n4 = this.image.getHeight(null);
                graphics.drawImage(this.image, 0, 0, n, n2, 0, 0, n3, n4, null);
            }

            public Insets getImagePanelInsets() {
                return new Insets(20, 30, 20, 30);
            }
        };
        RJComImagePanel rJComImagePanel = RJComImagePanel.createImagePanel(imageType);
        return rJComImagePanel;
    }

    public static RJComImagePanel createRightArrowPanel(final RJDataControl rJDataControl) {
        ImageType imageType = new ImageType(){
            private Image image;
            {
                this.image = this.loadImage(rJDataControl, "horizontal_arrow.gif");
            }

            protected void printImage(Component component, Graphics graphics) {
                Dimension dimension = component.getSize();
                int n = dimension.width;
                int n2 = dimension.height;
                int n3 = this.image.getWidth(null);
                int n4 = this.image.getHeight(null);
                graphics.drawImage(this.image, 0, 0, n, n2, 0, 0, n3, n4, null);
            }

            public Insets getImagePanelInsets() {
                return new Insets(25, 35, 25, 35);
            }
        };
        RJComImagePanel rJComImagePanel = RJComImagePanel.createImagePanel(imageType);
        return rJComImagePanel;
    }

    public static RJComImagePanel createDownArrowPanel(final RJDataControl rJDataControl) {
        ImageType imageType = new ImageType(){
            private Image image;
            {
                this.image = this.loadImage(rJDataControl, "vertical_arrow.gif");
            }

            protected void printImage(Component component, Graphics graphics) {
                Dimension dimension = component.getSize();
                int n = dimension.width;
                int n2 = dimension.height;
                int n3 = this.image.getWidth(null);
                int n4 = this.image.getHeight(null);
                graphics.drawImage(this.image, 0, 0, n, n2, 0, n4, n3, 0, null);
            }

            public Insets getImagePanelInsets() {
                return new Insets(20, 30, 20, 30);
            }
        };
        RJComImagePanel rJComImagePanel = RJComImagePanel.createImagePanel(imageType);
        return rJComImagePanel;
    }

    public static RJComImagePanel createLeftArrowPanel(final RJDataControl rJDataControl) {
        ImageType imageType = new ImageType(){
            private Image image;
            {
                this.image = this.loadImage(rJDataControl, "horizontal_arrow.gif");
            }

            protected void printImage(Component component, Graphics graphics) {
                Dimension dimension = component.getSize();
                int n = dimension.width;
                int n2 = dimension.height;
                int n3 = this.image.getWidth(null);
                int n4 = this.image.getHeight(null);
                graphics.drawImage(this.image, 0, 0, n, n2, n3, 0, 0, n4, null);
            }

            public Insets getImagePanelInsets() {
                return new Insets(25, 35, 25, 35);
            }
        };
        RJComImagePanel rJComImagePanel = RJComImagePanel.createImagePanel(imageType);
        return rJComImagePanel;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.mimtType != null) {
            this.mimtType.printImage(this, graphics);
        }
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.mimtType != null) {
            insets = this.mimtType.getImagePanelInsets();
        }
        return insets;
    }

    public static abstract class ImageType {
        protected abstract void printImage(Component var1, Graphics var2);

        public abstract Insets getImagePanelInsets();

        protected final Image loadImage(RJDataControl rJDataControl, String string) {
            Icon icon = RJCom.createImgIcon(rJDataControl, string);
            Image image = null;
            if (icon != null) {
                image = ((ImageIcon)icon).getImage();
            }
            return image;
        }
    }
}

