/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import sanproject.client.data.RJDataChange;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataException;
import sanproject.client.data.RJDataPortPart;
import sanproject.client.exdevice.data.CHAUtility;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.PathOperationDataControl;
import sanproject.client.exdevice.data.PortTimer;
import sanproject.client.exdevice.data.Singleton;
import sanproject.client.exdevice.data.SingletonManager;
import sanproject.client.exdevice.data.Utility;
import sanproject.common.Robj_interface_RJiCHAInfoDetail;
import sanproject.common.Robj_interface_RJiPortAttributeInfoDetail;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;
import sanproject.serverux.dataimpl.EXDPortTov;
import sanproject.serverux.dataimpl.EXDgetPortTov_IN;
import sanproject.serverux.dataimpl.EXDgetPortTov_OUT;
import sanproject.serverux.dataimpl.RJiPortIndex;
import sanproject.serverux.dataimpl.SanRmiInputInterface;

public class PortManager
implements Singleton {
    private static final String LOG_NAME = "PortManager";
    private Robj_interface_RJiPortInfoDetail[] mPortInfo;
    private Robj_interface_RJiCHAInfoDetail[] mChaInfo;
    private PortTimer[] mPortTimer = new PortTimer[0];
    private static PortTimer mDefaultPortTimer = new PortTimer();
    private static final Comparator COMP_PORT_ID = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = this.getValue(object);
            int n2 = this.getValue(object2);
            return n - n2;
        }

        private int getValue(Object object) {
            int n;
            if (object instanceof PortTimer) {
                n = ((PortTimer)object).hashCode();
            } else if (object instanceof Robj_interface_RJiPortIndex) {
                n = ((Robj_interface_RJiPortIndex)object).getSPort();
            } else {
                throw new ClassCastException();
            }
            return n;
        }
    };
    private Robj_interface_RJiPortAttributeInfoDetail[] mPortAtr;
    private int[] mModifyCount;
    private int[] mStatus;
    static /* synthetic */ Class class$sanproject$client$exdevice$data$PortManager;

    PortManager() {
    }

    public static synchronized PortManager getInstance() {
        return (PortManager)SingletonManager.getInstance(class$sanproject$client$exdevice$data$PortManager == null ? (class$sanproject$client$exdevice$data$PortManager = PortManager.class$("sanproject.client.exdevice.data.PortManager")) : class$sanproject$client$exdevice$data$PortManager);
    }

    public void destroy() {
    }

    void initialize() throws EXDException {
        Utility.putLog(LOG_NAME, "initialize");
        RJDataPortPart rJDataPortPart = RJDataControl.getDataControl().getPortPart();
        try {
            Utility.putLog(LOG_NAME, "    Start CHAInfoDetail.");
            long l = System.currentTimeMillis();
            this.mChaInfo = rJDataPortPart.getCHAInfoDetail();
            long l2 = System.currentTimeMillis();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("    End CHAInfoDetail. ");
            stringBuffer.append("<Time = ").append(l2 - l).append(" ms> ");
            stringBuffer.append("<Num = ").append(this.mChaInfo.length).append(">");
            Utility.putLog(LOG_NAME, stringBuffer.toString());
            Arrays.sort(this.mChaInfo, CHAUtility.CHA_INFO_COMP);
            Utility.putLog(LOG_NAME, "    Start PortInfoDetail.");
            l = System.currentTimeMillis();
            this.mPortInfo = rJDataPortPart.getPortInfoDetail();
            l2 = System.currentTimeMillis();
            stringBuffer = new StringBuffer();
            stringBuffer.append("    End PortInfoDetail. ");
            stringBuffer.append("<Time = ").append(l2 - l).append(" ms> ");
            stringBuffer.append("<Num = ").append(this.mPortInfo.length).append(">");
            Utility.putLog(LOG_NAME, stringBuffer.toString());
            Arrays.sort(this.mPortInfo);
            Utility.putLog(LOG_NAME, "    Start PortAttributeInfoDetail.");
            l = System.currentTimeMillis();
            this.mPortAtr = rJDataPortPart.getPortAttributeInfoDetail();
            l2 = System.currentTimeMillis();
            stringBuffer = new StringBuffer();
            stringBuffer.append("    End PortAttributeInfoDetail. ");
            stringBuffer.append("<Time = ").append(l2 - l).append(" ms> ");
            stringBuffer.append("<Num = ").append(this.mPortAtr.length).append(">");
            Utility.putLog(LOG_NAME, stringBuffer.toString());
            Arrays.sort(this.mPortAtr);
        }
        catch (RJDataException rJDataException) {
            throw new EXDException(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        this.mModifyCount = new int[this.mPortInfo.length];
        this.mStatus = new int[this.mPortInfo.length];
        Arrays.fill(this.mStatus, 0);
    }

    public Robj_interface_RJiPortInfoDetail[] getPortInfo() {
        ArrayList<Robj_interface_RJiPortInfoDetail> arrayList = new ArrayList<Robj_interface_RJiPortInfoDetail>(this.mPortAtr.length);
        for (int i = 0; i < this.mPortAtr.length; ++i) {
            Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail;
            Robj_interface_RJiPortAttributeInfoDetail robj_interface_RJiPortAttributeInfoDetail = this.mPortAtr[i];
            if (robj_interface_RJiPortAttributeInfoDetail.getByPortKind() != 6 || (robj_interface_RJiPortInfoDetail = this.getPortInfo((Robj_interface_RJiPortIndex)robj_interface_RJiPortAttributeInfoDetail)) == null) continue;
            arrayList.add(robj_interface_RJiPortInfoDetail);
        }
        Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray = new Robj_interface_RJiPortInfoDetail[]{};
        return arrayList.toArray(robj_interface_RJiPortInfoDetailArray);
    }

    public Robj_interface_RJiPortInfoDetail getPortInfo(int n) {
        RJiPortIndex rJiPortIndex = new RJiPortIndex();
        rJiPortIndex.setSPort((short)n);
        return this.getPortInfo((Robj_interface_RJiPortIndex)rJiPortIndex);
    }

    public Robj_interface_RJiPortInfoDetail getPortInfo(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail = null;
        int n = Arrays.binarySearch(this.mPortInfo, robj_interface_RJiPortIndex);
        if (n >= 0) {
            robj_interface_RJiPortInfoDetail = this.mPortInfo[n];
        }
        return robj_interface_RJiPortInfoDetail;
    }

    public String getPortName(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail;
        String string = null;
        if (robj_interface_RJiPortIndex != null && (robj_interface_RJiCHAInfoDetail = CHAUtility.searchChaInfoDetail(robj_interface_RJiPortIndex, this.mChaInfo)) != null) {
            byte[] byArray = robj_interface_RJiCHAInfoDetail.getByCHAModeBit();
            RJDataChange rJDataChange = RJDataControl.getDataControl().getChangeTbl();
            string = rJDataChange.ChangePortName(robj_interface_RJiPortIndex.getSPort(), byArray);
        }
        return string;
    }

    public boolean isMixMode(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail;
        boolean bl = false;
        if (robj_interface_RJiPortIndex != null && (robj_interface_RJiCHAInfoDetail = CHAUtility.searchChaInfoDetail(robj_interface_RJiPortIndex, this.mChaInfo)) != null) {
            bl = CHAUtility.isHighSpeedMode(robj_interface_RJiPortIndex, robj_interface_RJiCHAInfoDetail);
        }
        return bl;
    }

    void initPortTimer() throws EXDException {
        Utility.putLog(LOG_NAME, "    Start PortTov.");
        PathOperationDataControl pathOperationDataControl = PathOperationDataControl.getInstance();
        EXDgetPortTov_IN eXDgetPortTov_IN = new EXDgetPortTov_IN();
        long l = System.currentTimeMillis();
        EXDgetPortTov_OUT eXDgetPortTov_OUT = (EXDgetPortTov_OUT)pathOperationDataControl.comGet((SanRmiInputInterface)eXDgetPortTov_IN);
        long l2 = System.currentTimeMillis();
        EXDPortTov[] eXDPortTovArray = eXDgetPortTov_OUT.getAllPortTov();
        this.mPortTimer = new PortTimer[eXDPortTovArray.length];
        for (int i = 0; i < eXDPortTovArray.length; ++i) {
            this.mPortTimer[i] = new PortTimer(eXDPortTovArray[i].getFliTov(), eXDPortTovArray[i].getPliTov(), eXDPortTovArray[i].getMargin(), eXDPortTovArray[i].getPortId());
        }
        Arrays.sort(this.mPortTimer, COMP_PORT_ID);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    End PortTov. ");
        stringBuffer.append("<Time = ").append(l2 - l).append(" ms>");
        Utility.putLog(LOG_NAME, stringBuffer.toString());
    }

    public PortTimer getPortTimer(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        PortTimer portTimer = mDefaultPortTimer;
        int n = Arrays.binarySearch(this.mPortTimer, robj_interface_RJiPortIndex, COMP_PORT_ID);
        if (n >= 0) {
            portTimer = this.mPortTimer[n];
        }
        return portTimer;
    }

    public Robj_interface_RJiPortAttributeInfoDetail getPortAttribute(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        Robj_interface_RJiPortAttributeInfoDetail robj_interface_RJiPortAttributeInfoDetail = null;
        int n = Arrays.binarySearch(this.mPortAtr, robj_interface_RJiPortIndex);
        if (n >= 0) {
            robj_interface_RJiPortAttributeInfoDetail = this.mPortAtr[n];
        }
        return robj_interface_RJiPortAttributeInfoDetail;
    }

    public boolean isModify(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        boolean bl = false;
        int n = Arrays.binarySearch(this.mPortInfo, robj_interface_RJiPortIndex);
        if (n >= 0) {
            bl = this.mModifyCount[n] > 0;
        }
        return bl;
    }

    void setModify(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex, boolean bl) {
        int n = Arrays.binarySearch(this.mPortInfo, robj_interface_RJiPortIndex);
        if (n >= 0) {
            if (bl) {
                int n2 = n;
                this.mModifyCount[n2] = this.mModifyCount[n2] + 1;
            } else if (this.mModifyCount[n] > 0) {
                int n3 = n;
                this.mModifyCount[n3] = this.mModifyCount[n3] - 1;
            }
        }
    }

    public int getStatus(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        int n = 0;
        int n2 = Arrays.binarySearch(this.mPortInfo, robj_interface_RJiPortIndex);
        if (n2 >= 0) {
            n = this.mStatus[n2];
        }
        return n;
    }

    void setStatus(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex, int n) {
        int n2 = Arrays.binarySearch(this.mPortInfo, robj_interface_RJiPortIndex);
        if (n2 >= 0) {
            this.mStatus[n2] = n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

