/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.identity;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComSpringUtilities;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcLabelPanel;
import sanproject.client.com.RJcListPanel;
import sanproject.client.com.RJcMainTitlePanel;
import sanproject.client.com.RJcPanel;
import sanproject.client.com.RJcTabPanel;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.client.data.RJDataStartParam;
import sanproject.client.identity.RJComTextFieldIdentity;
import sanproject.client.identity.RJIdentifyInf;
import sanproject.client.identity.RJIdentityDVPanel;
import sanproject.client.identity.RJIdentityGetData;
import sanproject.client.status.DataControlFontModel;
import sanproject.client.status.FontManager;
import sanproject.common.RCobj_interface_CheckRet;
import sanproject.serverux.data.RmiClassLibVersionSx;

public class RJIdentityPanel
extends RJcTabPanel {
    RJIdentifyInf m_IdentityInf;
    JLabel m_ProdNameLabel = new JLabel();
    JLabel m_SerialNumLabel = new JLabel();
    JLabel m_IPaddressLabel = new JLabel();
    JLabel m_SvrFwLabel = new JLabel();
    JLabel m_SVPFwLabel = new JLabel();
    JLabel m_MainFwLabel = new JLabel();
    JPanel m_DevViewPanel = new JPanel();
    JPanel m_DevViewBase = new JPanel();
    JLabel m_DevImgLabel = new JLabel();
    JLabel m_DevNameLabel = new JLabel();
    RJComTextFieldIdentity m_NickText = new RJComTextFieldIdentity();
    RJComTextFieldIdentity m_ContText = new RJComTextFieldIdentity();
    RJComTextFieldIdentity m_LocaText = new RJComTextFieldIdentity();
    JButton m_ApplyBtn = new JButton();
    JButton m_CancelBtn = new JButton();
    boolean bDsp;
    boolean m_iPermission = false;
    static final int FUNC_ID = 110;
    static final int My_FUNC_ID = 8210;
    static final int NO_APPLY_DATA_MSG = 5030;
    static final int SPACE_ERROR_MSG = 1110;
    static final int MAXIMUM = 180;
    RJIdentityDVPanel m_IdentityDVPanel;
    RJIdentityGetData guid;
    private Timer m_RepTimer = new Timer(1000, null);
    public static final int OEM_HITACHI = 1;
    public static final int OEM_HP = 2;
    public static final int OEMTYPE_HITACHI_J = 65536;
    public static final int OEMTYPE_HITACHI = 81920;
    public static final int OEMTYPE_HP_J = 131072;
    public static final int OEMTYPE_HP = 147456;

    public RJIdentityPanel() {
        Object object;
        try {
            this.InitFont();
            this.m_IdentityInf = new RJIdentifyInf(this.m_DataControl);
            object = this.m_DataControl.getStartParamClass();
            this.m_iPermission = ((RJDataStartParam)object).getPermissionTABOption(0, 1);
            this.RJIdentityPanel_jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initInstance();
        object = this.guid.BASEPANEl.getColor();
        this.setOpaque(true);
        this.setBackground((Color)object);
    }

    void RJIdentityPanel_jbInit() throws Exception {
        this.guid = new RJIdentityGetData(this.getDataCtl());
        RJIdentityGetData.getGuidance(this.getDataCtl());
        this.bDsp = false;
        FontManager fontManager = FontManager.getInstance();
        Font font = fontManager.getViewLabelFont();
        this.m_SerialNumLabel.setFont(font);
        this.m_SerialNumLabel.setForeground(this.guid.SERIALNUM.getColor());
        this.m_SerialNumLabel.setText("");
        this.m_IPaddressLabel.setFont(font);
        this.m_IPaddressLabel.setForeground(this.guid.IPADDRESS.getColor());
        this.m_IPaddressLabel.setText("");
        this.m_NickText.setForeground(this.guid.NICKTEXT.getColor());
        this.m_NickText.setBackground(Color.lightGray);
        this.m_NickText.setFont(font);
        this.m_NickText.setMaxLen(180);
        this.m_NickText.setColumns(12);
        this.m_ContText.setForeground(this.guid.CONTTEXT.getColor());
        this.m_ContText.setBackground(Color.lightGray);
        this.m_ContText.setFont(font);
        this.m_ContText.setMaxLen(180);
        this.m_ContText.setColumns(12);
        this.m_LocaText.setForeground(this.guid.LOCATEXT.getColor());
        this.m_LocaText.setBackground(Color.lightGray);
        this.m_LocaText.setFont(font);
        this.m_LocaText.setMaxLen(180);
        this.m_LocaText.setColumns(12);
        this.m_MainFwLabel.setFont(font);
        this.m_MainFwLabel.setForeground(this.guid.MAINFW.getColor());
        this.m_MainFwLabel.setText("");
        this.m_SVPFwLabel.setFont(font);
        this.m_SVPFwLabel.setForeground(this.guid.SVPFW.getColor());
        this.m_SVPFwLabel.setText("");
        this.m_SVPFwLabel.setVerticalAlignment(0);
        this.m_SVPFwLabel.setHorizontalAlignment(0);
        this.m_SvrFwLabel.setFont(font);
        this.m_SvrFwLabel.setForeground(this.guid.SVRFW.getColor());
        this.m_SvrFwLabel.setText("");
        this.m_DevImgLabel.setBounds(new Rectangle(10, 10, 210, 108));
        this.m_DevImgLabel.setBackground(this.guid.DEVICON.getColor());
        this.m_DevNameLabel.setText("");
        this.m_DevNameLabel.setFont(font);
        this.m_DevNameLabel.setBounds(new Rectangle(10, 136, 210, 28));
        this.m_DevNameLabel.setHorizontalAlignment(0);
        this.m_DevNameLabel.setForeground(this.guid.DEVNAME.getColor());
        Color color = this.guid.DEVVIEWPANEL.getColor();
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 4, 4, 4, color);
        this.m_DevViewBase.setLayout(null);
        this.m_DevViewBase.setBackground(this.guid.DEVVIEWBASE.getColor());
        this.m_DevViewBase.setPreferredSize(new Dimension(244, 164));
        this.m_DevViewBase.setBorder(matteBorder);
        this.m_DevViewBase.add((Component)this.m_DevNameLabel, null);
        this.m_DevViewBase.add((Component)this.m_DevImgLabel, null);
        this.m_IdentityDVPanel = new RJIdentityDVPanel(this.guid);
        this.m_IdentityDVPanel.setBounds(new Rectangle(4, 258, 792, 250));
        this.m_ApplyBtn.setForeground(this.guid.APPLYBTN.getColor());
        this.m_ApplyBtn.setBackground(this.guid.APPLYBTNBGCLR.getColor());
        this.m_ApplyBtn.setFont(font);
        this.m_ApplyBtn.setText(this.guid.APPLYBTN.getGuidance());
        this.m_ApplyBtn.setPreferredSize(new Dimension(90, 24));
        this.m_ApplyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJIdentityPanel.this.IdeApplyFunc(actionEvent);
            }
        });
        this.m_CancelBtn.setForeground(this.guid.CANCELBTN.getColor());
        this.m_CancelBtn.setBackground(this.guid.CANCELBTNBGCLR.getColor());
        this.m_CancelBtn.setText(this.guid.CANCELBTN.getGuidance());
        this.m_CancelBtn.setFont(font);
        this.m_CancelBtn.setPreferredSize(new Dimension(90, 24));
        this.m_CancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJIdentityPanel.this.IdeCancelFunc(actionEvent);
            }
        });
        this.m_RepTimer.setRepeats(false);
        this.m_RepTimer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJIdentityPanel.this.RepTimerEvent();
            }
        });
    }

    private void dspIdentityInfo(RJIdentifyInf rJIdentifyInf) {
        this.m_ProdNameLabel.setText(rJIdentifyInf.ProductName);
        this.m_SerialNumLabel.setText(rJIdentifyInf.DeviceNo);
        this.m_IPaddressLabel.setText(rJIdentifyInf.IPAdress);
        this.m_NickText.putText(rJIdentifyInf.Nickname);
        this.m_NickText.setForeground(rJIdentifyInf.NicknameColor);
        this.m_ContText.putText(rJIdentifyInf.Contact);
        this.m_ContText.setForeground(rJIdentifyInf.ContactColor);
        this.m_LocaText.putText(rJIdentifyInf.Location);
        this.m_LocaText.setForeground(rJIdentifyInf.LocationColor);
        this.m_MainFwLabel.setText(this.guid.MFGuid.getGuidance() + rJIdentifyInf.DKCVersion);
        this.m_SVPFwLabel.setText(this.guid.SVPGuid.getGuidance() + rJIdentifyInf.SVPVersion);
        RmiClassLibVersionSx rmiClassLibVersionSx = new RmiClassLibVersionSx();
        String string = rmiClassLibVersionSx.strRmiIFVersion;
        this.m_SvrFwLabel.setText(this.guid.ServGuid.getGuidance() + string);
        Icon icon = this.getIcon(rJIdentifyInf.DeviceIconName);
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        int n3 = (this.m_DevViewBase.getWidth() - n) / 2;
        int n4 = (this.m_DevViewBase.getHeight() - n2) / 2;
        Rectangle rectangle = this.m_DevNameLabel.getBounds();
        rectangle.x = n3;
        rectangle.width = n;
        this.m_DevImgLabel.setBounds(n3, n4, n, n2);
        this.m_DevNameLabel.setBounds(rectangle);
        this.m_DevImgLabel.setIcon(icon);
        this.m_DevNameLabel.setText(rJIdentifyInf.ProductName);
        this.m_IdentityDVPanel.setData(rJIdentifyInf, this.getDataCtl());
    }

    public boolean showPanel(boolean bl) {
        boolean bl2 = true;
        this.setVisibleGLPRCmb(bl2);
        int n = this.getm_IdentityInfo();
        if (n == 0) {
            this.dspIdentityInfo(this.m_IdentityInf);
            this.bDsp = true;
            this.idenChgEdtMode(bl);
        } else if (n >= 1 && n <= 3) {
            this.endRequest(n);
        } else {
            this.clearInfo(this.m_IdentityInf);
            this.dspIdentityInfo(this.m_IdentityInf);
            this.idenChgEdtMode(false);
        }
        this.m_RepTimer.start();
        return n == 0;
    }

    public int getm_IdentityInfo() {
        int n = 0;
        if (!this.m_IdentityInf.getIdentify(this.m_DataControl)) {
            this.putLog("[Identify Screen]", "[tab]", "get failed.", 0);
            ArrayList arrayList = this.getDataCtl().getEndStatus();
            RJDataMsg rJDataMsg = this.getMsg((Integer)arrayList.get(0), (Integer)arrayList.get(1));
            Object[] objectArray = new Object[]{"OK"};
            RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            n = -1;
            int n2 = rJDataMsg.getErrorLevel();
            n = n2 == 0 ? -1 : n2;
        }
        return n;
    }

    void IdeApplyFunc(ActionEvent actionEvent) {
        this.putLog("[Identity]", "[Apply]", "start", 0);
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = new Object[]{"OK"};
        if (!this.isIndetifyUpdate()) {
            this.putLog("[Identity]", "[Apply]", "no edit", 0);
            RJDataMsg rJDataMsg = this.getMsg(110, 5030);
            int n = RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            return;
        }
        if (!this.checkSpace()) {
            this.putLog("[Identity]", "[Apply]", "Space Error", 0);
            RJDataMsg rJDataMsg = this.getMsg(8210, 1110);
            int n = RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            return;
        }
        arrayList.add(this.m_NickText.getText());
        arrayList.add(this.m_ContText.getText());
        arrayList.add(this.m_LocaText.getText());
        this.putLog("[Identity]", "[Apply]", "" + this.m_NickText.getText() + ":" + this.m_ContText.getText() + ":" + this.m_LocaText.getText(), 0);
        int n = this.m_IdentityInf.SetIdentifyData(this.m_DataControl, arrayList);
        if (n != 0) {
            this.putLog("[Identity]", "[Apply]", "set the data failed.", 0);
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            ArrayList arrayList2 = this.getDataCtl().getEndStatus();
            RJDataMsg rJDataMsg = this.getMsg((Integer)arrayList2.get(0), (Integer)arrayList2.get(1));
            RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            return;
        }
        this.putLog("[Identity]", "[Apply]", "set the data to saver", 0);
        int n2 = this.apply(true);
        this.putLog("[Identity]", "[Apply]", "start: sts=" + n2, 0);
        if (n2 != 0) {
            if (n2 == 2) {
                this.m_DataControl.Cancel();
            }
        } else {
            RJDataControl rJDataControl = this.getDataCtl();
            rJDataControl.waitDC();
        }
    }

    public void applyEnd(boolean bl) {
        this.putLog("[Identity]", "[Apply]", "rlt=" + bl, 0);
        if (bl) {
            this.m_IdentityInf.NicknameColor = Color.black;
            this.m_IdentityInf.ContactColor = Color.black;
            this.m_IdentityInf.LocationColor = Color.black;
            this.dspIdentityInfo(this.m_IdentityInf);
            this.showApplyEndMsg();
        } else {
            int n = this.getErrLevel();
            int n2 = 0;
            this.endRequest(n, n2);
        }
    }

    void IdeCancelFunc(ActionEvent actionEvent) {
        this.putLog("[Identity]", "[Cancel]", "start.", 0);
        RJCom.waitCursor(this);
        boolean bl = this.cancel();
        if (bl) {
            this.showPanel(true);
        }
        RJCom.defCursor(this);
        this.putLog("[Identity]", "[Cancel]", "end.", 0);
    }

    public void idenChgEdtMode(boolean bl) {
        boolean bl2 = bl;
        if (!this.m_iPermission) {
            bl = false;
        }
        this.m_NickText.setEditable(bl);
        this.m_ContText.setEditable(bl);
        this.m_LocaText.setEditable(bl);
        this.m_NickText.setBackground(bl ? Color.white : Color.lightGray);
        this.m_ContText.setBackground(bl ? Color.white : Color.lightGray);
        this.m_LocaText.setBackground(bl ? Color.white : Color.lightGray);
        this.m_ApplyBtn.setEnabled(bl);
        this.m_CancelBtn.setEnabled(bl);
        this.m_IdentityDVPanel.setData(this.m_IdentityInf, this.getDataCtl());
    }

    public boolean isIndetifyUpdate() {
        if (this.m_NickText.getUpdFlg() || this.m_ContText.getUpdFlg() || this.m_LocaText.getUpdFlg()) {
            this.putLog("[Identity]", "isIndetifyUpdate()", "has been 1edit", 0);
            return true;
        }
        this.putLog("[Identity]", "isIndetifyUpdate()", "no edit", 0);
        return false;
    }

    public void SetShowWindow() {
        this.bDsp = false;
    }

    public ArrayList getProductName() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.m_IdentityInf.ProductName);
        arrayList.add(this.m_IdentityInf.SVPVersion);
        return arrayList;
    }

    public boolean chkSts() {
        this.putLog("[Identity]", "chkSts()", "" + this.isIndetifyUpdate(), 1);
        return this.isIndetifyUpdate();
    }

    public boolean chgTab() {
        boolean bl = super.chgTab();
        this.putLog("[Identity]", "chgTab()", "ret=" + bl, 1);
        return bl;
    }

    public void rmvObj() {
        this.putLog("[Identity]", "rmvObj()", "start", 1);
        this.m_IdentityInf = null;
        this.m_ProdNameLabel = null;
        this.m_SerialNumLabel = null;
        this.m_IPaddressLabel = null;
        this.m_SvrFwLabel = null;
        this.m_SVPFwLabel = null;
        this.m_MainFwLabel = null;
        this.m_DevViewPanel = null;
        this.m_DevViewBase = null;
        this.m_DevImgLabel = null;
        this.m_DevNameLabel = null;
        this.m_NickText = null;
        this.m_ContText = null;
        this.m_LocaText = null;
        this.m_ApplyBtn = null;
        this.m_CancelBtn = null;
        this.putLog("[Identity]", "rmvObj()", "end", 1);
    }

    private void clearInfo(RJIdentifyInf rJIdentifyInf) {
        rJIdentifyInf.ProductName = "";
        rJIdentifyInf.DeviceNo = "";
        rJIdentifyInf.IPAdress = "";
        rJIdentifyInf.Nickname = "";
        rJIdentifyInf.NicknameColor = Color.black;
        rJIdentifyInf.Contact = "";
        rJIdentifyInf.ContactColor = Color.black;
        rJIdentifyInf.Location = "";
        rJIdentifyInf.LocationColor = Color.black;
        rJIdentifyInf.DKCVersion = "";
        rJIdentifyInf.SVPVersion = "";
        rJIdentifyInf.MIBVersion = "";
        rJIdentifyInf.DeviceIconName = "";
        rJIdentifyInf.ProductName = "";
    }

    private boolean checkSpace() {
        boolean bl = true;
        String string = "";
        for (int i = 0; 3 > i; ++i) {
            string = "";
            switch (i) {
                case 0: {
                    if (!this.m_NickText.getUpdFlg()) break;
                    string = this.m_NickText.getText();
                    break;
                }
                case 1: {
                    if (!this.m_ContText.getUpdFlg()) break;
                    string = this.m_ContText.getText();
                    break;
                }
                case 2: {
                    if (!this.m_LocaText.getUpdFlg()) break;
                    string = this.m_LocaText.getText();
                }
            }
            if (string.length() == 0 || !RJComUty.HeadTaleSpaceChecker(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void RepTimerEvent() {
        this.repaint();
    }

    public void InitFont() {
        RJDataControl rJDataControl = this.getDataCtl();
        DataControlFontModel dataControlFontModel = new DataControlFontModel(rJDataControl);
        FontManager fontManager = FontManager.getInstance();
        fontManager.setFontModel(dataControlFontModel);
    }

    public int getOEMType() {
        RJDataControl rJDataControl = this.getDataCtl();
        RCobj_interface_CheckRet rCobj_interface_CheckRet = rJDataControl.getCheckRetObjSx();
        int n = rCobj_interface_CheckRet.getNOEMTYPE();
        int n2 = 0;
        int n3 = n & 0xFF0000;
        int n4 = n & 0xFF00;
        n2 = n3 == 65536 ? (n4 == 16384 ? 81920 : 65536) : (n4 == 16384 ? 147456 : 131072);
        this.putLog("[Identify]", "", "oemType=" + n + ":" + n, 0);
        return n2;
    }

    protected JComponent createCenterComponent() {
        FontManager fontManager = FontManager.getInstance();
        Font font = fontManager.getViewLabelFont();
        Object object = new RJcListPanel();
        ((RJcListPanel)object).setLabelWidth(160);
        Object object2 = this.guid.SERIALNUMLBL.getGuidance();
        ((RJcListPanel)object).addEntry((String)object2, this.m_SerialNumLabel);
        object2 = this.guid.IPADDRESSLBL.getGuidance();
        ((RJcListPanel)object).addEntry((String)object2, this.m_IPaddressLabel);
        ((RJcListPanel)object).completed();
        Serializable serializable = object;
        object2 = new RJcListPanel();
        ((RJcListPanel)object2).setLabelWidth(160);
        Object object3 = this.guid.NICKTEXTLBL.getGuidance();
        Object object4 = new BorderLayout();
        Serializable serializable2 = new JPanel();
        serializable2.setLayout((LayoutManager)object4);
        serializable2.setOpaque(false);
        serializable2.add(this.m_NickText, "West");
        ((RJcListPanel)object2).addEntry((String)object3, (JComponent)serializable2);
        object3 = this.guid.CONTTEXTLBL.getGuidance();
        object4 = new BorderLayout();
        serializable2 = new JPanel();
        serializable2.setLayout((LayoutManager)object4);
        serializable2.setOpaque(false);
        serializable2.add(this.m_ContText, "West");
        ((RJcListPanel)object2).addEntry((String)object3, (JComponent)serializable2);
        object3 = this.guid.LOCATEXTLBL.getGuidance();
        object4 = new BorderLayout();
        serializable2 = new JPanel();
        serializable2.setLayout((LayoutManager)object4);
        serializable2.setOpaque(false);
        serializable2.add(this.m_LocaText, "West");
        ((RJcListPanel)object2).addEntry((String)object3, (JComponent)serializable2);
        ((RJcListPanel)object2).completed();
        object = object2;
        object3 = new RJcListPanel();
        ((RJcListPanel)object3).setLabelWidth(160);
        object4 = new BorderLayout();
        serializable2 = new JPanel();
        serializable2.setLayout((LayoutManager)object4);
        serializable2.setOpaque(false);
        serializable2.add(this.m_MainFwLabel, "West");
        serializable2.add(this.m_SVPFwLabel, "Center");
        serializable2.add(this.m_SvrFwLabel, "East");
        object4 = this.guid.MAINFWLBL.getGuidance();
        ((RJcListPanel)object3).addEntry((String)object4, (JComponent)serializable2);
        ((RJcListPanel)object3).completed();
        object2 = object3;
        object3 = new SpringLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)object3);
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable);
        jPanel.add((Component)object);
        jPanel.add((Component)object2);
        RJComSpringUtilities.makeCompactGrid(jPanel, 3, 1, 0, 0, 8, 8);
        object2 = this.guid.DEVVIEWTITLE.getGuidance();
        object = new RJcLabelPanel();
        ((RJcLabelPanel)object).setLabel((String)object2, 0);
        object2 = new BorderLayout();
        serializable = new JPanel();
        serializable.setLayout((LayoutManager)object2);
        serializable.setOpaque(false);
        serializable.add((Component)object, "North");
        serializable.add(this.m_DevViewBase, "Center");
        object = new BorderLayout(8, 4);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)object);
        jPanel2.setOpaque(false);
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)serializable, "East");
        object3 = this.getCopyRight();
        serializable2 = this.guid.COPYRIGHT.getColor();
        object2 = new JLabel();
        ((JLabel)object2).setText((String)object3);
        ((JComponent)object2).setFont(font);
        ((JComponent)object2).setForeground((Color)serializable2);
        ((JLabel)object2).setHorizontalAlignment(4);
        object3 = new BorderLayout();
        object = new JPanel();
        ((Container)object).setLayout((LayoutManager)object3);
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)object2, "North");
        object2 = this.guid.DevInfGuid.getGuidance();
        serializable = new RJcMainTitlePanel();
        ((RJcMainTitlePanel)serializable).setMainTitle((String)object2);
        ((RJcMainTitlePanel)serializable).addExtra((JPanel)object);
        object = new BorderLayout(4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)object);
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable, "North");
        jPanel.add((Component)this.m_IdentityDVPanel, "Center");
        serializable = new BorderLayout(8, 8);
        object = new JPanel();
        ((Container)object).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)jPanel2, "North");
        ((Container)object).add((Component)jPanel, "Center");
        return object;
    }

    protected JComponent createSouthComponent() {
        Object object = new GridLayout(1, 0, 4, 4);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)object);
        jPanel.setOpaque(false);
        jPanel.add(this.m_ApplyBtn);
        jPanel.add(this.m_CancelBtn);
        object = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        BorderLayout borderLayout = new BorderLayout();
        RJcPanel rJcPanel = new RJcPanel();
        rJcPanel.setLayout(borderLayout);
        rJcPanel.setOpaque(false);
        rJcPanel.setBorder((Border)object);
        rJcPanel.add((Component)jPanel, "East");
        return rJcPanel;
    }

    public String getWindowName() {
        String string = "Identity";
        return string;
    }

    private String getCopyRight() {
        RmiClassLibVersionSx rmiClassLibVersionSx = new RmiClassLibVersionSx();
        int n = this.getOEMType();
        String string = n == 147456 ? rmiClassLibVersionSx.strCopyrightHP : rmiClassLibVersionSx.strCopyright;
        this.putLog("[Identify]", "", "copyright=" + string, 0);
        return string;
    }
}

