/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.performance.physical;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import sanproject.client.com.RJComCHA;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.monitor.com.RJHihBoolIcon;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihElement;
import sanproject.client.monitor.com.RJHihIconTable;
import sanproject.client.monitor.com.RJHihTimePair;
import sanproject.client.monitor.performance.physical.RJHihPhChpElement;
import sanproject.client.monitor.performance.physical.RJHihPhChpTableModel;
import sanproject.common.Robj_interface_RJiCHAInfoDetail;
import sanproject.serverux.arg.monitor.HIHsmCHPUseRateArgInfo;
import sanproject.serverux.arg.monitor.HIHsmPhysicalCHPUseRateArgInfo;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.HIHsmCHPCompositionInfo;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJHihPhChaElement
extends RJHihElement {
    private int clusterNo;
    private int chaNo;
    private int packageType = -1;
    private byte[] pcbMode = null;
    private int iconNo = 0;
    private HIHsmCHPCompositionInfo chps = null;
    private RJHihBoolIcon selection = new RJHihBoolIcon(false);

    public RJHihPhChaElement(int n, int n2, String string, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super(string, rJHihDataSupplier, rJcTreePanel);
        this.clusterNo = n;
        this.chaNo = n2;
    }

    public RJHihPhChaElement(String string, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super(string, rJHihDataSupplier, rJcTreePanel);
    }

    public void initDetail(Robj_interface_RJiCHAInfoDetail[] robj_interface_RJiCHAInfoDetailArray) {
        boolean bl = false;
        if (robj_interface_RJiCHAInfoDetailArray != null && robj_interface_RJiCHAInfoDetailArray.length > 0) {
            for (int i = 0; i < robj_interface_RJiCHAInfoDetailArray.length; ++i) {
                if (robj_interface_RJiCHAInfoDetailArray[i].getSCHAClusterNumber() != this.clusterNo || robj_interface_RJiCHAInfoDetailArray[i].getSCHANumber() != this.chaNo) continue;
                bl = this.supplier.isChaMixMode(this.chaNo);
                this.packageType = robj_interface_RJiCHAInfoDetailArray[i].getByCHAPackageType();
                break;
            }
            this.iconNo = this.getCHAIcon(this.packageType, this.chaNo, bl);
        }
    }

    private int getCHAIcon(int n, int n2, boolean bl) {
        int n3 = 0;
        switch (n) {
            case 100: {
                n3 = 11;
                break;
            }
            case 102: 
            case 105: {
                if (bl) {
                    n3 = 68;
                    break;
                }
                if (this.supplier.isChaHighSpeedMode(n2)) {
                    n3 = 13;
                    break;
                }
                n3 = 12;
                break;
            }
            case 101: {
                n3 = 55;
                break;
            }
            case 84: {
                n3 = 12;
                break;
            }
            default: {
                n3 = 12;
            }
        }
        return n3;
    }

    public String toString() {
        return this.name + " (" + RJComCHA.toPKPortString((byte)this.packageType) + ")";
    }

    public Icon getIcon(boolean bl) {
        Icon icon = RJHihIconTable.getIcon(this.iconNo);
        return icon;
    }

    public void selectNode(RJaTreeNode rJaTreeNode) {
        this.supplier.putLog("[Monitor]", "[Physical]", "RJHihPhChaElement.selectNode start");
        this.createChildren();
        this.model = this.saveModel;
        if (this.model == null) {
            this.model = new RJHihPhChpTableModel(this.supplier);
        }
        this.model.beginSetting();
        MonitorInfoCollection monitorInfoCollection = this.getCHPUseRate();
        this.table.createTable(this.model);
        Iterator iterator = this.children.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            RJHihPhChpElement rJHihPhChpElement = (RJHihPhChpElement)iterator.next();
            rJHihPhChpElement.collectUseRate(monitorInfoCollection, n);
            this.model.addRow(rJHihPhChpElement);
            ++n;
        }
        this.model.completeSetting();
        this.table.completedTable();
        this.supplier.putLog("[Monitor]", "[Physical]", "RJHihPhChaElement.selectNode end");
    }

    private MonitorInfoCollection getCHPUseRate() {
        MonitorInfoCollection monitorInfoCollection = null;
        RJHihTimePair rJHihTimePair = this.supplier.getMonitoringInfo().getMonitoringTime();
        int n = this.children.size();
        if (rJHihTimePair != null && n > 0) {
            Object object = null;
            object = this.getRangeKind() == 0 ? new HIHsmPhysicalCHPUseRateArgInfo(2, rJHihTimePair.getFromTime(), rJHihTimePair.getToTime(), n) : new HIHsmCHPUseRateArgInfo(2, rJHihTimePair.getFromTime(), rJHihTimePair.getToTime(), n);
            Iterator iterator = this.children.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                RJHihPhChpElement rJHihPhChpElement = (RJHihPhChpElement)iterator.next();
                object.setAllParam(n2, rJHihPhChpElement.getClusterNo(), rJHihPhChpElement.getChaNo(), rJHihPhChpElement.getChpNo());
                ++n2;
            }
            monitorInfoCollection = (MonitorInfoCollection)this.supplier.getMonitorInfo((MonArg)object);
        }
        return monitorInfoCollection;
    }

    public void setChps(HIHsmCHPCompositionInfo hIHsmCHPCompositionInfo) {
        this.chps = hIHsmCHPCompositionInfo;
    }

    private void createChildren() {
        if (this.chps != null && this.children == null) {
            this.children = new ArrayList();
            for (int i = 0; i < this.chps.getSize(); ++i) {
                int n = this.chps.getNumber(i);
                String string = this.chps.getName(i);
                RJHihPhChpElement rJHihPhChpElement = new RJHihPhChpElement(this.clusterNo, this.chaNo, n, string, this.supplier, this.treePanel);
                this.children.add(rJHihPhChpElement);
            }
            this.chps = null;
        }
    }

    public ArrayList getChilden() {
        this.createChildren();
        return this.children;
    }
}

