/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.dctl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import sanproject.client.com.RJComUty;
import sanproject.client.data.RJDataException;
import sanproject.client.data.RJDataLDEVPart;
import sanproject.client.data.RJDataPortPart;
import sanproject.client.openldevguard.dctl.ManageRsgInfo;
import sanproject.client.openldevguard.dctl.RJODGDDataControl;
import sanproject.client.openldevguard.dctl.RJODGDException;
import sanproject.client.openldevguard.dctl.com.ManageReadData;
import sanproject.client.openldevguard.dctl.com.Utility;
import sanproject.client.openldevguard.gui.logging.Logger;
import sanproject.client.openldevguard.utility.VolumeSizeConverter;
import sanproject.common.Robj_interface_RJSetGettingParamLDEV;
import sanproject.common.Robj_interface_RJiCHAInfoDetail;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail3;
import sanproject.common.Robj_interface_RJiLUSEInfoDetail;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.DKCgetLDEVInfoDetail_IN;
import sanproject.serverux.dataimpl.DKCgetLDEVInfoDetail_OUT;
import sanproject.serverux.dataimpl.RJSetGettingParamLDEV;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail3;
import sanproject.serverux.dataimpl.SanRmiInputInterface;

public class ManageLdevInfo
extends ManageReadData {
    private static final GetDataCuInfo NULL_DATA_CUINFO;
    private static final GetDataLdevInfo NULL_DATA_LDEVINFO;
    private ManageRsgInfo rsgManager;
    private static final int VMA_SIZE = 5;
    private final RJODGDDataControl druDataControl;
    private final GetDataCuInfo originalCompareData;
    private Robj_interface_RJiLDEVInfoDetail3[] ldevInfoDetail3 = null;
    private Robj_interface_RJiCHAInfoDetail[] chaInfoDetail = null;
    private static final byte PKG_TYPE_HNAS = 122;

    public ManageLdevInfo(RJODGDDataControl rJODGDDataControl) {
        super(6, "LdevInfo", rJODGDDataControl, COMP_LDKC_CU, (Object)NULL_DATA_CUINFO);
        this.druDataControl = rJODGDDataControl;
        this.originalCompareData = new GetDataCuInfo(-1, -1, null);
    }

    private boolean checkDruVolume(Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail) {
        boolean bl = false;
        if (!(robj_interface_RJiLDEVInfoDetail == null || robj_interface_RJiLDEVInfoDetail.isMFVolume() || robj_interface_RJiLDEVInfoDetail.isMiddleVolume() || robj_interface_RJiLDEVInfoDetail.isBJNLVolume() || robj_interface_RJiLDEVInfoDetail.isBSystemDisk() || robj_interface_RJiLDEVInfoDetail.isBPoolVol() || robj_interface_RJiLDEVInfoDetail.getSLUSEElmCount() == 0 || this.isFPTVolume(robj_interface_RJiLDEVInfoDetail.getSLDKC(), robj_interface_RJiLDEVInfoDetail.getSCU(), robj_interface_RJiLDEVInfoDetail.getSLDEV()))) {
            bl = true;
        }
        return bl;
    }

    public Robj_interface_RJiLDEVInfoDetail3 getLdevInfoDetail3(int n, int n2, int n3) {
        Robj_interface_RJiLDEVInfoDetail3 robj_interface_RJiLDEVInfoDetail3 = null;
        RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
        rJiLDEVIndex.setLDEVIndex((short)n, (short)n2, (short)n3);
        int n4 = Arrays.binarySearch(this.ldevInfoDetail3, rJiLDEVIndex, COMP_LDKC_CU_LDEV);
        if (n4 >= 0) {
            robj_interface_RJiLDEVInfoDetail3 = this.ldevInfoDetail3[n4];
        }
        return robj_interface_RJiLDEVInfoDetail3;
    }

    private Robj_interface_RJiLDEVInfoDetail3[] getLdevInfoDetail3(Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray) throws Exception {
        Object object;
        RJSetGettingParamLDEV rJSetGettingParamLDEV = this.makeParamData();
        DKCgetLDEVInfoDetail_IN dKCgetLDEVInfoDetail_IN = new DKCgetLDEVInfoDetail_IN();
        dKCgetLDEVInfoDetail_IN.setRJiLDEVIndex(robj_interface_RJiLDEVIndexArray);
        dKCgetLDEVInfoDetail_IN.setGettingParamLDEV((Robj_interface_RJSetGettingParamLDEV)rJSetGettingParamLDEV);
        StringBuffer stringBuffer = new StringBuffer("        The initialization of LDEV detail information3 begins. ");
        stringBuffer.append("<Num = ").append(robj_interface_RJiLDEVIndexArray.length).append(">");
        Logger.put(Level.FINE, this.logName, stringBuffer.toString());
        long l = 0L;
        long l2 = 0L;
        Object[] objectArray = null;
        try {
            l = System.currentTimeMillis();
            if (robj_interface_RJiLDEVIndexArray.length > 0) {
                object = (DKCgetLDEVInfoDetail_OUT)this.getRmiData((SanRmiInputInterface)dKCgetLDEVInfoDetail_IN);
                objectArray = object.getLDEVInfoDetail();
            } else {
                objectArray = new Robj_interface_RJiLDEVInfoDetail3[]{};
            }
            l2 = System.currentTimeMillis();
        }
        catch (RJDataException rJDataException) {
            Logger.put(Level.WARNING, this.logName, "RJDataException : getLDEVInfoDetail()");
            throw this.makeException(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        Arrays.sort(objectArray);
        object = new StringBuffer("        The initialization of LDEV detail information3 ends. ");
        ((StringBuffer)object).append("<Time = ").append(l2 - l).append(" ms> ");
        ((StringBuffer)object).append("<Num = ").append(objectArray.length).append(">");
        Logger.put(Level.FINE, this.logName, ((StringBuffer)object).toString());
        return objectArray;
    }

    private Robj_interface_RJiLDEVInfoDetail[] getLdevInfoDetail(Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray) throws Exception {
        RJSetGettingParamLDEV rJSetGettingParamLDEV = this.makeParamData();
        RJDataLDEVPart rJDataLDEVPart = this.controller.getLDEVPart();
        StringBuffer stringBuffer = new StringBuffer("        The initialization of LDEV detail information begins. ");
        stringBuffer.append("<Num = ").append(robj_interface_RJiLDEVIndexArray.length).append(">");
        Logger.put(Level.FINE, this.logName, stringBuffer.toString());
        long l = 0L;
        long l2 = 0L;
        Object[] objectArray = null;
        try {
            l = System.currentTimeMillis();
            objectArray = robj_interface_RJiLDEVIndexArray.length > 0 ? rJDataLDEVPart.getLDEVInfoDetail(robj_interface_RJiLDEVIndexArray, (Robj_interface_RJSetGettingParamLDEV)rJSetGettingParamLDEV) : new Robj_interface_RJiLDEVInfoDetail[]{};
            l2 = System.currentTimeMillis();
        }
        catch (RJDataException rJDataException) {
            Logger.put(Level.WARNING, this.logName, "RJDataException : getLDEVInfoDetail()");
            throw this.makeException(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        Arrays.sort(objectArray);
        StringBuffer stringBuffer2 = new StringBuffer("        The initialization of LDEV detail information ends. ");
        stringBuffer2.append("<Time = ").append(l2 - l).append(" ms> ");
        stringBuffer2.append("<Num = ").append(objectArray.length).append(">");
        Logger.put(Level.FINE, this.logName, stringBuffer2.toString());
        return objectArray;
    }

    private Robj_interface_RJiLUSEInfoDetail[] getLuseInfoDetail(Robj_interface_RJiLDEVInfoDetail[] robj_interface_RJiLDEVInfoDetailArray) throws Exception {
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = this.makeLuseLDEVIndexArray(robj_interface_RJiLDEVInfoDetailArray);
        RJDataLDEVPart rJDataLDEVPart = this.controller.getLDEVPart();
        StringBuffer stringBuffer = new StringBuffer("        The initialization of LUSE information begins. ");
        stringBuffer.append("<Num = ").append(robj_interface_RJiLDEVIndexArray.length).append(">");
        Logger.put(Level.FINE, this.logName, stringBuffer.toString());
        long l = 0L;
        long l2 = 0L;
        Robj_interface_RJiLUSEInfoDetail[] robj_interface_RJiLUSEInfoDetailArray = null;
        try {
            l = System.currentTimeMillis();
            robj_interface_RJiLUSEInfoDetailArray = robj_interface_RJiLDEVIndexArray.length > 0 ? rJDataLDEVPart.getLUSEInfoDetail(robj_interface_RJiLDEVIndexArray) : new Robj_interface_RJiLUSEInfoDetail[]{};
            l2 = System.currentTimeMillis();
        }
        catch (RJDataException rJDataException) {
            Logger.put(Level.INFO, this.logName, "RJDataException : getLDEVInfoDetail()");
            throw this.makeException(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        Arrays.sort(robj_interface_RJiLUSEInfoDetailArray, COMP_LUSE);
        StringBuffer stringBuffer2 = new StringBuffer("        The initialization of LUSE information ends. ");
        stringBuffer2.append("<Time = ").append(l2 - l).append(" ms> ");
        stringBuffer2.append("<Num = ").append(robj_interface_RJiLUSEInfoDetailArray.length).append(">");
        Logger.put(Level.FINE, this.logName, stringBuffer2.toString());
        return robj_interface_RJiLUSEInfoDetailArray;
    }

    private boolean isFPTVolume(int n, int n2, int n3) {
        boolean bl = false;
        Robj_interface_RJiLDEVInfoDetail3 robj_interface_RJiLDEVInfoDetail3 = this.getLdevInfoDetail3(n, n2, n3);
        if (robj_interface_RJiLDEVInfoDetail3 instanceof RJiLDEVInfoDetail3 && ((RJiLDEVInfoDetail3)robj_interface_RJiLDEVInfoDetail3).isBFptVolume()) {
            bl = true;
        }
        return bl;
    }

    private Robj_interface_RJiCHAInfoDetail[] getCHAInfoDetail() throws Exception {
        RJDataPortPart rJDataPortPart = this.controller.getPortPart();
        StringBuffer stringBuffer = new StringBuffer("        The initialization of CHA detail information begins. ");
        Logger.put(Level.FINE, this.logName, stringBuffer.toString());
        long l = 0L;
        long l2 = 0L;
        Robj_interface_RJiCHAInfoDetail[] robj_interface_RJiCHAInfoDetailArray = null;
        try {
            l = System.currentTimeMillis();
            robj_interface_RJiCHAInfoDetailArray = rJDataPortPart.getCHAInfoDetail();
            l2 = System.currentTimeMillis();
        }
        catch (RJDataException rJDataException) {
            Logger.put(Level.WARNING, this.logName, "RJDataException : getCHAInfoDetail()");
            throw this.makeException(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        StringBuffer stringBuffer2 = new StringBuffer("        The initialization of CHA detail information ends. ");
        stringBuffer2.append("<Time = ").append(l2 - l).append(" ms> ");
        stringBuffer2.append("<Num = ").append(robj_interface_RJiCHAInfoDetailArray.length).append(">");
        Logger.put(Level.FINE, this.logName, stringBuffer2.toString());
        return robj_interface_RJiCHAInfoDetailArray;
    }

    private boolean isEquipHFB() {
        boolean bl = false;
        if (this.chaInfoDetail != null) {
            for (int i = 0; i < this.chaInfoDetail.length; ++i) {
                byte by = this.chaInfoDetail[i].getByCHAPackageType();
                if (by != 122) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private ArrayList makeAdditionalCuInfo(ArrayList arrayList) {
        ArrayList<GetDataCuInfo> arrayList2 = new ArrayList<GetDataCuInfo>();
        GetDataCuInfo getDataCuInfo = new GetDataCuInfo(-1, -1, null);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            GetDataLdevInfo getDataLdevInfo = (GetDataLdevInfo)iterator.next();
            short s = getDataLdevInfo.ldevInfoDetail.getSLDKC();
            short s2 = getDataLdevInfo.ldevInfoDetail.getSCU();
            short s3 = getDataLdevInfo.ldevInfoDetail.getSLDEV();
            if (getDataCuInfo.getSLDKC() != s || getDataCuInfo.getSCU() != s2) {
                Object[] objectArray = new GetDataLdevInfo[256];
                Arrays.fill(objectArray, NULL_DATA_LDEVINFO);
                getDataCuInfo = new GetDataCuInfo(s, s2, (GetDataLdevInfo[])objectArray);
                arrayList2.add(getDataCuInfo);
            }
            ((GetDataCuInfo)getDataCuInfo).ldevInfo[s3] = getDataLdevInfo;
        }
        return arrayList2;
    }

    private ArrayList makeAdditionalLdevInfo(ArrayList arrayList) throws Exception {
        ArrayList<GetDataLdevInfo> arrayList2 = new ArrayList<GetDataLdevInfo>();
        Object[] objectArray = new Robj_interface_RJiLDEVIndex[arrayList.size()];
        objectArray = arrayList.toArray(objectArray);
        Arrays.sort(objectArray);
        Robj_interface_RJiLDEVInfoDetail[] robj_interface_RJiLDEVInfoDetailArray = this.getLdevInfoDetail((Robj_interface_RJiLDEVIndex[])objectArray);
        for (int i = 0; i < robj_interface_RJiLDEVInfoDetailArray.length; ++i) {
            GetDataLdevInfo getDataLdevInfo = new GetDataLdevInfo();
            getDataLdevInfo.ldevInfoDetail = robj_interface_RJiLDEVInfoDetailArray[i];
            getDataLdevInfo.druVolume = false;
            GetDataLdevInfo.access$302(getDataLdevInfo, new Robj_interface_RJiLDEVIndex[0]);
            arrayList2.add(getDataLdevInfo);
        }
        return arrayList2;
    }

    private ArrayList makeAdditionalLdevIndex(Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray) {
        ArrayList<RJiLDEVIndex> arrayList = new ArrayList<RJiLDEVIndex>();
        if (robj_interface_RJiLDEVIndexArray.length > 1) {
            int n = this.druDataControl.getLdkc();
            int n2 = this.druDataControl.getCuGroup();
            for (int i = 1; i < robj_interface_RJiLDEVIndexArray.length; ++i) {
                short s = robj_interface_RJiLDEVIndexArray[i].getSLDKC();
                int n3 = Utility.convertCuToCuGroup(robj_interface_RJiLDEVIndexArray[i].getSCU());
                if (s == n && n3 == n2) continue;
                RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
                rJiLDEVIndex.setSLDKC(robj_interface_RJiLDEVIndexArray[i].getSLDKC());
                rJiLDEVIndex.setSCU(robj_interface_RJiLDEVIndexArray[i].getSCU());
                rJiLDEVIndex.setSLDEV(robj_interface_RJiLDEVIndexArray[i].getSLDEV());
                arrayList.add(rJiLDEVIndex);
            }
        }
        return arrayList;
    }

    private GetDataLdevInfo makeGetDataLdevInfo(Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail, Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray) {
        GetDataLdevInfo getDataLdevInfo;
        if (this.rsgManager.isSystemLuLdev((Robj_interface_RJiLDEVIndex)robj_interface_RJiLDEVInfoDetail) && this.isEquipHFB()) {
            return NULL_DATA_LDEVINFO;
        }
        if (this.checkDruVolume(robj_interface_RJiLDEVInfoDetail)) {
            getDataLdevInfo = new GetDataLdevInfo();
            getDataLdevInfo.ldevInfoDetail = robj_interface_RJiLDEVInfoDetail;
            getDataLdevInfo.druVolume = true;
            GetDataLdevInfo.access$302(getDataLdevInfo, robj_interface_RJiLDEVIndexArray);
        } else if (robj_interface_RJiLDEVInfoDetail.getSLUSEElmCount() == 0) {
            getDataLdevInfo = new GetDataLdevInfo();
            getDataLdevInfo.ldevInfoDetail = robj_interface_RJiLDEVInfoDetail;
            getDataLdevInfo.druVolume = false;
            GetDataLdevInfo.access$302(getDataLdevInfo, new Robj_interface_RJiLDEVIndex[0]);
        } else {
            getDataLdevInfo = NULL_DATA_LDEVINFO;
        }
        return getDataLdevInfo;
    }

    private Robj_interface_RJiLDEVIndex[] makeGetDataLuseLdev(int n, int n2, int n3, Robj_interface_RJiLUSEInfoDetail[] robj_interface_RJiLUSEInfoDetailArray) {
        final RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
        rJiLDEVIndex.setLDEVIndex((short)n, (short)n2, (short)n3);
        Robj_interface_RJiLUSEInfoDetail robj_interface_RJiLUSEInfoDetail = new Robj_interface_RJiLUSEInfoDetail(){

            public Robj_interface_RJiLDEVIndex[] getObjLUSEIndex() {
                RJiLDEVIndex[] rJiLDEVIndexArray = new RJiLDEVIndex[]{rJiLDEVIndex};
                return rJiLDEVIndexArray;
            }

            public short getSLUSECount() {
                return 1;
            }
        };
        int n4 = Arrays.binarySearch(robj_interface_RJiLUSEInfoDetailArray, robj_interface_RJiLUSEInfoDetail, COMP_LUSE);
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = n4 >= 0 ? robj_interface_RJiLUSEInfoDetailArray[n4].getObjLUSEIndex() : robj_interface_RJiLUSEInfoDetail.getObjLUSEIndex();
        return robj_interface_RJiLDEVIndexArray;
    }

    private Robj_interface_RJiLDEVIndex[] makeLDEVIndexArray() {
        ArrayList arrayList = this.druDataControl.getEquipLDEVIndex();
        return arrayList.toArray(new Robj_interface_RJiLDEVIndex[0]);
    }

    private Robj_interface_RJiLDEVIndex[] makeLuseLDEVIndexArray(Robj_interface_RJiLDEVInfoDetail[] robj_interface_RJiLDEVInfoDetailArray) {
        ArrayList<RJiLDEVIndex> arrayList = new ArrayList<RJiLDEVIndex>();
        for (int i = 0; i < robj_interface_RJiLDEVInfoDetailArray.length; ++i) {
            if (robj_interface_RJiLDEVInfoDetailArray[i].getSLUSEElmCount() <= 1) continue;
            short s = robj_interface_RJiLDEVInfoDetailArray[i].getSLDKC();
            short s2 = robj_interface_RJiLDEVInfoDetailArray[i].getSCU();
            short s3 = robj_interface_RJiLDEVInfoDetailArray[i].getSLDEV();
            RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
            rJiLDEVIndex.setLDEVIndex(s, s2, s3);
            arrayList.add(rJiLDEVIndex);
        }
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = arrayList.toArray(new Robj_interface_RJiLDEVIndex[0]);
        return robj_interface_RJiLDEVIndexArray;
    }

    private RJSetGettingParamLDEV makeParamData() {
        RJSetGettingParamLDEV rJSetGettingParamLDEV = new RJSetGettingParamLDEV();
        rJSetGettingParamLDEV.setBBasic(true);
        rJSetGettingParamLDEV.setBSize(true);
        rJSetGettingParamLDEV.setBLUPath(true);
        rJSetGettingParamLDEV.setBPool(true);
        if (this.druDataControl.isSupportFunctionVma()) {
            rJSetGettingParamLDEV.setBVma(true);
        }
        return rJSetGettingParamLDEV;
    }

    protected Object[] getData() throws Exception {
        ArrayList<GetDataCuInfo> arrayList = new ArrayList<GetDataCuInfo>();
        ArrayList arrayList2 = new ArrayList();
        GetDataCuInfo getDataCuInfo = new GetDataCuInfo(-1, -1, null);
        Robj_interface_RJiLDEVInfoDetail[] robj_interface_RJiLDEVInfoDetailArray = this.getLdevInfoDetail(this.makeLDEVIndexArray());
        Robj_interface_RJiLUSEInfoDetail[] robj_interface_RJiLUSEInfoDetailArray = this.getLuseInfoDetail(robj_interface_RJiLDEVInfoDetailArray);
        this.ldevInfoDetail3 = this.getLdevInfoDetail3((Robj_interface_RJiLDEVIndex[])robj_interface_RJiLDEVInfoDetailArray);
        this.chaInfoDetail = this.getCHAInfoDetail();
        this.rsgManager = this.druDataControl.getRsgInfoManager();
        for (int i = 0; i < robj_interface_RJiLDEVInfoDetailArray.length; ++i) {
            GetDataLdevInfo getDataLdevInfo;
            Object[] objectArray;
            short s = robj_interface_RJiLDEVInfoDetailArray[i].getSLDKC();
            short s2 = robj_interface_RJiLDEVInfoDetailArray[i].getSCU();
            short s3 = robj_interface_RJiLDEVInfoDetailArray[i].getSLDEV();
            if (getDataCuInfo.getSLDKC() != s || getDataCuInfo.getSCU() != s2) {
                objectArray = new GetDataLdevInfo[256];
                Arrays.fill(objectArray, NULL_DATA_LDEVINFO);
                getDataCuInfo = new GetDataCuInfo(s, s2, (GetDataLdevInfo[])objectArray);
                arrayList.add(getDataCuInfo);
            }
            objectArray = this.makeGetDataLuseLdev(s, s2, s3, robj_interface_RJiLUSEInfoDetailArray);
            ArrayList arrayList3 = this.makeAdditionalLdevIndex((Robj_interface_RJiLDEVIndex[])objectArray);
            arrayList2.addAll(arrayList3);
            this.druDataControl.getGuardRetentionManager().makeAdditionalGuardRetention((Robj_interface_RJiLDEVIndex)robj_interface_RJiLDEVInfoDetailArray[i], arrayList3);
            ((GetDataCuInfo)getDataCuInfo).ldevInfo[s3] = getDataLdevInfo = this.makeGetDataLdevInfo(robj_interface_RJiLDEVInfoDetailArray[i], (Robj_interface_RJiLDEVIndex[])objectArray);
        }
        ArrayList arrayList4 = this.makeAdditionalLdevInfo(arrayList2);
        ArrayList arrayList5 = this.makeAdditionalCuInfo(arrayList4);
        arrayList.addAll(arrayList5);
        return arrayList.toArray();
    }

    protected boolean isSupport() {
        return true;
    }

    protected Exception makeException(int n, int n2) {
        return new RJODGDException(n, n2);
    }

    protected Object makeOriginalCompareData(int n, int n2, int n3) {
        this.originalCompareData.setCUIndex((short)n, (short)n2);
        return this.originalCompareData;
    }

    protected Object makeOriginalData(Object object) {
        return object;
    }

    public Robj_interface_RJiLDEVInfoDetail getLdevInfoDetail(int n, int n2, int n3) {
        GetDataCuInfo getDataCuInfo = (GetDataCuInfo)((Object)this.getOriginalDataObject(n, n2, n3));
        return getDataCuInfo.ldevInfo[n3].ldevInfoDetail;
    }

    public String getLdevString(int n, int n2, int n3) {
        Robj_interface_RJiLDEVInfoDetail3 robj_interface_RJiLDEVInfoDetail3 = this.getLdevInfoDetail3(n, n2, n3);
        String string = null;
        if (robj_interface_RJiLDEVInfoDetail3 instanceof RJiLDEVInfoDetail3) {
            string = RJComUty.getLDEVDisplayName((RJiLDEVInfoDetail3)robj_interface_RJiLDEVInfoDetail3);
        }
        if (string == null) {
            string = RJComUty.getLDEVDisplayName(this.getLdevInfoDetail(n, n2, n3));
        }
        return string;
    }

    public long getCapacity(int n, int n2, int n3) {
        return this.getLdevInfoDetail(n, n2, n3).getLLDEVSize();
    }

    public long getLbaSize(int n, int n2, int n3) {
        return this.getLdevInfoDetail(n, n2, n3).getLLDEVLBASize();
    }

    public String getEmulationType(int n, int n2, int n3) {
        int n4 = this.getLdevInfoDetail(n, n2, n3).getIEmulationType();
        return this.getChangeTbl().getEmulationTypeName(n4);
    }

    public boolean isExternal(int n, int n2, int n3) {
        return this.getLdevInfoDetail(n, n2, n3).isExternalVolume();
    }

    public boolean isDruVolume(int n, int n2, int n3) {
        GetDataCuInfo getDataCuInfo = (GetDataCuInfo)((Object)this.getOriginalDataObject(n, n2, n3));
        return getDataCuInfo.ldevInfo[n3].druVolume;
    }

    public int getLuseCount(int n, int n2, int n3) {
        return this.getLuseLdevs(n, n2, n3).length;
    }

    public Robj_interface_RJiLDEVIndex[] getLuseLdevs(int n, int n2, int n3) {
        GetDataCuInfo getDataCuInfo = (GetDataCuInfo)((Object)this.getOriginalDataObject(n, n2, n3));
        return getDataCuInfo.ldevInfo[n3].luseLdevs;
    }

    public int getPathCount(int n, int n2, int n3) {
        return this.getLdevInfoDetail(n, n2, n3).getSLUPathNumber();
    }

    public int getVmaSize(int n, int n2, int n3) {
        return (int)VolumeSizeConverter.convertVolumeSize(this.getLdevInfoDetail(n, n2, n3).getLVMASize(), "K to M");
    }

    public boolean isExtent(int n, int n2, int n3) {
        return this.getLdevInfoDetail(n, n2, n3).isBExtent();
    }

    public boolean isVma(int n, int n2, int n3) {
        return this.getLdevInfoDetail(n, n2, n3).isBVMA();
    }

    public boolean isVVol(int n, int n2, int n3) {
        return this.getLdevInfoDetail(n, n2, n3).isVvol();
    }

    public void setDataVma(int n, int n2, int n3) {
        GetDataCuInfo getDataCuInfo = (GetDataCuInfo)((Object)this.getOriginalDataObject(n, n2, n3));
        getDataCuInfo.ldevInfo[n3].setVma();
    }

    public void clearDataVma(int n, int n2, int n3) {
        GetDataCuInfo getDataCuInfo = (GetDataCuInfo)((Object)this.getOriginalDataObject(n, n2, n3));
        getDataCuInfo.ldevInfo[n3].clearVma();
    }

    public void clearDataExtent(int n, int n2, int n3) {
        GetDataCuInfo getDataCuInfo = (GetDataCuInfo)((Object)this.getOriginalDataObject(n, n2, n3));
        getDataCuInfo.ldevInfo[n3].clearExtent();
    }

    static {
        RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
        rJiLDEVIndex.setLDEVIndex((short)-1, (short)-1, (short)-1);
        NULL_DATA_LDEVINFO = new GetDataLdevInfo();
        NULL_DATA_LDEVINFO.ldevInfoDetail = (Robj_interface_RJiLDEVInfoDetail)new RJiLDEVInfoDetail();
        NULL_DATA_LDEVINFO.ldevInfoDetail.setLDEVIndex((short)-1, (short)-1, (short)-1);
        NULL_DATA_LDEVINFO.druVolume = false;
        GetDataLdevInfo.access$302(NULL_DATA_LDEVINFO, (Robj_interface_RJiLDEVIndex[])new RJiLDEVIndex[]{rJiLDEVIndex});
        Object[] objectArray = new GetDataLdevInfo[256];
        Arrays.fill(objectArray, NULL_DATA_LDEVINFO);
        NULL_DATA_CUINFO = new GetDataCuInfo(-1, -1, (GetDataLdevInfo[])objectArray);
    }

    private static class GetDataLdevInfo {
        private boolean druVolume;
        private Robj_interface_RJiLDEVInfoDetail ldevInfoDetail;
        private Robj_interface_RJiLDEVIndex[] luseLdevs;

        private GetDataLdevInfo() {
        }

        private void setVma() {
            RJiLDEVInfoDetail rJiLDEVInfoDetail = (RJiLDEVInfoDetail)this.ldevInfoDetail;
            rJiLDEVInfoDetail.byVolumeInfo = 1;
            rJiLDEVInfoDetail.lVMASize = (long)VolumeSizeConverter.convertVolumeSize(5.0, "M to K");
        }

        private void clearVma() {
            RJiLDEVInfoDetail rJiLDEVInfoDetail = (RJiLDEVInfoDetail)this.ldevInfoDetail;
            rJiLDEVInfoDetail.byVolumeInfo = 0;
            rJiLDEVInfoDetail.lVMASize = 0L;
        }

        private void clearExtent() {
            RJiLDEVInfoDetail rJiLDEVInfoDetail = (RJiLDEVInfoDetail)this.ldevInfoDetail;
            rJiLDEVInfoDetail.byVolumeInfo = 1;
        }

        static /* synthetic */ Robj_interface_RJiLDEVIndex[] access$302(GetDataLdevInfo getDataLdevInfo, Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray) {
            getDataLdevInfo.luseLdevs = robj_interface_RJiLDEVIndexArray;
            return robj_interface_RJiLDEVIndexArray;
        }
    }

    private static class GetDataCuInfo
    extends RJiCUIndex {
        private GetDataLdevInfo[] ldevInfo;

        public GetDataCuInfo(int n, int n2, GetDataLdevInfo[] getDataLdevInfoArray) {
            this.setCUIndex((short)n, (short)n2);
            this.ldevInfo = getDataLdevInfoArray;
        }
    }
}

