/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import java.io.Serializable;
import java.util.ArrayList;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import org.wbemservices.wbem.repository.CIMClassRlogEntry;
import org.wbemservices.wbem.repository.CIMInstanceRlogEntry;
import org.wbemservices.wbem.repository.CIMNameSpaceRlogEntry;
import org.wbemservices.wbem.repository.InstanceNameUtils;
import org.wbemservices.wbem.repository.PSRlogImpl;

class CIMAssocInstanceRlogEntry
extends CIMInstanceRlogEntry {
    private static final long serialVersionUID = -2882512481198693722L;
    private CIMObjectPath sp;
    private AssocInsRole[] roles = new AssocInsRole[0];

    public CIMAssocInstanceRlogEntry(CIMNameSpaceRlogEntry nsentry, String name) {
        super(nsentry, name);
    }

    public void addInstanceAssociations(String assoc, CIMAssocInstanceRlogEntry ciref) throws WBEMException {
        this.validateInstanceAssociations();
        for (AssocInsRole role : this.roles) {
            CIMInstanceRlogEntry citemp = role.ccentry.getInstance(role.ci);
            citemp.addAssociations(assoc, ciref);
        }
    }

    public void createAssciations(CIMInstance ci) throws WBEMException {
        this.sp = new CIMObjectPath(null, null, null, this.nsentry.getName(), ci.getClassName(), ci.getKeys());
        this.roles = this.createAssociationInsPropList(ci);
    }

    private AssocInsRole[] createAssociationInsPropList(CIMInstance ci) throws WBEMException {
        ArrayList<AssocInsRole> v = new ArrayList<AssocInsRole>();
        try {
            for (CIMProperty pe : ci.getProperties()) {
                if (pe.getDataType().getType() != 14) continue;
                if (pe.getValue() == null) {
                    throw new WBEMException(4, "The REF property " + pe.getName() + " value must be initialized");
                }
                Object op = pe.getValue();
                if (!(op instanceof CIMObjectPath)) continue;
                String ccstr = ((CIMObjectPath)op).getObjectName();
                String ns = ((CIMObjectPath)op).getNamespace();
                CIMNameSpaceRlogEntry nsentryTMP = PSRlogImpl.getNameSpaceEntryFromMap(ns, WBEMOperation.OPENASSOCIATORS);
                CIMClassRlogEntry cctemp = nsentryTMP.getClass(ccstr);
                v.add(new AssocInsRole(cctemp, InstanceNameUtils.getInstanceNameKey((CIMObjectPath)op), pe.getName(), (CIMObjectPath)op));
            }
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString());
        }
        AssocInsRole[] arr = new AssocInsRole[v.size()];
        v.toArray(arr);
        return arr;
    }

    public CIMObjectPath matchAssociator(String iname, String role, String resultRole) {
        boolean roleMatch = false;
        boolean resultRoleMatch = false;
        if (resultRole == null || resultRole.length() == 0) {
            resultRoleMatch = true;
        }
        for (AssocInsRole role2 : this.roles) {
            if (!roleMatch && role2.ci.equals(iname)) {
                if (role == null || role.length() == 0) {
                    roleMatch = true;
                }
                if (!roleMatch && role2.role.equalsIgnoreCase(role)) {
                    roleMatch = true;
                }
            }
            if (resultRoleMatch || !role2.role.equalsIgnoreCase(resultRole)) continue;
            resultRoleMatch = true;
        }
        if (roleMatch && resultRoleMatch) {
            return new CIMObjectPath(null, null, null, this.sp.getNamespace(), this.sp.getObjectName(), this.sp.getKeys());
        }
        return null;
    }

    public ArrayList<CIMObjectPath> matchRole(String iname, String role, String resultRole) {
        ArrayList<CIMObjectPath> v = new ArrayList<CIMObjectPath>();
        ArrayList<String> arr = new ArrayList<String>();
        boolean isReflective = false;
        boolean match = false;
        boolean rolematch = false;
        for (AssocInsRole role2 : this.roles) {
            if (!role2.ci.equals(iname)) continue;
            if (role != null && role.length() != 0) {
                if (role2.role.equalsIgnoreCase(role)) {
                    rolematch = true;
                }
            } else {
                rolematch = true;
            }
            if (match) {
                isReflective = true;
            }
            match = true;
        }
        if (!match || !rolematch) {
            return v;
        }
        match = false;
        for (int i = 0; i < this.roles.length; ++i) {
            if (!isReflective && this.roles[i].ci.equals(iname) || resultRole != null && resultRole.length() != 0 && !this.roles[i].role.equalsIgnoreCase(resultRole)) continue;
            boolean exist = false;
            for (int k = 0; k < arr.size(); ++k) {
                if (!this.roles[i].ci.equals(arr.get(k))) continue;
                exist = true;
            }
            if (exist) continue;
            arr.add(this.roles[i].ci);
            v.add(this.roles[i].op);
        }
        return v;
    }

    public void removeInstanceAssociations(String assoc, String iname) throws WBEMException {
        this.validateInstanceAssociations();
        for (AssocInsRole role : this.roles) {
            CIMInstanceRlogEntry citemp = role.ccentry.getInstance(role.ci);
            citemp.removeAssociations(assoc, iname);
        }
    }

    public void validateInstanceAssociations() throws WBEMException {
        for (AssocInsRole role : this.roles) {
            CIMInstanceRlogEntry citemp = role.ccentry.getInstance(role.ci);
            if (citemp != null) continue;
            throw new WBEMException(6, role.ci);
        }
    }

    private static class AssocInsRole
    implements Serializable {
        private static final long serialVersionUID = -9194790923204199116L;
        public CIMClassRlogEntry ccentry;
        public String ci;
        public String role;
        public CIMObjectPath op;

        public AssocInsRole(CIMClassRlogEntry ccentry, String ci, String role, CIMObjectPath op) {
            this.ccentry = ccentry;
            this.ci = ci;
            this.role = role;
            this.op = op;
        }
    }
}

