/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sun.net.www.protocol.http.HttpURLConnection;

public class RMISSLTunnelSocketFactory
extends SSLSocketFactory
implements Serializable {
    private String tunnelHost = null;
    private int tunnelPort = 0;

    public RMISSLTunnelSocketFactory(String string, String string2) {
        this.tunnelHost = string;
        if (string2 != null) {
            this.tunnelPort = Integer.parseInt(string2);
        }
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.createSocket(null, string, n, true);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.createSocket(null, string, n, true);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.createSocket(null, inetAddress.getHostName(), n, true);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return this.createSocket(null, inetAddress.getHostName(), n, true);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        return this.createSocket(socket, string, n, bl, null);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl, SSLSocketFactory sSLSocketFactory) throws IOException, UnknownHostException {
        Socket socket2 = null;
        if (this.tunnelHost == null || this.tunnelHost.equals("")) {
            socket2 = new Socket(string, n);
        } else {
            socket2 = new Socket(this.tunnelHost, this.tunnelPort);
            this.doTunnelHandshake(socket2, string, n);
        }
        SSLSocket sSLSocket = null;
        Object var8_8 = null;
        if (sSLSocketFactory == null) {
            SSLSocketFactory sSLSocketFactory2 = (SSLSocketFactory)SSLSocketFactory.getDefault();
            sSLSocket = (SSLSocket)sSLSocketFactory2.createSocket(socket2, string, n, bl);
        } else {
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket2, string, n, bl);
        }
        return sSLSocket;
    }

    private void doTunnelHandshake(Socket socket, String string, int n) throws IOException {
        String string2;
        byte[] byArray;
        OutputStream outputStream = socket.getOutputStream();
        String string3 = "CONNECT " + string + ":" + n + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
        try {
            byArray = string3.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string3.getBytes();
        }
        outputStream.write(byArray);
        outputStream.flush();
        byte[] byArray2 = new byte[200];
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        InputStream inputStream = socket.getInputStream();
        boolean bl2 = false;
        while (n3 < 2) {
            int n4 = inputStream.read();
            if (n4 < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (n4 == 10) {
                bl = true;
                ++n3;
                continue;
            }
            if (n4 == 13) continue;
            n3 = 0;
            if (bl || n2 >= byArray2.length) continue;
            byArray2[n2++] = (byte)n4;
        }
        try {
            string2 = new String(byArray2, 0, n2, "ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(byArray2, 0, n2);
        }
        if (string2.toLowerCase().indexOf("200 connection established") == -1) {
            throw new IOException("Unable to tunnel through " + this.tunnelHost + ":" + this.tunnelPort + ".  Proxy returns \"" + string2 + "\"");
        }
    }

    public String[] getDefaultCipherSuites() {
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        return sSLSocketFactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        return sSLSocketFactory.getSupportedCipherSuites();
    }
}

