/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.com;

import java.io.PrintStream;

public class RJMdProgress {
    private PrintStream stream = System.out;
    private static final int MAX_POINT = 51;
    private int plot;
    private int max = 0;
    private int cur;
    private boolean retryFlag = false;

    public RJMdProgress() {
        this(System.out);
    }

    public RJMdProgress(PrintStream printStream) {
        this.stream = printStream;
    }

    public void init(int n) {
        this.max = n;
        this.cur = 0;
        this.plot = 0;
        this.retryFlag = false;
        if (n > 0) {
            this.stream.println("+----+----+----+----+----+----+----+----+----+----+");
        }
    }

    public void addProgress(int n) {
        if (this.retryFlag) {
            this.reset();
            this.retryFlag = false;
        }
        this.cur += n;
        int n2 = this.cur >= this.max ? 51 : (int)(51.0 * (double)this.cur / (double)this.max);
        this.printProgress(n2);
    }

    public void close() {
        this.printProgress(51);
        this.plot = 0;
    }

    private void printProgress(int n) {
        if (this.max > 0 && n > this.plot) {
            n -= this.plot;
            for (int i = 0; i < n; ++i) {
                this.stream.print(".");
                this.stream.flush();
            }
            this.plot += n;
            if (this.plot >= 51) {
                this.stream.println("");
                this.stream.flush();
            }
        }
    }

    public void retry() {
        this.stream.print("!");
        this.retryFlag = true;
        ++this.plot;
    }

    public void reset() {
        if (this.plot > 0) {
            this.stream.println("");
            this.plot = 0;
        }
    }
}

