/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataPort;
import sanproject.getmondat.data.RJMdDataWWN;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitParallelStream;
import sanproject.serverux.arg.monitor.ArgWWNperPortAbility;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.data.PPCWWNperPortAbility;

public class RJMdGroupPortWWN
extends RJMdGroupData {
    private static final String groupID = "PortWWN";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "PortWWN_dat";
    private static final String groupInfo = "PortWWN data";
    private RJMdUnitParallelStream stream = null;
    public final int LIMIT_PARAMS_PortWWN;
    public static final int LIMIT_PARAMS_PortWWN_RAID = 256;
    public static final int LIMIT_PARAMS_PortWWN_HM = 128;
    public static final int KIND_TARGET = 1;
    private static final String EN_PortWWN_IOPS = "PortWWN_{0}_IOPS{1}";
    private static final String EN_PortWWN_KBPS = "PortWWN_{0}_KBPS{1}";
    private static final String EN_PortWWN_Response = "PortWWN_{0}_Response{1}";
    private static final String[] entryNames = new String[]{"PortWWN_{0}_IOPS{1}", "PortWWN_{0}_KBPS{1}", "PortWWN_{0}_Response{1}"};

    public RJMdGroupPortWWN(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
        this.LIMIT_PARAMS_PortWWN = rJMdDataControl.isHM() ? 128 : 256;
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitParallelStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
        this.stream.setIndirect(true);
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupPortWWN();
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupPortWWN() throws RJMdRmiException, IOException {
        this.putInfomation("INF006", this.getGroupInfo());
        HashMap<String, RJMdUnitEntry> hashMap = new HashMap<String, RJMdUnitEntry>();
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        CollectParam collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        super.createGroup();
        ArrayList arrayList = this.controller.getPort(1);
        this.initProgress(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPort)) continue;
            int n = rJMdDataPort.getPortID();
            String string = this.getSimplePortName(rJMdDataPort.getPortName());
            String string2 = this.getFileNo(string);
            for (int i = 0; i < entryNames.length; ++i) {
                object2 = new MessageFormat(entryNames[i]);
                object = ((Format)object2).format(new String[]{string, string2});
                RJMdUnitEntry rJMdUnitEntry = this.stream.createEntry((String)object, this.getTimeRange());
                hashMap.put(entryNames[i] + n, rJMdUnitEntry);
            }
            ArrayList arrayList2 = this.controller.getPortToWWN(n);
            object2 = arrayList2.iterator();
            while (object2.hasNext()) {
                object = (RJMdDataWWN)object2.next();
                if (collectParam.size() >= this.LIMIT_PARAMS_PortWWN) {
                    this.collect(hashMap, collectParam);
                    this.addProgress(collectParam.size());
                    collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
                }
                collectParam.add(rJMdDataPort, (RJMdDataWWN)object);
            }
        }
        this.collect(hashMap, collectParam);
        this.addProgress(collectParam.size());
        this.stream.flushAll();
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private void initProgress(ArrayList arrayList) throws RJMdRmiException {
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
            int n3 = rJMdDataPort.getPortID();
            ArrayList arrayList2 = this.controller.getPortToWWN(n3);
            n2 += arrayList2.size();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPort)) continue;
            n += arrayList2.size();
        }
        super.initProgress(n, n2);
    }

    private String getSimplePortName(String string) {
        String string2 = string;
        if (string.startsWith("CL")) {
            string = string.substring(2);
            string2 = "";
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '-') continue;
                string2 = string2 + c;
            }
        }
        return string2;
    }

    public void collect(HashMap hashMap, CollectParam collectParam) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                PPCWWNperPortAbility pPCWWNperPortAbility = (PPCWWNperPortAbility)monitorInfoCollection.get(i);
                String string = collectParam.getNickname(pPCWWNperPortAbility.getWWNbytes());
                String string2 = this.toWWNString(pPCWWNperPortAbility.getWWNbytes()) + "(" + string + ")";
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PortWWN_IOPS + pPCWWNperPortAbility.getPortID()), new RJMdColumn(string2, pPCWWNperPortAbility.getAvrIOPerSec()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PortWWN_KBPS + pPCWWNperPortAbility.getPortID()), new RJMdColumn(string2, pPCWWNperPortAbility.getAvrTransRate()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PortWWN_Response + pPCWWNperPortAbility.getPortID()), new RJMdColumn(string2, pPCWWNperPortAbility.getResponseTime()));
            }
        }
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePortRange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tPort =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }

    class CollectParam {
        private ArrayList wwnList = new ArrayList();
        private ArgWWNperPortAbility params = null;

        CollectParam(Date date, Date date2) {
            this.params = new ArgWWNperPortAbility(1, date, date2);
        }

        public int size() {
            return this.params.size();
        }

        public void add(RJMdDataPort rJMdDataPort, RJMdDataWWN rJMdDataWWN) {
            this.wwnList.add(rJMdDataWWN);
            this.params.addPortWWN(rJMdDataPort.getPortID(), rJMdDataWWN.getWWN());
        }

        public String getNickname(byte[] byArray) {
            String string = "";
            Iterator iterator = this.wwnList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                RJMdDataWWN rJMdDataWWN = (RJMdDataWWN)iterator.next();
                boolean bl = true;
                for (int i = 0; i < 8; ++i) {
                    if (byArray[i] == rJMdDataWWN.getWWN()[i]) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    string = rJMdDataWWN.getNickname();
                }
                ++n;
            }
            return string;
        }

        public ArgWWNperPortAbility getArgument() {
            return this.params;
        }
    }
}

