/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.ldapcheckgroup;

import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalGroupBooleanInfo;
import sanproject.sn2.base.authentication.module.external.common.SJbaseSrvRecord;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.ldapcheckgroup.SJbaseLdapCheckGroupConfigurationFactory;
import sanproject.sn2.base.authentication.module.external.ldapcheckgroup.SJbaseLdapCheckGroupModuleThread;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseLdapCheckGroupModule {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseLdapCheckGroupModule";
    private Properties checkGroupProperties;
    private String groupDN;
    private SJbaseLdapGroupConfiguration[] groupCheckConf = null;

    public SJbaseLdapCheckGroupModule(Properties checkGroupProperties, String groupDN) {
        String method = "constructor";
        logger.info(module, method, "", "start");
        this.checkGroupProperties = checkGroupProperties;
        this.groupDN = groupDN;
        logger.info(module, method, "", "end");
    }

    public SJbaseExternalGroupBooleanInfo inquire() throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        String method = "inquire";
        logger.info(module, method, "", "srart");
        if (this.groupDN == null || this.groupDN.length() == 0) {
            logger.info(module, method, "check the groupDN", "invalid");
            throw new SJbaseExCommunicationException();
        }
        this.groupCheckConf = new SJbaseLdapCheckGroupConfigurationFactory(this.checkGroupProperties).getGroupConfigurations();
        if (this.groupCheckConf == null) {
            logger.info(module, method, "check the configuration objectes", "invalid");
            throw new SJbaseExCommunicationException();
        }
        String[] hostList = null;
        for (int i = 0; i < this.groupCheckConf.length; ++i) {
            SJbaseLdapGroupConfiguration tmpConf = this.groupCheckConf[i];
            logger.info(module, method, "start the check group process", "server :[" + i + "]");
            try {
                if (tmpConf.getDnsLookup().equalsIgnoreCase("true")) {
                    logger.info(module, method, "use dns look up", "");
                    hostList = new SJbaseSrvRecord(tmpConf.getProtocol(), tmpConf.getDomainName()).getServerList();
                    for (int j = 0; j < hostList.length; ++j) {
                        String[] tmpList = hostList[j].split(",");
                        tmpConf.setPort(Integer.parseInt(tmpList[2]));
                        tmpConf.setHost(tmpList[3].substring(0, tmpList[3].length() - 1));
                        try {
                            SJbaseExternalGroupBooleanInfo groupInfo = this.inquire(tmpConf);
                            logger.info(module, method, "authenticate the user", "succeeded, server :[" + i + "]");
                            logger.info(module, method, "", "end");
                            return groupInfo;
                        }
                        catch (SJbaseExCommunicationException e) {
                            logger.info(module, method, "authenticate the user", "failed, server :[" + i + "]", e);
                            continue;
                        }
                    }
                    continue;
                }
                logger.info(module, method, "unuse dns look up", "");
                SJbaseExternalGroupBooleanInfo groupInfo = this.inquire(tmpConf);
                return groupInfo;
            }
            catch (SJbaseExCommunicationException e) {
                logger.info(module, method, "authenticate the user", "failed, server :[" + i + "]", e);
                continue;
            }
            catch (SJbaseExAuthenticationException e) {
                logger.info(module, method, "authenticate the user", "failed, server :[" + i + "]", e);
                throw e;
            }
        }
        logger.info(module, method, "authentication the user", "failed at all servers");
        throw new SJbaseExCommunicationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SJbaseExternalGroupBooleanInfo inquire(SJbaseLdapGroupConfiguration tmpConf) throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        SJbaseExCommunicationException exception;
        String method = "inquire";
        logger.info(module, method, "", "start");
        int timeoutCount = -1;
        int retryTimes = tmpConf.getRetryTimes();
        int retryInterval = tmpConf.getRetryInterval();
        do {
            if (tmpConf.getServerErrCode() == 10) {
                logger.info(module, method, "check the configuration object", "invalid");
                throw new SJbaseExCommunicationException();
            }
            String serchDN = tmpConf.getSearchDN();
            if (serchDN == null || serchDN.length() == 0) {
                logger.info(module, method, "check the serchDN", "invalid");
                throw new SJbaseExCommunicationException();
            }
            SJbaseLdapCheckGroupModuleThread ldapModuleThread = null;
            try {
                ldapModuleThread = new SJbaseLdapCheckGroupModuleThread(tmpConf, this.groupDN);
                ldapModuleThread.setDaemon(true);
                ldapModuleThread.start();
                try {
                    int timeout = tmpConf.getTimeout();
                    if (timeout == 0) {
                        logger.info(module, method, "set timeout", Integer.toString(120));
                        ldapModuleThread.join(120000L);
                    } else {
                        logger.info(module, method, "set timeout", Integer.toString(timeout));
                        ldapModuleThread.join(timeout * 1000);
                    }
                }
                catch (InterruptedException e) {
                    logger.info(module, method, "", "interrupted", e);
                }
                if (ldapModuleThread.isAlive()) {
                    logger.info(module, method, "", "no response from the server -timeout");
                    throw new SJbaseExCommunicationException();
                }
                SJbaseExternalGroupBooleanInfo groupInfo = ldapModuleThread.getInquiryResult();
                logger.info(module, method, "check the groupDN", "succeeded");
                logger.info(module, method, "", "end");
                SJbaseExternalGroupBooleanInfo e = groupInfo;
                return e;
            }
            catch (SJbaseExCommunicationException e) {
                exception = e;
                logger.info(module, method, "failed in the authentication process", "retry times :" + Integer.toString(timeoutCount + 1));
                if (++timeoutCount >= retryTimes) continue;
                try {
                    Thread.sleep(retryInterval * 1000);
                }
                catch (InterruptedException ie) {
                    logger.info(module, method, "", "interrupted", e);
                }
            }
            finally {
                if (ldapModuleThread != null) {
                    ldapModuleThread = null;
                }
            }
        } while (timeoutCount < retryTimes);
        logger.info(module, method, "authenticate the user", "failed scheduled times");
        throw exception;
    }
}

