/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.radius;

import java.util.HashMap;
import java.util.Map;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseUnsupportedAttributeException;

public class SJbaseRadiusDictionary {
    public static final String UNKNOWN = "Unknown";
    public static final String STRING = "String";
    public static final String TEXT = "Text";
    public static final String VALUE = "Value";
    public static final String INET4ADDRESS = "Inet4Address";
    public static final String INET6ADDRESS = "Inet6Address";
    public static final String INET6PREFIX = "Inet6prefix";
    public static final String INET6INTERFACE = "Inet6InterfaceId";
    public static final String VENDOR = "Vendor";
    private static String[][] data = new String[][]{{"User-Name", "1", "String"}, {"User-Password", "2", "String"}, {"CHAP-Password", "3", "String"}, {"NAS-IP-Address", "4", "Inet4Address"}, {"NAS-Port", "5", "Value"}, {"Service-Type", "6", "Value"}, {"Framed-Protocol", "7", "Value"}, {"Framed-IP-Address", "8", "Inet4Address"}, {"Framed-IP-Netmask", "9", "Inet4Address"}, {"Framed-Routing", "10", "Value"}, {"Filter-Id", "11", "String"}, {"Framed-MTU", "12", "Value"}, {"Framed-Compression", "13", "Value"}, {"Login-IP-Host", "14", "Inet4Address"}, {"Login-Service", "15", "Value"}, {"Login-TCP-Port", "16", "Value"}, {"Reply-Message", "18", "String"}, {"Callback-Number", "19", "String"}, {"Callback-Id", "20", "String"}, {"Framed-Route", "22", "String"}, {"Framed-IPX-Network", "23", "Value"}, {"State", "24", "String"}, {"Class", "25", "String"}, {"Vendor-Specific", "26", "Vendor"}, {"Session-Timeout", "27", "Value"}, {"Idle-Timeout", "28", "Value"}, {"Termination-Action", "29", "Value"}, {"Called-Station-Id", "30", "String"}, {"Calling-Station-Id", "31", "String"}, {"NAS-Identifier", "32", "String"}, {"Proxy-State", "33", "String"}, {"Login-LAT-Service", "34", "String"}, {"Login-LAT-Node", "35", "String"}, {"Login-LAT-Group", "36", "String"}, {"Framed-AppleTalk-Link", "37", "Value"}, {"Framed-AppleTalk-Network", "38", "Value"}, {"Framed-AppleTalk-Zone", "39", "String"}, {"CHAP-Challeng", "60", "String"}, {"NAS-Port-Type", "61", "Value"}, {"Port-Limit", "62", "Value"}, {"Login-LAT-Port", "63", "String"}, {"NAS-IPv6-Address", "95", "Inet6Address"}, {"Framed-Interface-Id", "96", "Inet6InterfaceId"}, {"Framed-IPv6-Prefix", "97", "Inet6prefix"}, {"Login-IPv6-Host", "98", "Inet6Address"}, {"Framed-IPv6-Route", "99", "String"}, {"Framed-IPv6-Pool", "100", "String"}};
    private static Map<String, String> typeToNameMap = new HashMap<String, String>();
    private static Map<String, String> nameToTypeMap = new HashMap<String, String>();
    private static Map<String, String> typeToValueMap = new HashMap<String, String>();
    private static Map<String, String> nameToValueMap = new HashMap<String, String>();

    public static String getAttributeName(int type) {
        String name = typeToNameMap.get(String.valueOf(type));
        return name == null ? UNKNOWN : name;
    }

    public static byte getAttributeType(String name) throws SJbaseUnsupportedAttributeException {
        try {
            return (byte)Integer.parseInt(nameToTypeMap.get(name));
        }
        catch (NumberFormatException e) {
            throw new SJbaseUnsupportedAttributeException();
        }
    }

    public static String getValueType(int attrType) {
        String valueType = typeToValueMap.get(String.valueOf(attrType));
        return valueType == null ? UNKNOWN : valueType;
    }

    public static String getValueType(String name) {
        String valueType = nameToValueMap.get(name);
        return valueType == null ? UNKNOWN : valueType;
    }

    static {
        for (int i = 0; i < data.length; ++i) {
            typeToNameMap.put(data[i][1], data[i][0]);
            nameToTypeMap.put(data[i][0], data[i][1]);
            typeToValueMap.put(data[i][1], data[i][2]);
            nameToValueMap.put(data[i][0], data[i][2]);
        }
    }
}

