/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.radius;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAccountInfo;
import sanproject.sn2.base.authentication.module.external.common.SJbaseLoginModule;
import sanproject.sn2.base.authentication.module.external.common.SJbaseParamater;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseAccessRequestHandler;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseAccessRequestPacket;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseChapRequest;
import sanproject.sn2.base.authentication.module.external.radius.SJbasePapRequest;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfiguration;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfigurationFactory;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusPacket;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseRadiusLoginModule
implements SJbaseLoginModule {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseRadiusLoginModule";
    SJbaseRadiusConfiguration[] radiusConfAry = null;
    private String userId;
    private String password;
    private Properties properties;
    private static final String DEFAULT_ENCODING = "utf-8";

    public SJbaseRadiusLoginModule(String userId, String password, Properties properties) {
        String method = "constructor";
        logger.info(module, method, "", "start");
        this.userId = userId;
        this.password = password;
        this.properties = properties;
        logger.info(module, method, "", "end");
    }

    public SJbaseRadiusLoginModule() {
    }

    @Override
    public SJbaseParamater authenticate() throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        String method = "authenticate";
        logger.info(module, method, "", "start");
        if (this.userId == null || this.userId.length() == 0) {
            logger.error(module, method, "check the user id", "invalid");
            throw new SJbaseExAuthenticationException();
        }
        if (this.password == null) {
            logger.error(module, method, "check the password", "invalid");
            throw new SJbaseExAuthenticationException();
        }
        this.radiusConfAry = new SJbaseRadiusConfigurationFactory(this.properties).getConfigurations();
        if (this.radiusConfAry == null) {
            logger.error(module, method, "check the configuration objects", "invalid");
            SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
            et.setErrCode(9999);
            throw et;
        }
        SJbaseExCommunicationException ex = null;
        for (int i = 0; i < this.radiusConfAry.length; ++i) {
            SJbaseRadiusConfiguration tmpConf = this.radiusConfAry[i];
            try {
                SJbaseParamater paramater = this.authenticate(tmpConf);
                SJbaseExternalAccountInfo account = paramater.getAccount();
                account.setAuthServerInfo(this.radiusConfAry[0].getHost());
                paramater.setAccount(account);
                paramater.setRadiusConf(tmpConf);
                logger.info(module, method, "authenticate the user", "succeeded");
                logger.info(module, method, "", "end");
                return paramater;
            }
            catch (SJbaseExCommunicationException e) {
                logger.error(module, method, "authenticate the user", "failed, server :[" + i + "]", e);
                ex = e;
                continue;
            }
            catch (SJbaseExAuthenticationException e) {
                logger.error(module, method, "authenticate the user", "failed, server :[" + i + "]", e);
                throw e;
            }
        }
        logger.info(module, method, "authentication the user", "failed at all servers");
        if (ex == null) {
            ex = new SJbaseExCommunicationException();
        }
        throw ex;
    }

    public SJbaseParamater authenticate(SJbaseRadiusConfiguration radiusConf) throws SJbaseExCommunicationException, SJbaseExAuthenticationException {
        byte[] passwordBytes;
        byte[] userIdBytes;
        String method = "authenticate";
        logger.info(module, method, "", "start");
        if (radiusConf.getServerErrCode() == 10) {
            logger.error(module, method, "check the configuration object", "invalid");
            SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
            et.setErrCode(9999);
            throw et;
        }
        try {
            userIdBytes = this.userId.getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            userIdBytes = this.userId.getBytes();
            logger.info(module, method, "convert from String to bytes", "unsupported encoding :utf-8", e);
        }
        try {
            passwordBytes = this.password.getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            logger.info(module, method, "convert from String to bytes", "unsupported encoding :utf-8", e);
            passwordBytes = this.password.getBytes();
        }
        SJbaseAccessRequestPacket request = null;
        if (radiusConf.getProtocol().equalsIgnoreCase("PAP")) {
            logger.info(module, method, "select a authentication protocol", "PAP");
            request = SJbasePapRequest.create(userIdBytes, passwordBytes, radiusConf.getSecret(), radiusConf.getAttributes());
        } else if (radiusConf.getProtocol().equalsIgnoreCase("CHAP")) {
            logger.info(module, method, "select a authentication protocol", "CHAP");
            request = SJbaseChapRequest.create(userIdBytes, passwordBytes, radiusConf.getAttributes());
        } else {
            logger.error(module, method, "select a authentication protocol", "invalid protocol");
            SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
            et.setErrCode(9999);
            throw et;
        }
        SJbaseAccessRequestHandler handler = new SJbaseAccessRequestHandler(radiusConf.getProtocol(), radiusConf.getHost(), radiusConf.getPort(), radiusConf.getTimeout(), radiusConf.getRetryTimes(), radiusConf.getSecret());
        SJbaseRadiusPacket response = handler.send(request);
        if (response.getCode() != 2) {
            logger.error(module, method, "determine the authentication result", "failed");
            throw new SJbaseExAuthenticationException();
        }
        logger.info(module, method, "determine the authentication result", "succeeded");
        SJbaseExternalAccountInfo account = new SJbaseExternalAccountInfo(this.userId);
        SJbaseParamater paramater = new SJbaseParamater(account);
        logger.info(module, method, "", "end");
        return paramater;
    }
}

