/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.system;

import sanproject.sn2.base.system.inf.SJbaseSystemInterface;
import sanproject.sn2.base.system.inf.SJbaseSystemStatusInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;

public class SJbaseSystemAgent {
    private final String LOG_FUNCTION = "SystemManager";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private SJbaseSystemInterface system = null;
    private SJbaseSystemAgentThread agentThread = null;
    private SJcLoggerInterface stdLogger = SJcLogUty.getLogger("SN_System.log");

    public SJbaseSystemAgent(String systemClassName) throws Exception {
        String LOG_SUBTITLE = "SJbaseSystemAgent";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "SJbaseSystemAgent", "Start. - systemClassName:" + systemClassName);
        try {
            Class<?> clazz = Class.forName(systemClassName);
            Object instance = SJcSingletonManagerUty.renewInstance(clazz);
            this.system = (SJbaseSystemInterface)instance;
        }
        catch (ClassNotFoundException cnfe) {
            this.stdLogger.error("SystemManager", this.LOG_TITLE, "SJbaseSystemAgent", "ClassNotFoundException occurred.", cnfe);
            throw cnfe;
        }
        catch (ClassCastException cce) {
            this.stdLogger.error("SystemManager", this.LOG_TITLE, "SJbaseSystemAgent", "ClassCastException occurred.", cce);
            throw cce;
        }
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "SJbaseSystemAgent", "End.");
    }

    public void initialize() {
        String LOG_SUBTITLE = "initialize";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "initialize", "Start.");
        this.agentThread = new SJbaseSystemAgentThread(){

            @Override
            protected void procedure() throws InterruptedException {
                if (null != SJbaseSystemAgent.this.system) {
                    SJbaseSystemAgent.this.system.initialize();
                }
                SJbaseSystemAgent.this.stdLogger.info("SystemManager", SJbaseSystemAgent.this.LOG_TITLE, "initialize", "System initialize published.");
            }
        };
        this.agentThread.start();
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "initialize", "End.");
    }

    public void finish() {
        String LOG_SUBTITLE = "finish";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "finish", "Start.");
        this.agentThread = new SJbaseSystemAgentThread(){

            @Override
            protected void procedure() throws InterruptedException {
                if (null != SJbaseSystemAgent.this.system) {
                    SJbaseSystemAgent.this.system.finish();
                }
                SJbaseSystemAgent.this.stdLogger.info("SystemManager", SJbaseSystemAgent.this.LOG_TITLE, "finish", "System finish published");
            }
        };
        this.agentThread.start();
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "finish", "End.");
    }

    public void abortInitialize() {
        String LOG_SUBTITLE = "abortInitialize";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "abortInitialize", "Start.");
        if (null != this.system) {
            this.system.abort_initialize();
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "abortInitialize", "System abort_initialize published");
        }
        if (null != this.agentThread && this.agentThread.isAlive()) {
            this.agentThread.interrupt();
            this.agentThread = null;
        }
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "abortInitialize", "End.");
    }

    public void abortFinish() {
        String LOG_SUBTITLE = "abortFinish";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "abortFinish", "Start.");
        if (null != this.system) {
            this.system.abort_finish();
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "abortFinish", "System abort_finish published");
        }
        if (null != this.agentThread && this.agentThread.isAlive()) {
            this.agentThread.interrupt();
            this.agentThread = null;
        }
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "abortFinish", "End.");
    }

    public SJbaseSystemStatusInterface getStatus() {
        SJbaseSystemStatusInterface status = null;
        if (null != this.system) {
            status = this.system.getStatus();
        }
        return status;
    }

    public String getSystemClassName() {
        String className = null;
        if (null != this.system) {
            className = this.system.getClass().getName();
        }
        return className;
    }

    private abstract class SJbaseSystemAgentThread
    extends Thread {
        private SJbaseSystemAgentThread() {
        }

        @Override
        public void run() {
            String LOG_SUBTITLE = "SJbaseSystemAgentThread";
            SJbaseSystemAgent.this.stdLogger.info("SystemManager", SJbaseSystemAgent.this.LOG_TITLE, "SJbaseSystemAgentThread", "Run Start.");
            try {
                this.procedure();
            }
            catch (InterruptedException e) {
                SJbaseSystemAgent.this.stdLogger.info("SystemManager", SJbaseSystemAgent.this.LOG_TITLE, "SJbaseSystemAgentThread", "Interrupted.");
                Thread.currentThread().interrupt();
            }
            SJbaseSystemAgent.this.stdLogger.info("SystemManager", SJbaseSystemAgent.this.LOG_TITLE, "SJbaseSystemAgentThread", "Run End.");
        }

        protected abstract void procedure() throws InterruptedException;
    }
}

