/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.util.ArrayList;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcAccountConst;
import sanproject.sn2.com.utility.account.exception.SJcParamErrorException;

public class SJcAccountChkUty {
    private SJcAccountChkUty() {
    }

    public static void chkEmptyException(String szData) throws SJcException {
        if (szData == null) {
            throw new SJcParamErrorException();
        }
        if (szData.length() <= 0) {
            throw new SJcParamErrorException();
        }
    }

    public static void chkEmptyException(String[] szData) throws SJcException {
        if (szData == null) {
            throw new SJcParamErrorException();
        }
        if (szData.length <= 0) {
            throw new SJcParamErrorException();
        }
    }

    public static boolean chkEmpty(String szData) {
        if (szData == null) {
            return false;
        }
        return szData.length() > 0;
    }

    public static boolean chkEmpty(Map mpData) {
        if (mpData == null) {
            return false;
        }
        return !mpData.isEmpty();
    }

    public static boolean chkEmpty(String[] szData) {
        if (szData == null) {
            return false;
        }
        return szData.length > 0;
    }

    public static void chkUserName(String szUserName) throws SJcException {
        if (szUserName == null) {
            throw new SJcParamErrorException();
        }
        if (szUserName.length() <= 0 || szUserName.length() > 256) {
            throw new SJcParamErrorException();
        }
        SJcAccountChkUty.chkString(szUserName, "!#$%&'*+-./=?@^_`{|}~");
    }

    public static void chkUserName(String[] szUserName) throws SJcException {
        if (szUserName == null) {
            throw new SJcParamErrorException();
        }
        for (int i = 0; i < szUserName.length; ++i) {
            SJcAccountChkUty.chkUserName(szUserName[i]);
        }
    }

    public static void chkPassword(String szPassword) throws SJcException {
        if (szPassword == null) {
            throw new SJcParamErrorException();
        }
        if (szPassword.length() < 6 || szPassword.length() > 256) {
            throw new SJcParamErrorException();
        }
        SJcAccountChkUty.chkString(szPassword, "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~");
    }

    public static void chkAuthPtn(int iAuthPtn) throws SJcException {
        if (iAuthPtn != SJcAccountConst.INT_AUTHPTN_LOCAL && iAuthPtn != SJcAccountConst.INT_AUTHPTN_EXTERNAL) {
            throw new SJcParamErrorException();
        }
    }

    public static void chkEnable(int iEnable) throws SJcException {
        if (iEnable != SJcAccountConst.INT_USERENABLE_OFF && iEnable != SJcAccountConst.INT_USERENABLE_ON) {
            throw new SJcParamErrorException();
        }
    }

    public static void chkGrpName(String szGrpName) throws SJcException {
        if (szGrpName == null) {
            throw new SJcParamErrorException();
        }
        if (szGrpName.length() <= 0 || szGrpName.length() > 64) {
            throw new SJcParamErrorException();
        }
        SJcAccountChkUty.chkString(szGrpName, "!#$%&'()+-.=@[]^_`{}~ ");
    }

    public static void chkGrpName(String[] szGrpName) throws SJcException {
        if (szGrpName == null) {
            throw new SJcParamErrorException();
        }
        if (szGrpName.length <= 0 || szGrpName.length > 8) {
            throw new SJcParamErrorException();
        }
        for (int i = 0; i < szGrpName.length; ++i) {
            SJcAccountChkUty.chkGrpName(szGrpName[i]);
        }
    }

    public static void chkRoleName(String szRoleName) throws SJcException {
        if (szRoleName == null) {
            throw new SJcParamErrorException();
        }
        if (szRoleName.length() <= 0 || szRoleName.length() > 64) {
            throw new SJcParamErrorException();
        }
        SJcAccountChkUty.chkString(szRoleName, "!#$%&'()+-.=@[]^_`{}~ ");
    }

    public static void chkRoleName(String[] szRoleName) throws SJcException {
        if (szRoleName == null) {
            throw new SJcParamErrorException();
        }
        if (szRoleName.length <= 0 || szRoleName.length > 32) {
            throw new SJcParamErrorException();
        }
        for (int i = 0; i < szRoleName.length; ++i) {
            SJcAccountChkUty.chkRoleName(szRoleName[i]);
        }
    }

    public static void chkRsrcGpID(int iRsrcGpID) throws SJcException {
        if (iRsrcGpID < 0 || iRsrcGpID >= 1024) {
            throw new SJcParamErrorException();
        }
    }

    public static void chkRsrcGpID(int[] iRsrcGpID) throws SJcException {
        if (iRsrcGpID == null) {
            throw new SJcParamErrorException();
        }
        if (iRsrcGpID.length <= 0) {
            throw new SJcParamErrorException();
        }
        for (int i = 0; i < iRsrcGpID.length; ++i) {
            SJcAccountChkUty.chkRsrcGpID(iRsrcGpID[i]);
        }
    }

    public static void chkAuthBit(String szAuthBit) throws SJcException {
        if (szAuthBit == null) {
            throw new SJcParamErrorException();
        }
        if (szAuthBit.length() <= 0) {
            throw new SJcParamErrorException();
        }
    }

    private static void chkString(String szData, String szSymbol) throws SJcException {
        for (int i = 0; i < szData.length(); ++i) {
            char cCheck = szData.charAt(i);
            if (cCheck >= '0' && cCheck <= '9' || cCheck >= 'A' && cCheck <= 'Z' || cCheck >= 'a' && cCheck <= 'z' || szSymbol.indexOf(cCheck) >= 0) continue;
            throw new SJcParamErrorException();
        }
    }

    public static ArrayList<Integer> chgIntArray(int[] iData) {
        ArrayList<Integer> alRet = new ArrayList<Integer>();
        for (int i = 0; i < iData.length; ++i) {
            alRet.add(iData[i]);
        }
        return alRet;
    }

    public static int[] chgIntArray(ArrayList<Integer> alData) {
        int[] iRet = new int[alData.size()];
        for (int i = 0; i < alData.size(); ++i) {
            iRet[i] = alData.get(i);
        }
        return iRet;
    }

    public static String chgArray2Str(Object[] alData) {
        String szRet = "";
        if (alData == null || alData.length <= 0) {
            return szRet;
        }
        for (int i = 0; i < alData.length; ++i) {
            szRet = szRet + String.valueOf(alData[i]) + ",";
        }
        return szRet.substring(0, szRet.length() - 1);
    }

    public static boolean checkBit(String szBitData, int iCheckBit) {
        boolean bRet = false;
        if (szBitData == null) {
            return false;
        }
        if (szBitData.length() * 4 < iCheckBit) {
            return false;
        }
        int iByte = iCheckBit / 4;
        int iBit = 1 << 3 - iCheckBit % 4;
        int iData = Integer.parseInt(szBitData.substring(iByte, iByte + 1), 16);
        if ((iData & iBit) != 0) {
            bRet = true;
        }
        return bRet;
    }

    public static boolean checkBitOr(String szBitData, int[] iCheckBit) {
        boolean bRet = false;
        if (iCheckBit == null || iCheckBit.length <= 0) {
            return false;
        }
        for (int i = 0; i < iCheckBit.length; ++i) {
            if (!SJcAccountChkUty.checkBit(szBitData, iCheckBit[i])) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static boolean checkBitAnd(String szBitData, int[] iCheckBit) {
        boolean bRet = true;
        if (iCheckBit == null || iCheckBit.length <= 0) {
            return false;
        }
        for (int i = 0; i < iCheckBit.length; ++i) {
            if (SJcAccountChkUty.checkBit(szBitData, iCheckBit[i])) continue;
            bRet = false;
            break;
        }
        return bRet;
    }

    public static String getOrStr(String str1, String str2) {
        String szRet = "";
        if (!SJcAccountChkUty.chkEmpty(str1)) {
            return str2;
        }
        if (!SJcAccountChkUty.chkEmpty(str2)) {
            return str1;
        }
        int szSt_1 = 0;
        int szSt_2 = 0;
        int szEnd_1 = 0;
        int szEnd_2 = 0;
        while (szSt_1 < str1.length() && szSt_2 < str2.length()) {
            szEnd_1 = szSt_1 + 15;
            szEnd_2 = szSt_2 + 15;
            if (szEnd_1 > str1.length() || szEnd_2 > str2.length()) {
                if (str1.length() < str2.length()) {
                    szEnd_1 = str1.length();
                    szEnd_2 = str1.length();
                } else {
                    szEnd_1 = str2.length();
                    szEnd_2 = str2.length();
                }
            }
            String szSub_1 = str1.substring(szSt_1, szEnd_1);
            String szSub_2 = str2.substring(szSt_2, szEnd_2);
            Long iData1 = Long.parseLong(szSub_1, 16);
            Long iData2 = Long.parseLong(szSub_2, 16);
            String szOr = Long.toHexString(iData1 | iData2);
            for (int i = szOr.length(); i < szEnd_1 - szSt_1; ++i) {
                szOr = "0" + szOr;
            }
            szRet = szRet + szOr;
            szSt_1 = szEnd_1;
            szSt_2 = szEnd_2;
        }
        if (szSt_1 < str1.length()) {
            szRet = szRet + str1.substring(szSt_1, str1.length());
        } else if (szSt_2 < str2.length()) {
            szRet = szRet + str2.substring(szSt_2, str2.length());
        }
        return szRet;
    }

    public static String getOrStr(String[] str) {
        String strAll = "";
        if (str != null) {
            strAll = str[0];
            for (int i = 1; i < str.length; ++i) {
                strAll = SJcAccountChkUty.getOrStr(strAll, str[i]);
            }
        }
        return strAll;
    }

    public static boolean[] getOrBool(boolean[] str1, boolean[] str2) {
        boolean[] szRet = new boolean[str1.length];
        for (int i = 0; i < str1.length; ++i) {
            szRet[i] = str1[i] || str2[i];
        }
        return szRet;
    }
}

