/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.List;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMonitorBackgroundThread;
import sanproject.sn2.controller.com.SJctrQueueController;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.SJctrWorkerThread;
import sanproject.sn2.controller.com.taketask.SJctrTakeTask;

public class SJctrBackgroundWorkerThread
extends SJctrWorkerThread {
    private final String mClassName;
    private static final SJctrTakeTask takeTask = new SJctrTakeTask();

    public SJctrBackgroundWorkerThread(SJctrQueueController queueCtr) {
        super(queueCtr);
        this.setName("BackgroundWorkerThread");
        this.mClassName = this.getClass().getSimpleName();
    }

    @Override
    public void run() {
        SJctrLogUty.info(this.mClassName, "run", "start");
        SJctrTask task = null;
        this.startMonitorTaskThread();
        while (true) {
            try {
                while ((task = this.mQueueCtr.takeTask(this)) != null) {
                    long lLockId;
                    long lockId = task.getLockId();
                    if (lockId != (lLockId = this.setDkcLock(task))) {
                        try {
                            this.mQueueCtr.saveTaskControlData(task);
                        }
                        catch (Exception e) {
                            SJctrLogUty.warn(this.mClassName, "saveTaskControlData", "faild taskId:" + task.getId(), e);
                        }
                    }
                    if (lLockId == -1L || !this.lock(task)) continue;
                    int status = task.execute(this.mAgent);
                    this.unlock(task);
                    this.releaseDkcLock(task);
                    this.mQueueCtr.wakeUpWorkerThread();
                    if (task.isExecute()) {
                        task.changeStatus(258);
                        SJctrMonitorBackgroundThread monitorThread = new SJctrMonitorBackgroundThread(this, status, task);
                        monitorThread.start();
                    }
                    task = null;
                }
            }
            catch (Exception ex) {
                this.afterException(task, ex);
                continue;
            }
            break;
        }
        this.unlock(task);
        this.mAgent = null;
        this.mQueueCtr = null;
        SJctrLogUty.info(this.mClassName, "run", "end");
    }

    @Override
    protected SJctrTask getTask(List<SJctrTask> queuingTaskList) {
        return takeTask.getTask(queuingTaskList);
    }

    private void startMonitorTaskThread() {
        try {
            List<SJctrTask> taskList = this.mQueueCtr.getSpecificStatusTaskList(258);
            for (SJctrTask task : taskList) {
                try {
                    int status;
                    if (task == null) continue;
                    switch (task.getError().getError()) {
                        case 0: {
                            status = 512;
                            break;
                        }
                        case -1: {
                            status = 514;
                            break;
                        }
                        default: {
                            status = 513;
                        }
                    }
                    SJctrMonitorBackgroundThread monitorThread = new SJctrMonitorBackgroundThread(this, status, task);
                    monitorThread.start();
                }
                catch (Exception exTask) {
                    SJctrLogUty.warn(this.mClassName, "startMonitorTaskThread", "Cannot start monitor thread.", exTask);
                    SJctrBackgroundWorkerThread.afterExceptionTaskFailed(task, this.mQueueCtr, exTask);
                }
            }
        }
        catch (Exception ex) {
            SJctrLogUty.error(this.mClassName, "startMonitorTaskThread", "Cannot Restart Monitor.", ex);
        }
    }
}

