/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrFileDownloadInterface;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;

public class SJctrFileDownloadDataController
extends SJctrDialogDataController {
    protected static final int DISP_ID = 0x3000005;
    public static final String KEY_FILE_LIST = "COM_FILE_LIST";
    public static final String KEY_DEFFILE_LIST = "COM_DEFFILE_LIST";
    public static final String KEY_DL_OPTION = "COM_DL_OPTION";
    public static final String KEY_CLOSE = "COM_CLOSE";
    private static final String KEY_SELECTED = "COM_SELECTED";
    private static final int SELECTED_CLOSE = 1;
    private static final String KEY_RESULT = "COM_RESULT";
    private static final int DOWNLOAD_DEFAULT = -1;
    public static final int DL_OPT_NONE = 0;
    public static final int DL_OPT_CANCEL_DISABLE = 1;
    private SJctrFileDownloadInterface fileDownload = null;
    private int intDownloadResult;

    public SJctrFileDownloadDataController() throws SJcException {
        super(0x3000005);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrButtonDataModel close = new SJctrButtonDataModel();
        close.setReceiveOnly();
        close.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrSelectableDataObject) {
                    SJctrSelectableDataObject parmClose = (SJctrSelectableDataObject)setObject;
                    SJctrFileDownloadDataController.this.intDownloadResult = -1;
                    if (parmClose.containsKey(SJctrFileDownloadDataController.KEY_RESULT)) {
                        SJctrFileDownloadDataController.this.chkDownloadResult(parmClose);
                        SJctrFileDownloadDataController.this.doAfterDownload();
                    }
                    if (parmClose.containsKey(SJctrFileDownloadDataController.KEY_SELECTED)) {
                        SJctrFileDownloadDataController.this.chkSelected(parmClose);
                    }
                }
            }
        });
        this.addDataObjectModel(KEY_CLOSE, close);
    }

    private void chkSelected(SJctrSelectableDataObject parmClose) {
        int intSelected = (Integer)parmClose.getData(KEY_SELECTED);
        if (intSelected == 1) {
            this.logUty.putlog("selectChanged", "close");
            this.close();
        }
    }

    private void chkDownloadResult(SJctrSelectableDataObject parmClose) {
        this.intDownloadResult = (Integer)parmClose.getData(KEY_RESULT);
        this.logUty.putlog("chkDownload", "COM_RESULT=" + this.intDownloadResult);
    }

    protected void doAfterDownload() {
    }

    private void close() {
        this.fireMessageEvent((SJctrNotifyState)SJctrWizardDataController.WIZ_MSG.CLOSE);
    }

    public void setFileDownload(SJctrFileDownloadInterface obj) {
        this.fileDownload = obj;
    }

    public void makeDataModel() {
        super.makeDataModel();
        SJctrDataObject manageData = this.getManageData();
        ArrayList<String> fileList = this.fileDownload.fileDownload();
        this.getLogUty().putlog("makeDataModel", "org filename:" + fileList);
        manageData.setData(KEY_FILE_LIST, fileList);
        ArrayList<String> defFileList = this.fileDownload.getDefaultFileNameList();
        this.getLogUty().putlog("makeDataModel", "def filename:" + defFileList);
        manageData.setData(KEY_DEFFILE_LIST, defFileList);
    }

    public int getDownloadResult() {
        return this.intDownloadResult;
    }

    public void setDownloadOption(int option) {
        SJctrDataObject manageData = this.getManageData();
        this.getLogUty().putlog("setDownloadOption", "Option: " + SJctrComUtility.toHexString(option));
        manageData.setData(KEY_DL_OPTION, option);
    }
}

