/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPoolLdevDetail;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.system.SJmoClprIndex;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrClprColumnFromPoolLdevDetail
extends SJctrColumn {
    public SJctrClprColumnFromPoolLdevDetail(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("CLPR"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_CLPR_INFO);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoClprInfo> retList = new ArrayList<SJmoClprInfo>();
        if (null != index && index instanceof SJctrPoolLdevDetail) {
            SJctrPoolLdevDetail idxPoolLdevDtl = (SJctrPoolLdevDetail)index;
            SJmoLdevDetail ldevDtl = idxPoolLdevDtl.getLdevDetail();
            short sCLPRNo = ldevDtl.getSCLPR();
            SJmoClprIndex srchKeyCLPRIdx = new SJmoClprIndex();
            srchKeyCLPRIdx.setSClpr(sCLPRNo);
            List<?> clprInfoList = modelData.get(SJctrPoolUtility.KEY_CLASS_CLPR_INFO);
            if (null != clprInfoList && 0 != clprInfoList.size()) {
                int iCLPRInfoIdx = Collections.binarySearch(clprInfoList, srchKeyCLPRIdx);
                if (0 <= iCLPRInfoIdx) {
                    SJmoClprInfo clprInf = (SJmoClprInfo)clprInfoList.get(iCLPRInfoIdx);
                    retList.add(clprInf);
                } else {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoClprInfo is not found");
                }
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoClprInfo List is null or size 0");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "index is null or Class Error");
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "";
        if (null != dataList && 0 != dataList.size()) {
            Object obj = dataList.get(0);
            if (obj instanceof SJmoClprInfo) {
                SJmoClprInfo clprInf = (SJmoClprInfo)obj;
                SJctrLdevUtility ldevUtl = this.getTable().getComUtility().getLdevUtility();
                strRtn = ldevUtl.toClprDisplay(clprInf);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is class error");
                strRtn = "?:?";
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is null or size 0");
            strRtn = "?:?";
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 3;
    }

    @Override
    public int getSortType() {
        return 2;
    }
}

