/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrPageStatusFromLdevDetailColumn
extends SJctrColumn {
    public SJctrPageStatusFromLdevDetailColumn(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("PAGE_STATUS"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoHDPRelation> retList = new ArrayList<SJmoHDPRelation>();
        if (null != index && index instanceof SJmoLdevDetail) {
            SJmoLdevDetail idxLdevDetail = (SJmoLdevDetail)index;
            List<?> hdpRelList = modelData.get(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
            if (null != hdpRelList && 0 != hdpRelList.size()) {
                int iHDPRelIdx = Collections.binarySearch(hdpRelList, idxLdevDetail);
                if (0 <= iHDPRelIdx) {
                    SJmoHDPRelation hdpRel = (SJmoHDPRelation)hdpRelList.get(iHDPRelIdx);
                    retList.add(hdpRel);
                } else {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoHDPRelation is not found");
                }
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoHDPRelation List is null or size 0");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "index is null or Class Error");
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "";
        if (null != dataList && 0 != dataList.size()) {
            Object obj = dataList.get(0);
            if (obj instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRel = (SJmoHDPRelation)obj;
                SJctrPoolUtility poolUtl = this.getTable().getComUtility().getPoolUtility();
                strRtn = poolUtl.toPageStatusDisplay(hdpRel);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is class error");
                strRtn = "?";
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is null or size 0");
            strRtn = "?";
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 3;
    }
}

