/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrPoolShrinkableColumnFromPoolDetail
extends SJctrColumn {
    List<SJmoLdevDetail> ldevDetailList = null;
    List<SJmoVdevDetail> vdevDetailList = null;
    List<SJmoPgDetail> pgDetailList = null;

    public SJctrPoolShrinkableColumnFromPoolDetail(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("SHRINKABLE"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> retList = new ArrayList<Object>();
        if (null != index && null != modelData && index instanceof SJmoPoolDetail) {
            SJmoPoolDetail idxPoolDtl = (SJmoPoolDetail)index;
            retList.add(idxPoolDtl);
            List<?> poolVolDtlList = modelData.get(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
            if (null != poolVolDtlList && 0 != poolVolDtlList.size()) {
                int iPoolVolDtlIdx = Collections.binarySearch(poolVolDtlList, idxPoolDtl);
                if (0 <= iPoolVolDtlIdx) {
                    SJmoPoolVolDetail poolVolDtl = (SJmoPoolVolDetail)poolVolDtlList.get(iPoolVolDtlIdx);
                    retList.add(poolVolDtl);
                } else {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoPoolVolDetail is not found");
                }
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoPoolVolDetail List is null or size 0");
            }
            this.ldevDetailList = modelData.get(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
            if (this.ldevDetailList == null || this.ldevDetailList.isEmpty()) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoLdevDetail List is null or size 0");
            }
            this.vdevDetailList = modelData.get(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
            if (this.vdevDetailList == null || this.vdevDetailList.isEmpty()) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoVdevDetail List is null or size 0");
            }
            this.pgDetailList = modelData.get(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
            if (this.pgDetailList == null || this.pgDetailList.isEmpty()) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoPgDetail List is null or size 0");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "Parameter is null or Class Error");
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "";
        SJmoPoolDetail poolDtl = new SJmoPoolDetail();
        SJmoPoolVolDetail poolVolDtl = new SJmoPoolVolDetail();
        if (null != dataList && 0 != dataList.size()) {
            for (int iListCnt = 0; iListCnt < dataList.size(); ++iListCnt) {
                Object obj = dataList.get(iListCnt);
                if (null != obj && obj instanceof SJmoPoolDetail) {
                    poolDtl = (SJmoPoolDetail)obj;
                    continue;
                }
                if (null == obj || !(obj instanceof SJmoPoolVolDetail)) continue;
                poolVolDtl = (SJmoPoolVolDetail)obj;
            }
            SJctrPoolUtility poolUtl = this.getTable().getComUtility().getPoolUtility();
            strRtn = poolUtl.toPoolShrinkableDisplay(poolDtl, poolVolDtl.getAlPoolInfo(), this.ldevDetailList, this.vdevDetailList, this.pgDetailList);
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is null or size 0");
            strRtn = "?";
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 3;
    }
}

