/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolUsedCapacity;

public class SJctrSnapshotUsedCapacityColumnFromPoolDetail
extends SJctrCapacityColumn {
    protected Map<Integer, Long> snapshotUsedCapBlkMap = Collections.emptyMap();

    public SJctrSnapshotUsedCapacityColumnFromPoolDetail(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("SNAPSHOT_USED_CAPACITY"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_POOL_USED_CAPACITY);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        List<?> retList = super.getNeedModelData(index, basicData);
        List<SJmoPoolUsedCapacity> poolUseCapInfoList = basicData.get(SJctrPoolUtility.KEY_CLASS_POOL_USED_CAPACITY);
        SJmoPoolUsedCapacity poolUseCapInfo = SJctrPoolUtility.getPoolUsedCapacityInfo((SJmoPoolIndex)index, poolUseCapInfoList);
        if (poolUseCapInfo != null) {
            retList.add(poolUseCapInfo);
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "";
        if (null != dataList && 0 != dataList.size()) {
            Object objPoolDetail = dataList.get(0);
            Object objPoolUsedCapacity = dataList.get(1);
            if (objPoolDetail instanceof SJmoPoolDetail && objPoolUsedCapacity instanceof SJmoPoolUsedCapacity) {
                SJmoPoolDetail poolDtl = (SJmoPoolDetail)objPoolDetail;
                SJmoPoolUsedCapacity poolUsedCap = (SJmoPoolUsedCapacity)objPoolUsedCapacity;
                String strClmUnit = this.getUnitSelect();
                SJctrComUtility comUtl = this.getTable().getComUtility();
                SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
                strRtn = poolUtl.toSnapshotUsedCapacityDisplay(poolDtl, poolUsedCap, strClmUnit, comUtl, false);
                if (this.snapshotUsedCapBlkMap == Collections.EMPTY_MAP) {
                    int rowCount = this.getTable().getRowCount();
                    this.snapshotUsedCapBlkMap = new HashMap<Integer, Long>(rowCount);
                }
                this.snapshotUsedCapBlkMap.put(poolDtl.getPoolId(), poolUsedCap.getLSnapshotUsedCapacity());
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is class error");
                strRtn = "?";
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is null or size 0");
            strRtn = "?";
        }
        return strRtn;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        Long value = this.snapshotUsedCapBlkMap.get(poolDtl.getPoolId());
        long rtnCapacity = -2L;
        int iEmulation = poolDtl.getEmulationType();
        String strClmUnit = this.getUnitSelect();
        SJctrCapacityUtility.UNIT clmUnit = SJctrCapacityUtility.UNIT.valueOf(strClmUnit);
        if (iEmulation != 0 || !clmUnit.equals((Object)SJctrCapacityUtility.UNIT.CYL)) {
            if (value != null) {
                rtnCapacity = value;
            }
        } else {
            rtnCapacity = SJctrPoolUtility.HAIFUN_NUM;
        }
        return rtnCapacity;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        Long snapshotUsedCapBlk = this.snapshotUsedCapBlkMap.get(poolDetail.getPoolId());
        long rtnPageCapacity = -2L;
        if (snapshotUsedCapBlk != null) {
            rtnPageCapacity = this.blocktoPage(snapshotUsedCapBlk, poolDetail);
        }
        return rtnPageCapacity;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        int emuType = poolDetail.getEmulationType();
        SJctrComUtility comUtl = this.getTable().getComUtility();
        SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
        emuType = poolUtl.changeEmulationType(emuType);
        long block = this.getNumber(dat);
        SJctrCapacityUtility capaUtil = this.getTable().getComUtility().getCapacityUtility();
        long cylinder = capaUtil.toCylValue(block, emuType);
        return cylinder;
    }

    private long blocktoPage(long block, SJmoPoolDetail poolDtl) {
        long pageNum = 0L;
        long pageSize = poolDtl.getPageSize() * 2L;
        if (0L < pageSize) {
            pageNum = (block + pageSize - 1L) / pageSize;
        }
        return pageNum;
    }
}

