/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrVssSSIDColumnFromVirtualLdev
extends SJctrColumn {
    private Map<Class<?>, List<?>> _basicData;

    public SJctrVssSSIDColumnFromVirtualLdev(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("SSID"));
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        this._basicData = basicData;
        return SJctrRsgUtility.getTargetVssLdevList(index, basicData);
    }

    public ArrayList<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetHUVMVirtualLdev.class);
        return list;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String rtn = "?";
        if (dataList != null && dataList.size() > 0) {
            SJmoHUVMVirtualLdev wkLdev = (SJmoHUVMVirtualLdev)dataList.get(0);
            rtn = this.getTable().getComUtility().getRsgUtility().toDispStringVssSsid(wkLdev);
        }
        return rtn;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        SJmoLdevIndex index;
        List ModelList;
        int rtn = -2;
        if (dat != null && this._basicData != null && (ModelList = SJctrRsgUtility.getTargetVssLdevList(index = (SJmoLdevIndex)this.getPrimaryKeyObject(dat), this._basicData)) != null && ModelList.size() > 0) {
            SJmoHUVMVirtualLdev wkLdev = (SJmoHUVMVirtualLdev)ModelList.get(0);
            rtn = (wkLdev.getSVAttrHuvm() & Short.MIN_VALUE) == 0 ? -3 : (wkLdev.getSVInfflag() == 1 ? wkLdev.getIVSsid() : -3);
        }
        return rtn;
    }

    @Override
    public String getInputFormat() {
        return "^([0-9A-Fa-f]{1,4})$";
    }
}

