/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.monitor.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorLUNInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;

public class SJctrLUNColumnFromMonitorLUN
extends SJctrColumn {
    private boolean isLunIdDecimal = true;

    public SJctrLUNColumnFromMonitorLUN(String key) {
        super(key);
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJctrMonitorLUNInfo data = (SJctrMonitorLUNInfo)dataList.get(0);
        short lun = data.getPortLunDetail().getSLUN();
        String lunStr = null;
        lunStr = this.isLunIdDecimal ? String.valueOf(lun) : SJctrComUtility.toHexString(lun, 4, true);
        return lunStr;
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(SJctrOptionMonitorGuidance.getMonitorGuidanceStr((SJctrComUtility)util, (String[])SJctrOptionMonitorGuidance.LUN));
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public String getInputFormat() {
        String format = null;
        format = this.isLunIdDecimal ? "^\\d{1,19}$" : "^([0-9A-Fa-f]{1,4})$";
        return format;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int lun = -1;
        SJctrMonitorLUNInfo monLunInfo = (SJctrMonitorLUNInfo)this.getPrimaryKeyObject(dat);
        SJmoPortLunDetail ptLunDeteil = monLunInfo.getPortLunDetail();
        if (ptLunDeteil != null) {
            lun = ptLunDeteil.getSLUN();
        }
        return lun;
    }

    public void setLunIdDecimal(boolean isLunIdDecimal) {
        this.isLunIdDecimal = isLunIdDecimal;
    }
}

