/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.iscsi.SJctrRemoteIpAddressColumnFromIscsiTargetPathInfo;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetPathInfoIpAddressComparator;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdPhysicalPathInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdTargetPortInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;

public class SJctrRemoteIpAddressColumnFromExdPhysicalPathInfo
extends SJctrRemoteIpAddressColumnFromIscsiTargetPathInfo {
    protected Map<Integer, SJmoIscsiTargetPathInfo> itPathMap = null;
    private Comparator<HashMap<String, Object>> rowComparator = null;
    private SJctrIscsiTargetPathInfoIpAddressComparator ipaddtrssComp = new SJctrIscsiTargetPathInfoIpAddressComparator();

    public SJctrRemoteIpAddressColumnFromExdPhysicalPathInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        String partsId = this.getPartsId();
        if (partsId != null) {
            this.setLabel(util.getGuidance(partsId));
        }
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        List<Class<? extends SJmoGetKind_IF>> list = super.getNeedModelKind();
        list.add(SJmoGetPortDetail.class);
        list.add(SJmoGetExdPhysicalPathInfoMgr.class);
        list.add(SJmoGetExdTargetPortInfoMgr.class);
        list.add(SJmoGetPortIscsiTargetPathInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        if (this.itPathMap == null) {
            int dataNum = this.getTable().getRowCount();
            this.itPathMap = new HashMap<Integer, SJmoIscsiTargetPathInfo>(dataNum);
        }
        SJmoExdPhysicalPathInfo physicalPath = (SJmoExdPhysicalPathInfo)index;
        List<SJmoPortDetail> portDtlList = basicData.get(SJmoGetPortDetail.class);
        SJmoPortDetail portDtl = SJctrExtUtility.getPortDtlFromPhysicalPathInfo(physicalPath, portDtlList);
        ArrayList<SJmoIscsiTargetPathInfo> list = new ArrayList<SJmoIscsiTargetPathInfo>();
        if (portDtl == null) {
            list.add(null);
        } else if (SJctrPortUtility.isIscsiPort(portDtl)) {
            List<?> targetPtMgrList;
            SJmoExdTargetPortInfoMgr targetPtMgr;
            List<SJmoPortIscsiTargetPathInfo> portItPathlList = basicData.get(SJmoGetPortIscsiTargetPathInfo.class);
            SJmoIscsiTargetPathInfo itPathInfo = SJctrExtUtility.getiSCSITargetPathInfo(physicalPath, portItPathlList, targetPtMgr = (SJmoExdTargetPortInfoMgr)(targetPtMgrList = basicData.get(SJmoGetExdTargetPortInfoMgr.class)).get(0));
            if (itPathInfo != null) {
                int physicalPathId = physicalPath.getRmiExdPhysicalPathInfo().getId();
                this.itPathMap.put(physicalPathId, itPathInfo);
            }
            list.add(itPathInfo);
        }
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        if (dataList.isEmpty()) {
            return "-";
        }
        return super.toDispString(dataList);
    }

    @Override
    public Comparator<HashMap<String, Object>> createComparator() {
        if (this.rowComparator == null) {
            this.rowComparator = new Comparator<HashMap<String, Object>>(){

                @Override
                public int compare(HashMap<String, Object> o1, HashMap<String, Object> o2) {
                    int ret = 0;
                    SJmoIscsiTargetPathInfo itPath1 = SJctrRemoteIpAddressColumnFromExdPhysicalPathInfo.this.getitPathInfo(o1);
                    SJmoIscsiTargetPathInfo itPath2 = SJctrRemoteIpAddressColumnFromExdPhysicalPathInfo.this.getitPathInfo(o2);
                    ret = itPath1 == null || itPath2 == null ? SJctrRemoteIpAddressColumnFromExdPhysicalPathInfo.this.getString(o1).compareTo(SJctrRemoteIpAddressColumnFromExdPhysicalPathInfo.this.getString(o2)) : SJctrRemoteIpAddressColumnFromExdPhysicalPathInfo.this.ipaddtrssComp.compare(itPath1, itPath2);
                    return ret;
                }
            };
        }
        return this.rowComparator;
    }

    protected SJmoIscsiTargetPathInfo getitPathInfo(HashMap<String, Object> dat) {
        SJmoExdPhysicalPathInfo physicalPathInfo = (SJmoExdPhysicalPathInfo)this.getPrimaryKeyObject(dat);
        return this.getitPathInfo(physicalPathInfo);
    }

    protected SJmoIscsiTargetPathInfo getitPathInfo(SJmoExdPhysicalPathInfo physicalPathInfo) {
        int physicalPathId = physicalPathInfo.getRmiExdPhysicalPathInfo().getId();
        return this.itPathMap.get(physicalPathId);
    }
}

