/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.systemcall.mappiniset;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.File;
import java.net.URL;
import org.slf4j.LoggerFactory;
import sanproject.sn2.base.property.SJbaseSystemPropertiesManager;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.systemcall.mappiniset.com.SJcmdMappDkcSetException;
import sanproject.sn2.systemcall.mappiniset.com.SJcmdMappDkcSetUtility;
import sanproject.sn2.systemcall.mappiniset.com.SJcmdMappDkcSetWordUty;

public abstract class SJcmdMappDkcSetBaseFunction {
    protected static final String LOG_MODULE = "MappIniSet";
    private static final String LOG_FUNCTION = SJcmdMappDkcSetBaseFunction.class.getSimpleName();
    private static final String KEY_JAR_PATH = "java.class.path";
    protected static final int NORMAL_END = 0;
    protected static final int ERROR_END = 1;
    protected static final String GUID_NORMALEND = "NORMAL_END";
    protected static final String GUID_ILLEGALEND = "ILLEGAL_END";
    protected static final int EXEC_MAPP_INI_SET_SUPERVISOR = 0;
    protected static final int EXEC_MAPP_INI_SET_DKC = 1;
    protected static final String DIR_WK = "wk";
    protected static final String DIR_MAPP_INI = "MappIniSet";
    protected String strMapDirAbsPath = "";
    protected String strModDirAbsPath = "";
    protected String strCmnDirAbsPath = "";
    protected String strFncDirAbsPath = "";
    protected String strCnfDirAbsPath = "";
    protected String strDefDirAbsPath = "";
    protected String strWrkDirAbsPath = "";
    protected String strDkcDirAbsPath = "";
    protected String strDkcModDirAbsPath = "";
    protected String strDkcCmnDirAbsPath = "";
    protected String strDkcFncDirAbsPath = "";
    protected String strDkcCnfDirAbsPath = "";
    protected String strDkcDefDirAbsPath = "";
    protected String strDkcWrkDirAbsPath = "";
    protected String strFncDirName = "";

    protected void calledExternal(String[] argv) {
        try {
            this.funcExecute(argv);
        }
        catch (SJcmdMappDkcSetException e) {
            this.doIllegalEnd(argv, e);
        }
        catch (Exception e) {
            SJcmdMappDkcSetException eIllegalEnd = new SJcmdMappDkcSetException("207502", "An internal error occurred.", null);
            String strErrId = eIllegalEnd.get_strMsgCode();
            System.out.println("Illegal end:" + strErrId);
            SJcmdMappDkcSetUtility.outputMessage(eIllegalEnd.get_strMessage());
            System.exit(1);
        }
        this.doNormalEnd(argv);
    }

    protected void funcExecute(String[] argv) throws SJcmdMappDkcSetException, Exception {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        this.initLogger();
        this.initEnv();
        try {
            SJcLogUty.getLogger().info("MappIniSet", LOG_FUNCTION, LOG_METHOD, "Start");
            this.initDirectory();
            this.checkArgvParameter(argv);
            SJcmdMappDkcSetUtility.deleteFile(this.strDkcWrkDirAbsPath);
            this.execute();
            SJcmdMappDkcSetUtility.deleteFile(this.strDkcWrkDirAbsPath);
            SJcLogUty.getLogger().info("MappIniSet", LOG_FUNCTION, LOG_METHOD, "End");
        }
        catch (SJcmdMappDkcSetException e) {
            String strErrId = e.get_strMsgID();
            if (!strErrId.equals("209501")) {
                SJcLogUty.getLogger().error("MappIniSet", LOG_FUNCTION, LOG_METHOD, SJcmdMappDkcSetException.class.getSimpleName() + " is occurred", e);
            }
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("MappIniSet", LOG_FUNCTION, LOG_METHOD, Exception.class.getSimpleName() + " is occurred", e);
            throw new SJcmdMappDkcSetException("207500");
        }
    }

    private void initLogger() throws Exception {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        URL logurl = SJcmdMappDkcSetBaseFunction.class.getResource("logback.xml");
        configurator.doConfigure(logurl);
    }

    private void initEnv() {
        String jarPath = System.getProperty(KEY_JAR_PATH);
        String[] jarPathList = jarPath.split(";");
        String strMappIniSetDirBaseAbsPath = new File(jarPathList[0]).getParentFile().getParentFile().getParentFile().getAbsolutePath();
        System.setProperty("SN_BasePath", strMappIniSetDirBaseAbsPath);
        String strMappIniSetDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(strMappIniSetDirBaseAbsPath, "san", "SN2", "SN2Files");
        System.setProperty("SN_DataPath", strMappIniSetDirAbsPath);
        System.setProperty("SN_EnvFile", new File(strMappIniSetDirAbsPath, SJcmdMappDkcSetUtility.concatFilePath("data", "base", "setting", "system", "properties", "SN2_Startup.properties")).getAbsolutePath());
        System.setProperty("SN_EnvFileV", new File(strMappIniSetDirAbsPath, SJcmdMappDkcSetUtility.concatFilePath("data", "base", "setting", "system", "properties", "SN2_StartupV.properties")).getAbsolutePath());
        System.setProperty("SN_LogPath", "MappIniSet");
        SJbaseSystemPropertiesManager clsEnv = null;
        clsEnv = new SJbaseSystemPropertiesManager();
        clsEnv.initialize(0);
    }

    private void initDirectory() {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcLogUty.getLogger().info("MappIniSet", LOG_FUNCTION, LOG_METHOD, "Start");
        String jarPath = System.getProperty(KEY_JAR_PATH);
        String[] jarPathList = jarPath.split(";");
        this.strMapDirAbsPath = new File(jarPathList[0]).getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getAbsolutePath() + File.separator;
        this.strFncDirName = this.makeStrFncDirName();
        this.strModDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(this.strMapDirAbsPath, DIR_WK, "supervisor", "MappIniSet");
        this.strCmnDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(this.strModDirAbsPath, "MpCmn");
        this.strFncDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(this.strModDirAbsPath, this.strFncDirName);
        this.strCnfDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(this.strModDirAbsPath, this.strFncDirName, "cnf");
        this.strWrkDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(this.strModDirAbsPath, this.strFncDirName, "wrk");
        this.strDefDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(this.strModDirAbsPath, this.strFncDirName, "def");
        this.strDkcDirAbsPath = new File(jarPathList[0]).getParentFile().getParentFile().getParentFile().getParentFile() + File.separator;
        this.strDkcModDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(this.strDkcDirAbsPath, "MappIniSet");
        this.strDkcCmnDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(this.strDkcModDirAbsPath, "MpCmn");
        this.strDkcFncDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(this.strDkcModDirAbsPath, this.strFncDirName);
        this.strDkcCnfDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(this.strDkcModDirAbsPath, this.strFncDirName, "cnf");
        this.strDkcWrkDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(this.strDkcModDirAbsPath, this.strFncDirName, "wrk");
        this.strDkcDefDirAbsPath = SJcmdMappDkcSetUtility.concatFilePath(this.strDkcModDirAbsPath, this.strFncDirName, "def");
        SJcLogUty.getLogger().info("MappIniSet", LOG_FUNCTION, LOG_METHOD, "End");
    }

    protected abstract String makeStrFncDirName();

    protected abstract void checkArgvParameter(String[] var1) throws SJcmdMappDkcSetException;

    protected void checkNullArgvParameter(String[] argv) throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (argv == null || argv.length == 0) {
            SJcLogUty.getLogger().error("MappIniSet", LOG_FUNCTION, LOG_METHOD, "argv is null or size zero");
            throw new SJcmdMappDkcSetException("207500");
        }
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i] != null) continue;
            SJcLogUty.getLogger().error("MappIniSet", LOG_FUNCTION, LOG_METHOD, "argv[" + i + "] is null");
            throw new SJcmdMappDkcSetException("207500");
        }
        if (!argv[0].equals(String.valueOf(0)) && !argv[0].equals(String.valueOf(1))) {
            SJcLogUty.getLogger().error("MappIniSet", LOG_FUNCTION, LOG_METHOD, "argv[0] is invalid");
            throw new SJcmdMappDkcSetException("207505");
        }
    }

    protected abstract void execute() throws SJcmdMappDkcSetException;

    private void doNormalEnd(String[] argv) {
        if (argv[0].equals(Integer.toString(0))) {
            this.doNormalEndSupervisor();
        } else {
            this.doNormalEndDkc();
        }
    }

    private void doNormalEndSupervisor() {
        System.exit(0);
    }

    private void doNormalEndDkc() {
        SJcmdMappDkcSetException eNormalEnd = new SJcmdMappDkcSetException("209500");
        String strErrCode = eNormalEnd.get_strMsgCode();
        System.out.println(SJcmdMappDkcSetWordUty.getGuidance(GUID_NORMALEND) + strErrCode);
        SJcmdMappDkcSetUtility.outputMessage(eNormalEnd.get_strMessage());
        SJcmdMappDkcSetUtility.outputMessage(eNormalEnd.get_strMeasure());
        System.exit(0);
    }

    private void doIllegalEnd(String[] argv, SJcmdMappDkcSetException e) {
        if (argv == null || argv.length == 0 || argv[0] == null) {
            this.doExceptionEndDkc();
        } else if (argv[0].equals(Integer.toString(0))) {
            this.doIllegalEndSupervisor(e);
        } else {
            this.doIllegalEndDkc(e);
        }
    }

    private void doIllegalEndSupervisor(SJcmdMappDkcSetException e) {
        if (e.isDispSupervisor()) {
            System.out.println(e.get_strMsgID());
            System.out.println(e.get_strMessage());
            System.out.println(e.get_strMeasure());
            System.exit(Integer.valueOf(e.get_strMsgID()));
        } else {
            this.doExceptionEndSupervisor();
        }
    }

    private void doIllegalEndDkc(SJcmdMappDkcSetException e) {
        String strErrId = e.get_strMsgID();
        String prefix = SJcmdMappDkcSetWordUty.getGuidance(GUID_ILLEGALEND);
        if (strErrId.equals("209501")) {
            prefix = SJcmdMappDkcSetWordUty.getGuidance(GUID_NORMALEND);
        }
        System.out.println(prefix + e.get_strMsgCode());
        SJcmdMappDkcSetUtility.outputMessage(e.get_strMessage());
        SJcmdMappDkcSetUtility.outputMessage(e.get_strMeasure());
        System.exit(Integer.valueOf(e.get_strMsgID()));
    }

    private void doExceptionEndSupervisor() {
        System.exit(1);
    }

    private void doExceptionEndDkc() {
        SJcmdMappDkcSetException eIllegalEnd = new SJcmdMappDkcSetException("207502");
        String strErrCode = eIllegalEnd.get_strMsgCode();
        System.out.println(SJcmdMappDkcSetWordUty.getGuidance(GUID_ILLEGALEND) + strErrCode);
        SJcmdMappDkcSetUtility.outputMessage(eIllegalEnd.get_strMessage());
        SJcmdMappDkcSetUtility.outputMessage(eIllegalEnd.get_strMeasure());
        System.exit(1);
    }
}

