/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.JCStringTokenizer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;

public class JCTypeConverter {
    public static boolean reportErrors = true;

    public static void checkEnum(int n, String string, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid " + string + ": " + n);
    }

    public static void error(String string) {
        System.err.println(string);
    }

    public static void error(String string, String string2) {
        JCTypeConverter.error("Error parsing '" + string2 + "' in " + string);
    }

    public static String fromDate(Date date, String string) {
        if (date == null) {
            return string;
        }
        try {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
            simpleDateFormat.setCalendar(Calendar.getInstance());
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            return simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String fromEnum(int n, String string, String string2, String[][] stringArray, int[][] nArray, String string3) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2][0].equalsIgnoreCase(string2)) break;
            ++n2;
        }
        if (n2 == stringArray.length) {
            return null;
        }
        int n3 = 0;
        while (n3 < nArray[n2].length) {
            if (nArray[n2][n3] == n) {
                return stringArray[n2][n3 + 1];
            }
            ++n3;
        }
        try {
            return String.valueOf(n);
        }
        catch (Exception exception) {
            JCTypeConverter.error("Error converting '" + n + "' to " + string);
            return string3;
        }
    }

    public static String fromEnum(int n, String[] stringArray, int[] nArray) {
        if (nArray == null || stringArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2] && n2 < stringArray.length) {
                return stringArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public static String fromEnum(long l, String[] stringArray, long[] lArray) {
        if (lArray == null || stringArray == null) {
            return null;
        }
        int n = 0;
        while (n < lArray.length) {
            if (l == lArray[n] && n < stringArray.length) {
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    public static String fromMatchListObject(Object object, String[] stringArray, Object[] objectArray) {
        if (objectArray == null || stringArray == null) {
            return null;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (object == objectArray[n] && n < stringArray.length) {
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    public static String fromNewLine(String string) {
        if (string == null || string.indexOf(10) == -1) {
            return string;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        char[] cArray = new char[string.length() + n];
        n2 = 0;
        int n3 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                cArray[n3++] = 92;
                cArray[n3] = 110;
            } else {
                cArray[n3] = string.charAt(n2);
            }
            ++n2;
            ++n3;
        }
        return new String(cArray, 0, n3);
    }

    public static String fromStringList(List list) {
        return JCTypeConverter.fromStringList(list, ',');
    }

    public static String fromStringList(List list, char c) {
        if (list == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            stringBuffer.append(list.get(n));
            if (n != list.size() - 1) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String fromStringList(String[] stringArray) {
        return JCTypeConverter.fromStringList(stringArray, ',');
    }

    public static String fromStringList(String[] stringArray, char c) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n != stringArray.length - 1) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void parseError(String string) {
        if (reportErrors) {
            JCTypeConverter.error("Error parsing '" + string + "'");
        }
    }

    public static String removeEscape(String string) {
        if (string == null || string.indexOf(92) == -1) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            cArray[n3] = n2 + 1 < n && c == '\\' ? (string.charAt(++n2) == 'n' ? 10 : string.charAt(n2)) : c;
            ++n2;
            ++n3;
        }
        return n3 > 0 ? new String(cArray, 0, n3) : null;
    }

    public static boolean toBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        try {
            return Boolean.valueOf(string);
        }
        catch (Exception exception) {
            JCTypeConverter.parseError(string);
            return bl;
        }
    }

    public static Date toDate(String string, Date date) {
        if (string == null) {
            return date;
        }
        try {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
            simpleDateFormat.setCalendar(Calendar.getInstance());
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return date;
        }
    }

    public static double toDouble(String string, double d) {
        if (string == null) {
            return d;
        }
        try {
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            JCTypeConverter.parseError(string);
            return d;
        }
    }

    public static Double[] toDoubleList(String string, char c) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Double[] doubleArray = new Double[jCStringTokenizer.countTokens(c)];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c).trim();
            doubleArray[n] = new Double(JCTypeConverter.toDouble(string2, 0.0));
            ++n;
        }
        return doubleArray;
    }

    public static Double[] toDoubleList(String string, char c, Double[] doubleArray) {
        Double[] doubleArray2 = JCTypeConverter.toDoubleList(string, c);
        return doubleArray2 != null ? doubleArray2 : doubleArray;
    }

    public static int toEnum(String string, String string2, String string3, String[][] stringArray, int[][] nArray, int n) {
        if (string3 == null) {
            string3 = string2;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2][0].equalsIgnoreCase(string2)) break;
            ++n2;
        }
        if (n2 == stringArray.length) {
            JCTypeConverter.error("Error converting '" + string + "' to " + string3);
            return n;
        }
        string = string.trim();
        int n3 = 1;
        while (n3 < stringArray[n2].length) {
            if (string.equalsIgnoreCase(stringArray[n2][n3])) {
                return nArray[n2][n3 - 1];
            }
            ++n3;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            JCTypeConverter.error("Error converting '" + string + "' to " + string3);
            return n;
        }
    }

    public static int toEnum(String string, String string2, String[] stringArray, int[] nArray, int n) {
        if (string == null) {
            return n;
        }
        string = string.trim();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n2])) {
                return nArray[n2];
            }
            ++n2;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            JCTypeConverter.error("Error converting '" + string + "' to " + string2);
            return n;
        }
    }

    public static long toEnum(String string, String string2, String[] stringArray, long[] lArray, long l) {
        if (string == null) {
            return l;
        }
        string = string.trim();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return lArray[n];
            }
            ++n;
        }
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            JCTypeConverter.error("Error converting '" + string + "' to " + string2);
            return l;
        }
    }

    public static int toEnum(String string, String[] stringArray, int[] nArray, int n) {
        if (string == null) {
            return n;
        }
        string = string.trim();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n2])) {
                return nArray[n2];
            }
            ++n2;
        }
        return n;
    }

    public static int[] toEnumList(String string, String string2, String[] stringArray, int[] nArray, int[] nArray2) {
        if (string == null) {
            return nArray2;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        int[] nArray3 = new int[jCStringTokenizer.countTokens(',')];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string3 = jCStringTokenizer.nextToken(',').trim();
            int n2 = nArray2 != null && n < nArray2.length ? nArray2[n] : 0;
            nArray3[n] = JCTypeConverter.toEnum(string3, string2, stringArray, nArray, n2);
            ++n;
        }
        return nArray3;
    }

    public static int toInt(String string, int n) {
        if (string == null) {
            return n;
        }
        if (string.equalsIgnoreCase("maxint")) {
            return Integer.MAX_VALUE;
        }
        if (string.equalsIgnoreCase("novalue")) {
            return -999;
        }
        if (string.equalsIgnoreCase("variable")) {
            return -998;
        }
        if (string.equalsIgnoreCase("default")) {
            return -999;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            JCTypeConverter.parseError(string);
            return n;
        }
    }

    public static int[] toIntList(String string, char c) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        int[] nArray = new int[jCStringTokenizer.countTokens(c)];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c).trim();
            nArray[n] = JCTypeConverter.toInt(string2, 0);
            ++n;
        }
        return nArray;
    }

    public static int[] toIntList(String string, char c, int[] nArray) {
        int[] nArray2 = JCTypeConverter.toIntList(string, c);
        return nArray2 != null ? nArray2 : nArray;
    }

    public static Integer[] toIntegerList(String string, char c) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Integer[] integerArray = new Integer[jCStringTokenizer.countTokens(c)];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c).trim();
            integerArray[n] = new Integer(JCTypeConverter.toInt(string2, 0));
            ++n;
        }
        return integerArray;
    }

    public static Integer[] toIntegerList(String string, char c, Integer[] integerArray) {
        Integer[] integerArray2 = JCTypeConverter.toIntegerList(string, c);
        return integerArray2 != null ? integerArray2 : integerArray;
    }

    public static Object toMatchListObject(String string, String[] stringArray, Object[] objectArray) {
        if (objectArray == null || stringArray == null) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n]) && n < objectArray.length) {
                return objectArray[n];
            }
            ++n;
        }
        return null;
    }

    public static String toNewLine(String string) {
        if (string == null || string.indexOf("\\n") == -1) {
            return string;
        }
        char[] cArray = new char[string.length()];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (string.charAt(n2) == '\\' && n2 < cArray.length - 1 && string.charAt(n2 + 1) == 'n') {
                cArray[n] = 10;
                ++n2;
            } else {
                cArray[n] = string.charAt(n2);
            }
            ++n2;
            ++n;
        }
        return new String(cArray, 0, n);
    }

    public static String toString(Object object) {
        if (!(object instanceof Vector)) {
            return JCTypeConverter.fromNewLine(object != null ? object.toString() : "");
        }
        Vector vector = (Vector)object;
        StringBuffer stringBuffer = new StringBuffer(vector.size());
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            stringBuffer.append(JCTypeConverter.toString(vector.elementAt(n)));
            if (n < n2 - 1) {
                stringBuffer.append(',');
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    public static String[] toStringList(String string) {
        return JCTypeConverter.toStringList(string, ',');
    }

    public static String[] toStringList(String string, char c) {
        return JCTypeConverter.toStringList(string, c, true);
    }

    public static String[] toStringList(String string, char c, boolean bl) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        String[] stringArray = new String[jCStringTokenizer.countTokens(c)];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = jCStringTokenizer.nextToken(c);
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = string3.trim()) == null) {
                string2 = "";
            }
            stringArray[n] = bl ? string2 : string3;
            ++n;
        }
        return stringArray;
    }

    public static Vector toVector(String string, char c) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Vector<String> vector = new Vector<String>(jCStringTokenizer.countTokens(c));
        jCStringTokenizer.strip_esc = false;
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c);
            vector.addElement(string2);
            ++n;
        }
        return vector;
    }

    public static Vector toVector(String string, char c, Vector vector) {
        Vector vector2 = JCTypeConverter.toVector(string, c);
        return vector2 != null ? vector2 : vector;
    }

    public static String trim(Object object) {
        String string;
        if (object == null || (string = object.toString()) == null) {
            return null;
        }
        int n = (string = string.trim()).indexOf(0);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }
}

