/*
 * Decompiled with CFR 0.152.
 */
package sanproject.trlog.utility;

import java.io.File;
import sanproject.trlog.utility.com.TRLogComUty;
import sanproject.trlog.utility.com.TRLogLevel;
import sanproject.trlog.utility.com.TRLogLockUty;
import sanproject.trlog.utility.com.TRPathUty;
import sanproject.trlog.utility.main.TRLogInnerMain;

public class TroubleshootLogUty {
    public static void error(String appName, String trCode, String msg) {
        TroubleshootLogUty.logCommon(TRLogLevel.ERROR, appName, trCode, msg);
    }

    public static void warn(String appName, String trCode, String msg) {
        TroubleshootLogUty.logCommon(TRLogLevel.WARN, appName, trCode, msg);
    }

    public static void warn(String appName, String msg) {
        TroubleshootLogUty.warn(appName, "-", msg);
    }

    public static void info(String appName, String trCode, String msg) {
        TroubleshootLogUty.logCommon(TRLogLevel.INFO, appName, trCode, msg);
    }

    public static void info(String appName, String msg) {
        TroubleshootLogUty.info(appName, "-", msg);
    }

    public static void illegal(String appName, String trCode, String msg) {
        TroubleshootLogUty.logCommon(TRLogLevel.ILLEGAL, appName, trCode, msg);
    }

    private static void logCommon(TRLogLevel logLevel, String appName, String trCode, String msg) {
        TRPathUty uty = null;
        try {
            uty = new TRPathUty();
        }
        catch (Exception ex) {
            return;
        }
        appName = TroubleshootLogUty.checkAppName(appName);
        trCode = TroubleshootLogUty.checkParam(trCode);
        msg = TroubleshootLogUty.checkParam(msg);
        String logFilePath = uty.getLogFilePath();
        String lockFilePath = uty.getLockFilePath();
        TRPathUty.checkDirExist(new File(logFilePath).getParentFile());
        TRPathUty.checkDirExist(new File(lockFilePath).getParentFile());
        String propFilePath = uty.getPropertyFilePath();
        String logStr = TroubleshootLogUty.createLogStr(logLevel, appName, trCode, msg);
        TRLogLockUty lock = new TRLogLockUty(lockFilePath);
        lock.getLock();
        TroubleshootLogUty.outputLog(logFilePath, propFilePath, logStr);
        lock.releaseLock();
    }

    private static String checkParam(String param) {
        if (param == null || param.length() <= 0) {
            param = "-";
        } else if (param.length() > 256) {
            param = param.substring(0, 256);
        }
        return param;
    }

    private static String checkAppName(String param) {
        if ((param = TroubleshootLogUty.checkParam(param)).equals("-")) {
            param = "Parameter Error(Application Name)";
        }
        return param;
    }

    private static String createLogStr(TRLogLevel logLevel, String appName, String trCode, String msg) {
        String level = "INFO ";
        switch (logLevel) {
            case ERROR: {
                level = "ERROR";
                break;
            }
            case WARN: {
                level = "WARN ";
                break;
            }
            case INFO: {
                level = "INFO ";
                break;
            }
            case ILLEGAL: {
                level = "Parameter Error(Log Level)";
                break;
            }
            default: {
                level = "INFO ";
            }
        }
        String logStr = "[" + level + "]" + "[" + trCode + "]" + "[" + appName + "]" + "[" + msg + "]";
        return logStr;
    }

    private static void outputLog(String logFilePath, String propFilePath, String logStr) {
        try {
            TRLogInnerMain.main(new String[]{logFilePath, propFilePath, logStr});
        }
        catch (Exception e) {
            TRLogComUty.outException(e);
        }
    }
}

