/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen;

import com.ws.cim.codegen.FileFinder;
import com.ws.cim.codegen.GetFilesInDirectory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class CreateJar {
    private static final String OPT_JAR_FILE_NAME = "JAR";
    private static final String OPT_FILES = "FILES";
    private static final String OPT_EXCLUDE_DIRS = "EXCLUDEDIRS";
    private static final String OPT_SRC_DIR = "SRC";
    private final Map<String, String> cmdLine = new HashMap<String, String>();
    private String pathPart2Strip;

    public static void main(String[] args) {
        try {
            CreateJar jar = new CreateJar(args);
            jar.jarFiles();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private CreateJar() {
    }

    public CreateJar(String jarFileName, String srcDir, String files2Jar, String excludeDirRegEx) throws IOException, NullPointerException {
        this();
        this.cmdLine.put(OPT_JAR_FILE_NAME, jarFileName);
        this.cmdLine.put(OPT_SRC_DIR, srcDir);
        if (null != excludeDirRegEx) {
            this.cmdLine.put(OPT_EXCLUDE_DIRS, excludeDirRegEx);
        }
        if (null != files2Jar) {
            this.cmdLine.put(OPT_FILES, files2Jar);
        }
        this.setPathPart2Strip();
    }

    private CreateJar(String[] args) throws IOException {
        this();
        this.parseCommandLine(args);
        this.setPathPart2Strip();
    }

    private void add(File source, JarOutputStream target) throws IOException {
        String srcPath = source.getPath();
        if (srcPath.contains(this.pathPart2Strip)) {
            srcPath = srcPath.substring(this.pathPart2Strip.length() + 1);
        }
        JarEntry entry = new JarEntry(srcPath.replace("\\", "/"));
        entry.setTime(source.lastModified());
        target.putNextEntry(entry);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
            int count;
            byte[] buffer = new byte[10240];
            while (-1 != (count = in.read(buffer))) {
                target.write(buffer, 0, count);
            }
        }
    }

    public void jarFiles() throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        List<String> files = GetFilesInDirectory.getFileNames(this.cmdLine.get(OPT_SRC_DIR), (GetFilesInDirectory.FileCallback)new FileFinder(this.cmdLine.get(OPT_FILES), this.cmdLine.get(OPT_EXCLUDE_DIRS)));
        try (JarOutputStream jarStream = new JarOutputStream((OutputStream)new FileOutputStream(this.cmdLine.get(OPT_JAR_FILE_NAME)), manifest);){
            for (String file : files) {
                this.add(new File(file), jarStream);
            }
        }
    }

    private void parseCommandLine(String[] args) {
        if (null == args) {
            this.printUsage();
        }
        String lastArg = null;
        for (int i = 0; null != args && i < args.length; ++i) {
            String arg = args[i];
            String option = null;
            String value = "";
            if (arg.startsWith("-")) {
                lastArg = option = arg.substring(1);
            } else {
                option = lastArg;
                value = args[i];
            }
            this.cmdLine.put(option.toUpperCase(), value);
        }
        if (null == this.cmdLine.get(OPT_JAR_FILE_NAME)) {
            this.printUsage();
        }
        if (null == this.cmdLine.get(OPT_SRC_DIR)) {
            this.cmdLine.put(OPT_SRC_DIR, System.getProperty("user.dir"));
        }
    }

    private void printUsage() {
        System.err.println("Invalid command line:");
        System.err.println("-src [directory to start searching in]");
        System.err.println("\tIf not specified current directory is used");
        System.err.println("-jar [jar file name]");
        System.err.println("-files [RegEx for files to include in jar]");
        System.err.println("\te.g. '.class' for all files ending with '.class']");
        System.err.println("-excludeDirs [RegEx for directories to exclude from file search]");
        System.err.println("\te.g. skip 'src' and 'doc' directories \"src|doc\" for all files ending with '.class']");
        System.exit(1);
    }

    private void setPathPart2Strip() throws IOException {
        File f = new File(this.cmdLine.get(OPT_SRC_DIR));
        if (!f.isDirectory()) {
            throw new IOException(f.getName() + " must be a directory");
        }
        this.pathPart2Strip = f.getCanonicalFile().getAbsolutePath();
    }
}

