/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.cmpi;

import com.ws.cim.codegen.cmpi.CArgument;
import com.ws.cim.codegen.cmpi.CFunction;
import com.ws.cim.codegen.cmpi.CFunctionBody;
import java.util.ArrayList;
import javax.cim.CIMClass;

class InstanceMIGenerator {
    private ArrayList<CFunction> mFunctionList;
    private CIMClass mCIMClass;

    public InstanceMIGenerator(CIMClass pCIMClass) {
        this.mCIMClass = pCIMClass;
        this.mFunctionList = new ArrayList();
        this.setFunctions();
    }

    public ArrayList<CFunction> getFunctions() {
        return this.mFunctionList;
    }

    private void setFunctions() {
        this.addEnumInstanceNames();
        this.addEnumInstances();
        this.addGetInstance();
        this.addCreateInstance();
        this.addModifyInstance();
        this.addDeleteInstance();
        this.addExecQuery();
        this.addCleanup();
    }

    private void addEnumInstanceNames() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIInstanceMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pRslt", "CMPIResult"));
        arguments.add(new CArgument(true, "*pPath", "CMPIObjectPath"));
        this.commonBodyText(bText);
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Enumerate the names of the instances for a specified class. The names of all subclass instances are returned.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "enumInstanceNames", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addEnumInstances() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIInstanceMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pRslt", "CMPIResult"));
        arguments.add(new CArgument(true, "*pPath", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "**pPropList", "char"));
        bText.add("/* return status */");
        this.commonBodyText(bText);
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Enumerate the instances of a class. The instances of all subclasses are also returned.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "enumInstances", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addGetInstance() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIInstanceMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pRslt", "CMPIResult"));
        arguments.add(new CArgument(true, "*pPath", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "**pPropList", "char"));
        bText.add("/* return status */");
        bText.add("CMPIStatus ret = {CMPI_RC_ERR_FAILED,NULL};");
        bText.add("/*");
        bText.add("TODO - IMPLEMENT FUNCTION");
        bText.add("*/");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Get the instance specififed by the opbject path pPath.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "getInstance", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addCreateInstance() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIInstanceMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pRslt", "CMPIResult"));
        arguments.add(new CArgument(true, "*pPath", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "*pInst", "CMPIInstance"));
        bText.add("/* not supported */");
        bText.add("CMPIStatus ret = {CMPI_RC_ERR_NOT_SUPPORTED,NULL};");
        bText.add("pRslt->ft->returnDone(pRslt);");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Create the specified instance.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "createInstance", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addModifyInstance() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIInstanceMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pRslt", "CMPIResult"));
        arguments.add(new CArgument(true, "*pPath", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "*pInst", "CMPIInstance"));
        arguments.add(new CArgument(true, "**pPropList", "char"));
        bText.add("/* not supported */");
        bText.add("CMPIStatus ret = {CMPI_RC_ERR_NOT_SUPPORTED,NULL};");
        bText.add("pRslt->ft->returnDone(pRslt);");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Modifies the specified instance.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "modifyInstance", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addDeleteInstance() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIInstanceMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pRslt", "CMPIResult"));
        arguments.add(new CArgument(true, "*pPath", "CMPIObjectPath"));
        bText.add("/* not supported */");
        bText.add("CMPIStatus ret = {CMPI_RC_ERR_NOT_SUPPORTED,NULL};");
        bText.add("pRslt->ft->returnDone(pRslt);");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Delete the instance specified.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "deleteInstance", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addExecQuery() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIInstanceMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pRslt", "CMPIResult"));
        arguments.add(new CArgument(true, "*pPath", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "*pQry", "char"));
        arguments.add(new CArgument(true, "*pLang", "char"));
        bText.add("/* not supported */");
        bText.add("CMPIStatus ret = {CMPI_RC_ERR_NOT_SUPPORTED,NULL};");
        bText.add("pRslt->ft->returnDone(pRslt);");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "This method enumerates all instances of the class specified by the CIMObjectpath argument that satisfy the conditions defined by the query expression (query) in query language type (ql). The entire instances are returned, not just the object paths to them. NOTE: This method operates as if localOnly is false and propertyList is NULL; all local and inherited properties with the class origin attributes of each instance are returned.  \n \nTypically, a provider parses the query string, enumerates the instances in the class (op), and then filters those instances to match the query string (query) expressed using the specified query language (ql). The provider then returns an array containing the instances that match the query string.  \n \nProviders with access to an entity that handles indexing can pass the query string to that entity for parsing. For those providers who do not have any indexing/query filtering capabilites, the provider may ask the CIM object manager to handle the filtering. A return array of all CIMInstance which have a possibility of matching the filter may be returned (this can be the same result as an enumerate instances call), but with the first element of the array set to NULL. This NULL value indicates to the CIM object manager that it needs to handle the filtering. The filter is applied by the object manager and the filtered result is returned to the client.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "execQuery", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addCleanup() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        arguments.add(new CArgument(false, "*pMI", "CMPIInstanceMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(false, "pBool", "CMPIBoolean"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("CMPIStatus ret = {CMPI_RC_OK,NULL};");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Perform cleanup prior to unloading the Instance provider.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "instanceCleanup", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void commonBodyText(ArrayList<String> pBText) {
        pBText.add("CMPIStatus ret = {CMPI_RC_ERR_FAILED,NULL};");
        pBText.add("/*");
        pBText.add("TODO - IMPLEMENT FUNCTION");
        pBText.add("*/");
        pBText.add("return ret;");
    }

    protected CFunction createInstanceMI() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pBrk", "CMPIBroker"));
        arguments.add(new CArgument(false, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(false, "*pStatus", "CMPIStatus"));
        bText.add("/* The provider factory - Instance provider must have this. */");
        bText.add("static CMPIInstanceMIFT instanceMIFT = {");
        bText.add("CMPIVersion100,");
        bText.add("CMPIVersion100,");
        bText.add("\"" + this.mCIMClass.getName() + "\",");
        bText.add("instanceCleanup,");
        bText.add("enumInstanceNames,");
        bText.add("enumInstances,");
        bText.add("getInstance,");
        bText.add("createInstance,");
        bText.add("modifyInstance,");
        bText.add("deleteInstance,");
        bText.add("execQuery");
        bText.add("};");
        bText.add("");
        bText.add("static CMPIInstanceMI instanceMI = {NULL, &instanceMIFT};");
        bText.add("CMPIStatus status = {CMPI_RC_OK, NULL}; ");
        bText.add("CMPIInstanceMI* ret = NULL; ");
        bText.add("");
        bText.add("/* perform any one time initialization code here */ ");
        bText.add("");
        bText.add("/* if initialization succeeds  set ret */ ");
        bText.add("ret = &instanceMI; ");
        bText.add("");
        bText.add("/* if pStatus isn't NULL we need to update it with a success/failure value */ ");
        bText.add("if (pStatus != NULL) { ");
        bText.add("pStatus->rc = status.rc;");
        bText.add("pStatus->msg = status.msg; ");
        bText.add("} ");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "The " + this.mCIMClass.getName() + "_Create_InstanceMI() functions shall perform any necessary" + " initialization operations of this MI group.";
        CFunction method = new CFunction(comment, false, "CMPIInstanceMI *", this.mCIMClass.getName() + "_Create_InstanceMI", arguments, body.toString());
        return method;
    }
}

