/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.jsr48.provider;

import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.java.JavaDataConstant;
import com.ws.cim.codegen.java.JavaMethod;
import com.ws.cim.codegen.java.JavaMethodBody;
import com.ws.cim.codegen.java.JavaMethodVariable;
import com.ws.cim.codegen.jsr48.AbstractCodeGenerator;
import com.ws.cim.codegen.jsr48.CodeGeneratorConstants;
import com.ws.cim.codegen.jsr48.JavaArgument;
import java.util.ArrayList;
import javax.cim.CIMClassProperty;

class AssociatorProviderGenerator
extends AbstractCodeGenerator {
    private final CIMClassProperty<?>[] mCIMProp;
    private CIMClassProperty<?> mAssKeyPropOne;
    private CIMClassProperty<?> mAssKeyPropTwo;
    private final String mClassName;

    public AssociatorProviderGenerator(CIMClassProperty<?>[] pCIMProp, String pClassName) {
        this.mCIMProp = pCIMProp;
        this.mClassName = pClassName;
        this.getAssociatorKeyProp();
        this.setImports();
        this.setConstants();
        this.setMethods();
    }

    @Override
    public void setImports() {
        this.setImports("javax.cim.CIMObjectPath");
        this.setImports("javax.wbem.WBEMException");
        this.setImports("javax.wbem.provider.AssociatorProvider");
        this.setImports("javax.wbem.provider.ProviderHandle");
    }

    @Override
    public void setMethods() {
        this.addAssociatorNamesMethod();
        this.addAssociatorsMethod();
        this.addReferenceNamesMethod();
        this.addReferencesMethod();
    }

    @Override
    public void setDataMembers() {
    }

    @Override
    public void setConstants() {
        String comment = "A constant data member that holds the string value of the CIM Class.";
        this.mDataConstants.add(new JavaDataConstant(comment, JavaCodeWriterConstants.TYPE.PRIVATE, true, true, "String", "CCN_" + this.mClassName.toUpperCase().substring(4), "\"" + this.mClassName + "\""));
    }

    private void addAssociatorNamesMethod() {
        ArrayList<String> throwList = new ArrayList<String>();
        throwList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pAssocName", "CIMObjectPath"));
        argList.add(new JavaArgument(false, "pObjectName", "CIMObjectPath"));
        argList.add(new JavaArgument(false, "pResultClass", "String"));
        argList.add(new JavaArgument(false, "pRole", "String"));
        argList.add(new JavaArgument(false, "pResultRole", "String"));
        ArrayList<JavaMethodVariable> variable = new ArrayList<JavaMethodVariable>();
        variable.add(new JavaMethodVariable(false, "CloseableIterator", "oRet", "null"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("try{");
        bText.add("\n\t\t\tCloseableIterator<?> oRet = null;");
        bText.add("\n\t\t\tcheckAccess(mProviderHandle);");
        if (this.mAssKeyPropOne != null && this.mAssKeyPropTwo != null) {
            String keyNameOne = "CPN_" + this.mAssKeyPropOne.getName().toUpperCase();
            String keyOneClass = this.mAssKeyPropOne.getDataType().getRefClassName();
            String keyNameTwo = "CPN_" + this.mAssKeyPropTwo.getName().toUpperCase();
            String keyTwoClass = this.mAssKeyPropTwo.getDataType().getRefClassName();
            if (this.mAssKeyPropOne.hasQualifier("Min") || this.mAssKeyPropOne.hasQualifier("Max") || this.mAssKeyPropTwo.hasQualifier("Min") || this.mAssKeyPropTwo.hasQualifier("Max")) {
                bText.add("\n\t\t\tArrayList<CIMObjectPath> objArr = new ArrayList<CIMObjectPath>();");
                bText.add("\n\t\t\tString objName = pObjectName.getObjectName();");
                bText.add("\n\t\t\tif (objName.equalsIgnoreCase(\"" + keyOneClass + "\")) {");
                bText.add("\n\t\t\t\tif ((pRole != null) && (!pRole.equalsIgnoreCase(" + keyNameOne + "))) {");
                bText.add("\n\t\t\t\t\treturn (null);");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\t\tCloseableIterator<CIMObjectPath> eInstNames = mProviderHandle.enumerateInstanceNames(new");
                bText.add("\n\t\t\t\tCIMObjectPath(\"" + keyTwoClass + "\",pAssocName.getNamespace()));");
                bText.add("\n\t\t\t\twhile (eInstNames.hasNext()) {");
                bText.add("\n\t\t\t\t\tobjArr.add(((CIMObjectPath)eInstNames.next()));");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\t\toRet = new CloseableIteratorImpl(objArr.iterator());");
                bText.add("\n\t\t\t} else if (objName.equalsIgnoreCase(\"" + keyTwoClass + "\")) {");
                bText.add("\n\t\t\t\tif ((pRole != null) && (!pRole.equalsIgnoreCase(" + keyNameTwo + "))) {");
                bText.add("\n\t\t\t\t\treturn (null);");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\tCloseableIterator<CIMObjectPath> eInstNames = mProviderHandle.enumerateInstanceNames(new");
                bText.add("\n\t\t\tCIMObjectPath(\"" + keyOneClass + "\",pAssocName.getNamespace()));");
                bText.add("\n\t\t\twhile (eInstNames.hasNext()) {");
                bText.add("\n\t\t\t\tobjArr.add(((CIMObjectPath)eInstNames.next()));");
                bText.add("\n\t\t\t}");
                bText.add("\n\t\t\toRet = new CloseableIteratorImpl(objArr.iterator());");
                bText.add("\n\t\t\t}");
                bText.add("\n\t\t\treturn oRet;");
            } else {
                bText.add("\n\t\t\treturn oRet;");
            }
        } else {
            bText.add("\n\t\t\treturn oRet;");
        }
        bText.add("\n\t\t} catch(Throwable t){");
        bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(null, bText);
        JavaMethod m = new JavaMethod("This method is used to enumerate the names of CIM Instances that are associated to a particular source CIM Instance.This method is invoked in order to perform the AssociatorNames operation as defined by the CIM operations over HTTP spec  at <a href =\"http://www.dmtf.org\">www.dmtf.org</a>. \n \n@param pAssocName \n\t\t\tDefines the association that the objectName Object should be \n\t\t\tassociated to. The provider uses this information to identify \n\t\t\twhich association must be traversed in case it supports more \n\t\t\tthan one association. \n@param pObjectName \n\t\t\tDefines the source CIM Object whose associated Objects are to \n\t\t\tbe returned. This is an Instance name (modelpath). \n@param pResultClass \n\t\t\tThe pResultClass input parameter, if not NULL, MUST be a valid \n\t\t\tCIM Class name. It acts as a filter on the returned set of Objects \n\t\t\tby mandating that each returned Object MUST be an object path to \n\t\t\teach Instance of this Class or one of its subclasses. \n@param pRole \n\t\t\tThe pRole input parameter, if not NULL, MUST be a valid Property \n\t\t\tname. It acts as a filter on the returned set of Objects by mandating \n\t\t\tthat each returned Object MUST be associated to the source Object \n\t\t\tvia an Association in which the source Object plays the specified \n\t\t\trole (i.e. the name of the Property in the Association Class that \n\t\t\trefers to the source Object MUST match the value of this parameter). \n\t\t\tThus, if the Role input parameter is set to Antecedent, then only \n\t\t\tAssociations where the source Object is the Antecedent reference are \n\t\t\texamined. NOTE: The source Object is the objectName input parameter. \n@param pResultRole \n\t\t\tThe pResultRole input parameter, if not NULL, MUST be a valid Property \n\t\t\tname. It acts as a filter on the returned set of Objects by mandating \n\t\t\tthat each returned Object MUST be associated to the source Object via \n\t\t\tan Association in which the returned Object plays the specified role \n\t\t\t(i.e. the name of the Property in the Association Class that refers to \n\t\t\t the returned Object MUST match the value of this parameter). Thus, if \n\t\t\tthe resultRole input parameter is set to Dependent, then only \n\t\t\tAssociations where the returned Object is the Dependent reference are \n\t\t\texamined. NOTE: The source Object is the objectName input parameter. \n \n@return If successful, the method returns a CloseableIterator of \n\t\t\tCIMObjectPath meeting the requested criteria. If no Instances are \n\t\t\tfound, then the Provider NULL must be returned. \n \n@throws WBEMException \n\t\t\tIf unsuccessful, one of the following status codes may be returned. \n\t\t\tThe ORDERED list is: \n\t\t\t<ul> \n\t\t\t\t<li>CIM_ERR_ACCESS_DENIED \n\t\t\t\t<li>CIM_ERR_NOT_SUPPORTED \n\t\t\t\t<li>CIM_ERR_INVALID_NAMESPACE \n\t\t\t\t<li>CIM_ERR_INVALID_PARAMETER (including missing, duplicate, \n\t\t\t\tunrecognized or otherwise incorrect parameters) \n\t\t\t\t<li>CIM_ERR_FAILED (some other unspecified error occurred) \n\t\t\t</ul>", JavaCodeWriterConstants.TYPE.PUBLIC, false, "CloseableIterator", "associatorNames", argList, throwList, body.toString());
        this.mMethods.add(m);
    }

    private void addAssociatorsMethod() {
        ArrayList<String> throwList = new ArrayList<String>();
        throwList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pAssocName", "CIMObjectPath"));
        argList.add(new JavaArgument(false, "pObjectName", "CIMObjectPath"));
        argList.add(new JavaArgument(false, "pResultClass", "String"));
        argList.add(new JavaArgument(false, "pRole", "String"));
        argList.add(new JavaArgument(false, "pResultRole", "String"));
        argList.add(new JavaArgument(false, "pIncludeClassOrigin", "boolean"));
        argList.add(new JavaArgument(false, "pPropertyList", "String[]"));
        ArrayList<JavaMethodVariable> variable = new ArrayList<JavaMethodVariable>();
        variable.add(new JavaMethodVariable(false, "CloseableIterator", "oRet", "null"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("try{");
        bText.add("\n\t\t\tCloseableIterator<?> oRet = null;");
        bText.add("\n\t\t\tcheckAccess(mProviderHandle);");
        if (this.mAssKeyPropOne != null && this.mAssKeyPropTwo != null) {
            String keyNameOne = "CPN_" + this.mAssKeyPropOne.getName().toUpperCase();
            String keyOneClass = this.mAssKeyPropOne.getDataType().getRefClassName();
            String keyNameTwo = "CPN_" + this.mAssKeyPropTwo.getName().toUpperCase();
            String keyTwoClass = this.mAssKeyPropTwo.getDataType().getRefClassName();
            if (this.mAssKeyPropOne.hasQualifier("Min") || this.mAssKeyPropOne.hasQualifier("Max") || this.mAssKeyPropTwo.hasQualifier("Min") || this.mAssKeyPropTwo.hasQualifier("Max")) {
                bText.add("\n\t\t\tArrayList<CIMInstance> objArr = new ArrayList<CIMInstance>();");
                bText.add("\n\t\t\tString objName = pObjectName.getObjectName();");
                bText.add("\n\t\t\tif (objName.equalsIgnoreCase(\"" + keyOneClass + "\")) {");
                bText.add("\n\t\t\t\tif ((pRole != null) && (!pRole.equalsIgnoreCase(" + keyNameOne + "))) {");
                bText.add("\n\t\t\t\t\treturn (null);");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\t\tCloseableIterator<CIMInstance> eInst = mProviderHandle.enumerateInstances(");
                bText.add("\n\t\t\t\tnew CIMObjectPath(\"" + keyOneClass + "\", " + "pAssocName.getNamespace()), true, false," + "pIncludeClassOrigin, pPropertyList);");
                bText.add("\n\t\t\t\twhile (eInst.hasNext()) {");
                bText.add("\n\t\t\t\t\tobjArr.add(((CIMInstance) eInst.next()));");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\t\toRet = new CloseableIteratorImpl(objArr.iterator());");
                bText.add("\n\t\t\t} else if (objName.equalsIgnoreCase(\"" + keyTwoClass + "\")) {");
                bText.add("\n\t\t\t\tif ((pRole != null) && (!pRole.equalsIgnoreCase(" + keyNameTwo + "))) {");
                bText.add("\n\t\t\t\t\treturn (null);");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\t\tCloseableIterator<CIMInstance> eInst = mProviderHandle.enumerateInstances( new CIMObjectPath(\"" + keyOneClass + "\", " + "pAssocName.getNamespace()), true, false," + "pIncludeClassOrigin, pPropertyList);");
                bText.add("\n\t\t\t\twhile (eInst.hasNext()) {");
                bText.add("\n\t\t\t\t\tobjArr.add(((CIMInstance) eInst.next()));");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\t\toRet = new CloseableIteratorImpl(objArr.iterator());");
                bText.add("\n\t\t\t}");
            }
        }
        bText.add("\n\t\t\treturn oRet;");
        bText.add("\n\t\t} catch(Throwable t){");
        bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(null, bText);
        JavaMethod m = new JavaMethod("This method is used to enumerate CIM Instances that are associated to a particular source CIM Instance. The entire instances associated to the specified instance are returned.This method is invoked in order to perform the Associators operation as defined by the CIM operations over HTTP spec at <a href =\"http://www.dmtf.org\">www.dmtf.org</a>. \n \n@param pAssocName \n\t\t\tDefines the association that the objectName Object should be \n\t\t\tassociated to. The provider uses this information to identify \n\t\t\twhich association must be traversed in case it supports more \n\t\t\tthan one association. \n@param pObjectName \n\t\t\tDefines the source CIM Object whose associated Objects are to \n\t\t\tbe returned. This is an Instance name (modelpath). \n@param pResultClass \n\t\t\tThe pResultClass input parameter, if not NULL, MUST be a valid \n\t\t\tCIM Class name. It acts as a filter on the returned set of Objects \n\t\t\tby mandating that each returned Object MUST be an object path to \n\t\t\teach Instance of this Class or one of its subclasses. \n@param pRole \n\t\t\tThe pRole input parameter, if not NULL, MUST be a valid Property \n\t\t\tname. It acts as a filter on the returned set of Objects by mandating \n\t\t\tthat each returned Object MUST be associated to the source Object \n\t\t\tvia an Association in which the source Object plays the specified \n\t\t\trole (i.e. the name of the Property in the Association Class that \n\t\t\trefers to the source Object MUST match the value of this parameter). \n\t\t\tThus, if the Role input parameter is set to Antecedent, then only \n\t\t\tAssociations where the source Object is the Antecedent reference are \n\t\t\texamined. NOTE: The source Object is the objectName input parameter. \n@param pResultRole \n\t\t\tThe pResultRole input parameter, if not NULL, MUST be a valid Property \n\t\t\tname. It acts as a filter on the returned set of Objects by mandating \n\t\t\tthat each returned Object MUST be associated to the source Object via \n\t\t\tan Association in which the returned Object plays the specified role \n\t\t\t(i.e. the name of the Property in the Association Class that refers to \n\t\t\t the returned Object MUST match the value of this parameter). Thus, if \n\t\t\tthe resultRole input parameter is set to Dependent, then only \n\t\t\tAssociations where the returned Object is the Dependent reference are \n\t\t\texamined. NOTE: The source Object is the objectName input parameter. \n@param pIncludeClassOrigin \n\t\t\tThe class origin attribute is the name of the class that first defined \n\t\t\tthe property or method. If true, the class Origin attribute will be \n\t\t\tpresent for each property and method on all Objects returned.If false, \n\t\t\tthe class origin will not be present. \n@param pPropertyList \n\t\t\tIf the PropertyList input parameter is not NULL, the members of the \n\t\t\tarray define one or more Property names. Each returned Instance MUST \n\t\t\tNOT include elements for any Properties missing from this list. Note \n\t\t\tthat if LocalOnly is specified as true this acts as an additional \n\t\t\tfilter on the set of Properties returned (e.g. if Property A is \n\t\t\tincluded in the PropertyList but LocalOnly is set to true and A is not \n\t\t\tlocal to a returned Instance, then it will not be included in that \n\t\t\tInstance). If the PropertyList input parameter is an empty array this \n\t\t\tsignifies that no Properties are included in each returned Instance. \n\t\t\tIf the PropertyList input parameter is NULL this specifies that all \n\t\t\tProperties(subject to the conditions expressed by the other \n\t\t\tparameters) are included in each returned Instance. The PropertyList \n\t\t\tmay contain duplicate or invalid Property names. The Provider must \n\t\t\tignore them but otherwise process the request normally; i.e. the \n\t\t\treturned Instance(s) will not contain duplicate or invalid Property \n\t\t\tNames. Clients SHOULD NOT explicitly specify properties in the \n\t\t\tPropertyList parameter unless they have specified a non-NULL value \n\t\t\tfor the ResultClass parameter. \n \n@return If successful, the method returns a CloseableIterator of \n\t\t\tCIMInstances meeting the requested criteria. If no Instances are \n\t\t\tfound, then the Provider NULL must be returned. \n \n@throws WBEMException \n\t\t\tIf unsuccessful, one of the following status codes may be returned. \n\t\t\tThe ORDERED list is: \n\t\t\t<ul> \n\t\t\t\t<li>CIM_ERR_ACCESS_DENIED \n\t\t\t\t<li>CIM_ERR_NOT_SUPPORTED \n\t\t\t\t<li>CIM_ERR_INVALID_NAMESPACE \n\t\t\t\t<li>CIM_ERR_INVALID_PARAMETER (including missing, duplicate, \n\t\t\t\tunrecognized or otherwise incorrect parameters) \n\t\t\t\t<li>CIM_ERR_FAILED (some other unspecified error occurred) \n\t\t\t</ul>", JavaCodeWriterConstants.TYPE.PUBLIC, false, "CloseableIterator", "associators", argList, throwList, body.toString());
        this.mMethods.add(m);
    }

    private void addReferenceNamesMethod() {
        ArrayList<String> throwList = new ArrayList<String>();
        throwList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pAssocName", "CIMObjectPath"));
        argList.add(new JavaArgument(false, "pObjectName", "CIMObjectPath"));
        argList.add(new JavaArgument(false, "pRole", "String"));
        String classConstString = "CCN_" + this.mClassName.toUpperCase().substring(4);
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("try{");
        bText.add("\n\t\t\tCloseableIterator<?> oRet = null;");
        bText.add("\n\t\t\tcheckAccess(mProviderHandle);");
        if (this.mAssKeyPropOne != null && this.mAssKeyPropTwo != null) {
            String keyNameOne = "CPN_" + this.mAssKeyPropOne.getName().toUpperCase();
            String keyOneClass = this.mAssKeyPropOne.getDataType().getRefClassName();
            String keyNameTwo = "CPN_" + this.mAssKeyPropTwo.getName().toUpperCase();
            String keyTwoClass = this.mAssKeyPropTwo.getDataType().getRefClassName();
            if (this.mAssKeyPropOne.hasQualifier("Min") || this.mAssKeyPropOne.hasQualifier("Max") || this.mAssKeyPropTwo.hasQualifier("Min") || this.mAssKeyPropTwo.hasQualifier("Max")) {
                bText.add("\n\n\t\t\tArrayList<CIMObjectPath> objArr = new ArrayList<CIMObjectPath>();");
                bText.add("\n\t\t\tString objName = pObjectName.getObjectName();");
                bText.add("\n\t\t\tif (objName.equalsIgnoreCase(\"" + keyOneClass + "\")) {");
                bText.add("\n\t\t\t\tif ((pRole != null) && (!pRole.equalsIgnoreCase(" + keyNameOne + "))) {");
                bText.add("\n\t\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_NOT_FOUND);");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\t\tCIMObjectPath assocCOP = new CIMObjectPath(" + classConstString + ", pObjectName.getNamespace());");
                bText.add("\n\t\t\t\tCloseableIterator copArr = this.associatorNames(assocCOP,");
                bText.add("\n\t\t\t\tpObjectName, \"" + keyTwoClass + "\", pRole," + keyNameTwo + ");");
                bText.add("\n\t\t\t\twhile (copArr.hasNext()) {");
                bText.add("\n\t\t\t\t\tCIMProperty<?>[] propArr = {");
                bText.add("\n\t\t\t\t\tnew CIMProperty<CIMObjectPath>(" + keyNameOne + ", new CIMDataType(\"" + keyOneClass + "\"), pObjectName),");
                bText.add("\n\t\t\t\t\tnew CIMProperty<CIMObjectPath>(" + keyNameTwo + ", new CIMDataType(\"" + keyTwoClass + "\"), (CIMObjectPath) copArr.next()) };");
                bText.add("\n\t\t\t\t\tobjArr.add(new CIMObjectPath(" + classConstString + ", pAssocName.getNamespace(), propArr));");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\t} else if (objName.equalsIgnoreCase(\"" + keyTwoClass + "\")) {");
                bText.add("\n\t\t\t\tif ((pRole != null) && (!pRole.equalsIgnoreCase(" + keyNameTwo + "))) {");
                bText.add("\n\t\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_NOT_FOUND);");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\t\tCloseableIterator<CIMObjectPath> eInstNames = mProviderHandle.enumerateInstanceNames(new CIMObjectPath(\"" + keyOneClass + "\", pObjectName.getNamespace()));");
                bText.add("\n\t\t\t\twhile (eInstNames.hasNext()) {");
                bText.add("\n\t\t\t\t\tCIMProperty<?>[] propArr = {");
                bText.add("\n\t\t\t\t\t\tnew CIMProperty<CIMObjectPath>(" + keyNameOne + ", new CIMDataType(\"" + keyOneClass + "\"), (CIMObjectPath) eInstNames.next()), ");
                bText.add("\n\t\t\t\t\t\tnew CIMProperty<CIMObjectPath>(" + keyNameTwo + ", new CIMDataType(\"" + keyTwoClass + "\"), pObjectName) };");
                bText.add("\n\t\t\t\t\t\tobjArr.add(new CIMObjectPath(" + classConstString + ", pAssocName.getNamespace(), propArr));");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\t}");
                bText.add("\n\t\t\toRet = new CloseableIteratorImpl(objArr.iterator());");
            }
        }
        bText.add("\n\t\t\treturn oRet;");
        bText.add("\n\t\t} catch(Throwable t){");
        bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(null, bText);
        JavaMethod m = new JavaMethod("This method is used to enumerate the association objects that refer to a particular target CIM Instance. The object paths to association instances are returned.This method is invoked in order to perform the ReferenceNames operation as defined by the CIM operations over HTTP spec at <a href =\"http://www.dmtf.org\">www.dmtf.org</a>. \n \n@param pAssocName \n\t\t\tDefines the association that the objectName Object should be \n\t\t\tassociated to. The provider uses this information to identify \n\t\t\twhich association must be traversed in case it supports more \n\t\t\tthan one association. \n@param pObjectName \n\t\t\tDefines the source CIM Object whose associated Objects are to \n\t\t\tbe returned. This is an Instance name (modelpath). \n@param pRole \n\t\t\tThe pRole input parameter, if not NULL, MUST be a valid Property \n\t\t\tname. It acts as a filter on the returned set of Association \n\t\t\tInstances by mandating that each returned Association Instance \n\t\t\tMUST refer to the target Instance in which the target Instance \n\t\t\tplays the specified role (i.e. the name of the Property in the \n\t\t\tAssociation Instance that refers to the target Instance MUST \n\t\t\tmatch the value of this parameter). Thus, if Role input parameter \n\t\t\tis set to Antecedent, only Association Instances where target \n\t\t\tInstance is the Antecedent reference are returned. NOTE: The \n\t\t\ttarget Instance is the objectName input parameter. \n \n@return If successful, the method returns a CloseableIterator of \n\t\t\tCIMObjectPaths meeting the requested criteria. If no Instances \n\t\t\tare found, then the Provider NULL must be returned. \n \n@throws WBEMException \n\t\t\tIf unsuccessful, one of the following status codes may be returned. \n\t\t\tThe ORDERED list is: \n\t\t\t<ul> \n\t\t\t\t<li>CIM_ERR_ACCESS_DENIED \n\t\t\t\t<li>CIM_ERR_NOT_SUPPORTED \n\t\t\t\t<li>CIM_ERR_INVALID_NAMESPACE \n\t\t\t\t<li>CIM_ERR_INVALID_PARAMETER (including missing, duplicate, \n\t\t\t\tunrecognized or otherwise incorrect parameters) \n\t\t\t\t<li>CIM_ERR_FAILED (some other unspecified error occurred) \n\t\t\t</ul>", JavaCodeWriterConstants.TYPE.PUBLIC, false, "CloseableIterator", "referenceNames", argList, throwList, body.toString());
        this.mMethods.add(m);
    }

    private void addReferencesMethod() {
        ArrayList<String> throwList = new ArrayList<String>();
        throwList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pAssocName", "CIMObjectPath"));
        argList.add(new JavaArgument(false, "pObjectName", "CIMObjectPath"));
        argList.add(new JavaArgument(false, "pRole", "String"));
        argList.add(new JavaArgument(false, "pIncludeClassOrigin", "boolean"));
        argList.add(new JavaArgument(false, "pPropertyList", "String[]"));
        String classConstString = "CCN_" + this.mClassName.toUpperCase().substring(4);
        ArrayList<JavaMethodVariable> variable = new ArrayList<JavaMethodVariable>();
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("\t\ttry{");
        bText.add("\n\t\t\tCloseableIterator<?> oRet = null;");
        bText.add("\n\t\t\tcheckAccess(mProviderHandle);");
        if (this.mAssKeyPropOne != null && this.mAssKeyPropTwo != null) {
            String keyNameOne = "CPN_" + this.mAssKeyPropOne.getName().toUpperCase();
            String keyOneClass = this.mAssKeyPropOne.getDataType().getRefClassName();
            String keyNameTwo = "CPN_" + this.mAssKeyPropTwo.getName().toUpperCase();
            String keyTwoClass = this.mAssKeyPropTwo.getDataType().getRefClassName();
            if (this.mAssKeyPropOne.hasQualifier("Min") || this.mAssKeyPropOne.hasQualifier("Max") || this.mAssKeyPropTwo.hasQualifier("Min") || this.mAssKeyPropTwo.hasQualifier("Max")) {
                variable.add(new JavaMethodVariable(false, "ArrayList<CIMInstance>", "objArr", "new ArrayList<CIMInstance>()"));
                this.mImports.add("javax.cim.CIMClass");
                bText.add("\n\n\t\t\tCIMClass cc = mProviderHandle.getClass(new CIMObjectPath(" + classConstString + ", pObjectName.getNamespace()), false, true, true, null);");
                bText.add("\n\t\t\tCIMInstance ci = cc.newInstance();");
                bText.add("\n\t\t\tString objName = pObjectName.getObjectName();");
                bText.add("\n\t\t\tif (objName.equalsIgnoreCase(\"" + keyOneClass + "\")) {");
                bText.add("\n\t\t\t\tif ((pRole != null) && (!pRole.equalsIgnoreCase(" + keyNameOne + "))) {");
                bText.add("\n\t\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_NOT_FOUND);");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\t\tCIMObjectPath assocCOP = new CIMObjectPath(" + classConstString + ", pObjectName.getNamespace());");
                bText.add("\n\t\t\t\tCloseableIterator copArr = this.associatorNames(assocCOP, pObjectName, \"" + keyTwoClass + "\", pRole, " + keyNameOne + ");");
                bText.add("\n\t\t\t\twhile (copArr.hasNext() && copArr != null) {");
                bText.add("\n\t\t\t\t\tCIMProperty<?>[] propArr = {");
                bText.add("\n\t\t\t\t\tnew CIMProperty<CIMObjectPath>(" + keyNameTwo + ", new CIMDataType(\"" + keyTwoClass + "\"), (CIMObjectPath) copArr.next()),");
                bText.add("new CIMProperty<CIMObjectPath>(" + keyNameOne + ", new CIMDataType(\"" + keyOneClass + "\"), pObjectName) };");
                bText.add("\n\t\t\t\t\tci = ci.deriveInstance(propArr);");
                bText.add("\n\t\t\t\t\tobjArr.add(ci.filterProperties(false, pIncludeClassOrigin, pPropertyList));");
                bText.add("}");
                bText.add("\n\t\t\t} else if (objName.equalsIgnoreCase(\"" + keyTwoClass + "\")) {");
                bText.add("\n\t\t\t\tif ((pRole != null) && (!pRole.equalsIgnoreCase(" + keyNameTwo + "))) {");
                bText.add("\n\t\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_NOT_FOUND,");
                bText.add(classConstString + ");");
                bText.add("\n\t\t\t\t}");
                bText.add("\n\t\t\t\tCloseableIterator<CIMObjectPath> eInstNames = mProviderHandle.enumerateInstanceNames(new CIMObjectPath(\"" + keyOneClass + "\", pObjectName.getNamespace()));");
                bText.add("\n\t\t\t\tCIMProperty<?>[] propArr = {");
                bText.add("\n\t\t\t\t\tnew CIMProperty<CIMObjectPath>(" + keyNameTwo + ", new CIMDataType(\"" + keyTwoClass + "\"), pObjectName),");
                bText.add("\n\t\t\t\t\tnew CIMProperty<CIMObjectPath>(" + keyNameOne + ", new CIMDataType(\"" + keyOneClass + "\"), (CIMObjectPath) eInstNames.next()) };");
                bText.add("\n\t\t\t\tci = ci.deriveInstance(propArr);");
                bText.add("\n\t\t\t\tobjArr.add(ci.filterProperties(false, pIncludeClassOrigin, pPropertyList));");
                bText.add("\n\t\t\t}");
                bText.add("\n\t\t\t\toRet = new CloseableIteratorImpl(objArr.iterator());");
            }
        }
        bText.add("\n\t\t\t\treturn oRet;");
        bText.add("\n\t\t} catch(Throwable t){");
        bText.add("\n\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(variable, bText);
        JavaMethod m = new JavaMethod("This method is used to enumerate the association objects that refer to a particular target CIM Instance.Entire association instances are returned. This method is invoked in order to perform the References operation as defined by the CIM operations over HTTP spec at <a href =\"http://www.dmtf.org\">www.dmtf.org</a>. \n \n@param pAssocName \n\t\t\tDefines the association that the objectName Object should be \n\t\t\tassociated to. The provider uses this information to identify \n\t\t\twhich association must be traversed in case it supports more \n\t\t\tthan one association. \n@param pObjectName \n\t\t\tDefines the source CIM Object whose associated Objects are to \n\t\t\tbe returned. This is an Instance name (modelpath). \n@param pRole \n\t\t\tThe pRole input parameter, if not NULL, MUST be a valid Property \n\t\t\tname. It acts as a filter on the returned set of Association \n\t\t\tInstances by mandating that each returned Association Instance \n\t\t\tMUST refer to the target Instance in which the target Instance \n\t\t\tplays the specified role (i.e. the name of the Property in the \n\t\t\tAssociation Instance that refers to the target Instance MUST \n\t\t\tmatch the value of this parameter). Thus, if Role input parameter \n\t\t\tis set to Antecedent, only Association Instances where target \n\t\t\tInstance is the Antecedent reference are returned. NOTE: The \n\t\t\ttarget Instance is the objectName input parameter. \n@param pPropertyList \n\t\t\tIf the pPropertyList input parameter is not NULL, the members of \n\t\t\tthe array define one or more Property names. Each returned \n\t\t\tInstance MUST NOT include elements for any Properties missing \n\t\t\tfrom this list. Note that if LocalOnly is specified as true this \n\t\t\tacts as an additional filter on the set of Properties returned \n\t\t\t(e.g. if Property A is included in the PropertyList but LocalOnly \n\t\t\tis set to true and A is not local to a returned Instance, then it \n\t\t\twill not be included in that Instance). If the PropertyList \n\t\t\tinput parameter is an empty array this signifies that no \n\t\t\tProperties are included in each returned Instance. If the \n\t\t\tPropertyList input parameter is NULL this specifies that all \n\t\t\tProperties (subject to the conditions expressed by the other \n\t\t\tparameters) are included in each returned Instance. The \n\t\t\tPropertyList may contain duplicate or invalid Property names. The \n\t\t\tProvider must ignore them but otherwise process the request \n\t\t\tnormally; i.e. the returned Instance(s) will not contain \n\t\t\tduplicate or invalid Property Names.Clients SHOULD NOT explicitly \n\t\t\tspecify properties in the PropertyList parameter unless they have \n\t\t\tspecified a non-NULL value for the ResultClass parameter. \n@param pIncludeClassOrigin \n\t\t\tThe class origin attribute is the name of the class that first \n\t\t\tdefined the property or method. If true, the class Origin \n\t\t\tattribute will be present for each property and method on all \n\t\t\tObjects returned. If false, the class origin will not be present. \n \n@return If successful, the method returns a CloseableIterator of \n\t\t\tCIMInstances meeting the requested criteria. If no Instances \n\t\t\texist, then the Provider NULL must be returned. \n \n@throws WBEMException \n\t\t\tIf unsuccessful, one of the following status codes may be returned. \n\t\t\tThe ORDERED list is: \n\t\t\t<ul> \n\t\t\t\t<li>CIM_ERR_ACCESS_DENIED \n\t\t\t\t<li>CIM_ERR_NOT_SUPPORTED \n\t\t\t\t<li>CIM_ERR_INVALID_NAMESPACE \n\t\t\t\t<li>CIM_ERR_INVALID_PARAMETER (including missing, duplicate, \n\t\t\t\tunrecognized or otherwise incorrect parameters) \n\t\t\t\t<li>CIM_ERR_FAILED (some other unspecified error occurred) \n\t\t\t</ul>", JavaCodeWriterConstants.TYPE.PUBLIC, false, "CloseableIterator", "references", argList, throwList, body.toString());
        this.mMethods.add(m);
    }

    private void getAssociatorKeyProp() {
        boolean propFlag = true;
        for (CIMClassProperty<?> ccp : this.mCIMProp) {
            String dataType;
            if (!ccp.isKey() || !(dataType = CodeGeneratorConstants.DATATYPE[ccp.getDataType().getType()]).equals("CIMObjectPath")) continue;
            if (propFlag) {
                this.mAssKeyPropOne = new CIMClassProperty(ccp.getName(), ccp.getDataType(), ccp.getValue(), ccp.getQualifiers(), ccp.isKey(), ccp.isPropagated());
                propFlag = false;
                continue;
            }
            this.mAssKeyPropTwo = new CIMClassProperty(ccp.getName(), ccp.getDataType(), ccp.getValue(), ccp.getQualifiers(), ccp.isKey(), ccp.isPropagated());
        }
    }
}

