/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmi.metaclass;

import com.ws.cim.xmi.metaclass.BaseMetaClass;
import com.ws.utilities.Resources;
import java.text.MessageFormat;
import javax.cim.CIMDataType;
import javax.cim.CIMParameter;

public class ParameterMetaClass
extends BaseMetaClass {
    private static final String BUNDLE = "com.ws.cim.xmi.XMIGenerator";
    private final String IN_QUALIFIER = "IN";
    private final String OUT_QUALIFIER = "OUT";
    private final String ARRAYTYPE_QUALIFIER = "ArrayType";
    private final String V_ARRAYTYPE = "Ordered";
    private CIMParameter<?> mParameter;
    private Resources mLocalResourceHandle;

    public ParameterMetaClass(CIMParameter<?> pParameter) {
        this.mParameter = pParameter;
        this.mName = pParameter.getName();
        this.mLocalResourceHandle = new Resources(BUNDLE);
    }

    public String toString(String pTabs) {
        boolean isUnique = true;
        String direction = this.getDirection();
        String type = this.generateType(pTabs + "\t");
        String lowerValue = this.generateLowerValue(pTabs + "\t");
        String upperValue = this.generateUpperValue(pTabs + "\t");
        String ownedComment = this.generateOwnedComment(this.mParameter, pTabs + "\t");
        String ownedOperation = MessageFormat.format(this.mLocalResourceHandle.loadString("PARAMETER_METACLASS"), pTabs, this.mName, direction, this.isOrdered(), isUnique, this.mVisibility, type, lowerValue, upperValue, ownedComment);
        return ownedOperation;
    }

    private boolean isOrdered() {
        return this.mParameter.hasQualifierValue("ArrayType", (Object)"Ordered");
    }

    private String getDirection() {
        StringBuilder direction = new StringBuilder();
        if (this.mParameter.hasQualifierValue("IN", (Object)Boolean.TRUE)) {
            direction.append("IN".toLowerCase());
        } else if (this.mParameter.hasQualifierValue("OUT", (Object)Boolean.TRUE)) {
            direction.append("OUT".toLowerCase());
        } else {
            direction.append("IN".toLowerCase());
        }
        return direction.toString();
    }

    private String generateType(String pTabs) {
        CIMDataType dataType = this.mParameter.getDataType();
        return this.getLiteralType(dataType);
    }

    private String getLiteralType(CIMDataType pDataType) {
        String DT_BOOLEAN = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#Boolean\"/>";
        String DT_CHAR16 = "<type xmi:idref=\"_char16\"/>";
        String DT_STRING = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#String\"/>";
        String DT_DATETIME = "<type xmi:idref=\"_datetime\"/>";
        String DT_UINT8 = "<type xmi:idref=\"_uint8\"/>";
        String DT_UINT16 = "<type xmi:idref=\"_uint16\"/>";
        String DT_UINT32 = "<type xmi:idref=\"_uint32\"/>";
        String DT_UINT64 = "<type xmi:idref=\"_uint64\"/>";
        String DT_SINT8 = "<type xmi:idref=\"_sint8\"/>";
        String DT_SINT16 = "<type xmi:idref=\"_sint16\"/>";
        String DT_SINT32 = "<type xmi:idref=\"_sint32\"/>";
        String DT_SINT64 = "<type xmi:idref=\"_sint64\"/>";
        String DT_REAL32 = "<type xmi:idref=\"_real32\"/>";
        String DT_REAL64 = "<type xmi:idref=\"_real64\"/>";
        String DT_BOOLEAN_ARRAY = "<type xmi:idref=\"_boolean__\"/>";
        String DT_CHAR16_ARRAY = "<type xmi:idref=\"_char__\"/>";
        String DT_STRING_ARRAY = "<type xmi:idref=\"_string__\"/>";
        String DT_DATETIME_ARRAY = "<type xmi:idref=\"_datetime__\"/>";
        String DT_UINT8_ARRAY = "<type xmi:idref=\"_uint8__\"/>";
        String DT_UINT16_ARRAY = "<type xmi:idref=\"_uint16__\"/>";
        String DT_UINT32_ARRAY = "<type xmi:idref=\"_uint32__\"/>";
        String DT_UINT64_ARRAY = "<type xmi:idref=\"_uint64__\"/>";
        String DT_SINT8_ARRAY = "<type xmi:idref=\"_sint8__\"/>";
        String DT_SINT16_ARRAY = "<type xmi:idref=\"_sint16__\"/>";
        String DT_SINT32_ARRAY = "<type xmi:idref=\"_sint32__\"/>";
        String DT_SINT64_ARRAY = "<type xmi:idref=\"_sint64__\"/>";
        String DT_REAL32_ARRAY = "<type xmi:idref=\"_real32__\"/>";
        String DT_REAL64_ARRAY = "<type xmi:idref=\"_real64__\"/>";
        int type = pDataType.getType();
        String literalType = "";
        if (!pDataType.isArray()) {
            switch (type) {
                case 9: {
                    literalType = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#Boolean\"/>";
                    break;
                }
                case 13: {
                    literalType = "<type xmi:idref=\"_char16\"/>";
                    break;
                }
                case 17: {
                    literalType = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#String\"/>";
                    break;
                }
                case 12: {
                    literalType = "<type xmi:idref=\"_datetime\"/>";
                    break;
                }
                case 15: {
                    literalType = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#String\"/>";
                    break;
                }
                case 10: {
                    literalType = "<type xmi:idref=\"_real32\"/>";
                    break;
                }
                case 11: {
                    literalType = "<type xmi:idref=\"_real64\"/>";
                    break;
                }
                case 14: {
                    literalType = "";
                    break;
                }
                case 8: {
                    literalType = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#String\"/>";
                    break;
                }
                case 1: {
                    literalType = "<type xmi:idref=\"_sint8\"/>";
                    break;
                }
                case 3: {
                    literalType = "<type xmi:idref=\"_sint16\"/>";
                    break;
                }
                case 5: {
                    literalType = "<type xmi:idref=\"_sint32\"/>";
                    break;
                }
                case 7: {
                    literalType = "<type xmi:idref=\"_sint64\"/>";
                    break;
                }
                case 0: {
                    literalType = "<type xmi:idref=\"_uint8\"/>";
                    break;
                }
                case 2: {
                    literalType = "<type xmi:idref=\"_uint16\"/>";
                    break;
                }
                case 4: {
                    literalType = "<type xmi:idref=\"_uint32\"/>";
                    break;
                }
                case 6: {
                    literalType = "<type xmi:idref=\"_uint64\"/>";
                    break;
                }
                default: {
                    literalType = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#String\"/>";
                    break;
                }
            }
        } else {
            switch (type) {
                case 9: {
                    literalType = "<type xmi:idref=\"_boolean__\"/>";
                    break;
                }
                case 13: {
                    literalType = "<type xmi:idref=\"_char__\"/>";
                    break;
                }
                case 17: {
                    literalType = "<type xmi:idref=\"_string__\"/>";
                    break;
                }
                case 12: {
                    literalType = "<type xmi:idref=\"_datetime__\"/>";
                    break;
                }
                case 15: {
                    literalType = "<type xmi:idref=\"_string__\"/>";
                    break;
                }
                case 10: {
                    literalType = "<type xmi:idref=\"_real32__\"/>";
                    break;
                }
                case 11: {
                    literalType = "<type xmi:idref=\"_real64__\"/>";
                    break;
                }
                case 14: {
                    literalType = "";
                    break;
                }
                case 8: {
                    literalType = "<type xmi:idref=\"_string__\"/>";
                    break;
                }
                case 1: {
                    literalType = "<type xmi:idref=\"_sint8__\"/>";
                    break;
                }
                case 3: {
                    literalType = "<type xmi:idref=\"_sint16__\"/>";
                    break;
                }
                case 5: {
                    literalType = "<type xmi:idref=\"_sint32__\"/>";
                    break;
                }
                case 7: {
                    literalType = "<type xmi:idref=\"_sint64__\"/>";
                    break;
                }
                case 0: {
                    literalType = "<type xmi:idref=\"_uint8__\"/>";
                    break;
                }
                case 2: {
                    literalType = "<type xmi:idref=\"_uint16__\"/>";
                    break;
                }
                case 4: {
                    literalType = "<type xmi:idref=\"_uint32__\"/>";
                    break;
                }
                case 6: {
                    literalType = "<type xmi:idref=\"_uint64__\"/>";
                    break;
                }
                default: {
                    literalType = "<type xmi:idref=\"_string__\"/>";
                }
            }
        }
        return literalType;
    }

    private String generateLowerValue(String pTabs) {
        String size = this.mParameter.hasQualifier("ArrayType") ? "0" : "1";
        String lowerValue = MessageFormat.format(this.mLocalResourceHandle.loadString("LOWER_VALUE"), pTabs, size);
        return lowerValue;
    }

    private String generateUpperValue(String pTabs) {
        String upperValue = "";
        String size = this.mParameter.getDataType().isArray() ? "*" : "1";
        upperValue = this.mParameter.getDataType().isArray() ? MessageFormat.format(this.mLocalResourceHandle.loadString("UPPER_VALUE_ARRAY"), pTabs, size) : MessageFormat.format(this.mLocalResourceHandle.loadString("UPPER_VALUE"), pTabs, size);
        return upperValue;
    }
}

