/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.store;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import sanproject.session.common.exception.SJsessionAuthenticationException;
import sanproject.session.common.exception.SJsessionException;
import sanproject.session.common.exception.SJsessionParameterException;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.process.plugin.SJsessionProcessPluginItem;
import sanproject.session.server.process.plugin.SJsessionProcessPluginManager;
import sanproject.session.server.receive.plugin.SJsessionReceivePluginItem;
import sanproject.session.server.receive.plugin.SJsessionReceivePluginManager;
import sanproject.session.server.store.SJsessionInfo;
import sanproject.session.server.store.SJsessionInfoApp;
import sanproject.session.server.store.manager.SJsessionEventManager;
import sanproject.session.server.store.task.SJsessionReauthTask;
import sanproject.session.server.store.task.SJsessionTimeoutTask;
import sanproject.session.server.unique.SJsessionUniqueIDManager;
import sanproject.sn2.base.authentication.inf.SJbaseAuthenticationModulePluginInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionStoreHouse {
    private static final String LOG_FUNCTION = "SessionServer";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    SJcLoggerInterface logger = null;
    HashMap<String, SJsessionInfo> table = null;
    SJsessionReauthTask reAuthTask = null;
    SJsessionTimeoutTask timeoutTask = null;
    Object syncObject = new Object();
    private static SJsessionStoreHouse storeHouse = null;

    private SJsessionStoreHouse() {
        this.table = new HashMap();
        this.logger = SJsessionServerUty.getLogger();
    }

    public static SJsessionStoreHouse createInstance() {
        if (storeHouse == null) {
            storeHouse = new SJsessionStoreHouse();
        }
        return storeHouse;
    }

    public static SJsessionStoreHouse getInstance() {
        return storeHouse;
    }

    public void initialize() {
        String LOG_SUBTITLE = "initialize";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "initialize", "Start.");
        this.table = new HashMap();
        this.initializeReauthTask();
        this.initializeTimeoutTask();
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "initialize", "End.");
    }

    private void initializeReauthTask() {
        String LOG_SUBTITLE = "initializeReauthTask";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "initializeReauthTask", "Start.");
        this.reAuthTask = new SJsessionReauthTask();
        HashMap<String, SJsessionReceivePluginItem> map = SJsessionReceivePluginManager.getPluginMap();
        for (String appID : map.keySet()) {
            HashMap<String, SJsessionProcessPluginItem> processPlugin = SJsessionProcessPluginManager.getPluginItemMap(appID);
            for (String loginType : processPlugin.keySet()) {
                SJsessionProcessPluginItem item = processPlugin.get(loginType);
                if (item.getReAuthTime() == -1) continue;
                this.reAuthTask.startTask(appID, loginType);
            }
        }
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "initializeReauthTask", "End.");
    }

    private void initializeTimeoutTask() {
        String LOG_SUBTITLE = "initializeTimeoutTask";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "initializeTimeoutTask", "Start.");
        this.timeoutTask = new SJsessionTimeoutTask();
        this.timeoutTask.startTask();
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "initializeTimeoutTask", "End.");
    }

    public void finish() {
        String LOG_SUBTITLE = "finish";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "finish", "Start.");
        this.finishReauthTask();
        this.finishTimeoutTask();
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "finish", "End.");
    }

    private void finishReauthTask() {
        String LOG_SUBTITLE = "finishReauthTask";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "finishReauthTask", "Start.");
        if (this.reAuthTask != null) {
            this.reAuthTask.finish();
            this.reAuthTask = null;
        }
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "finishReauthTask", "End.");
    }

    private void finishTimeoutTask() {
        String LOG_SUBTITLE = "finishTimeoutTask";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "finishTimeoutTask", "Start.");
        if (this.timeoutTask != null) {
            this.timeoutTask.finish();
            this.timeoutTask = null;
        }
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "finishTimeoutTask", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(SJsessionInfo info) throws SJsessionException {
        String LOG_SUBTITLE = "addSession";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "addSession", "Start.");
        HashMap<String, Object> eventData = null;
        if (info == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "addSession", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        String gsid = info.getGlobalSessionID();
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "addSession", "GSID:" + gsid);
        Object object = this.syncObject;
        synchronized (object) {
            if (this.table.containsKey(gsid)) {
                this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "addSession", "session already exists.");
                throw new SJsessionAuthenticationException("107000");
            }
            this.table.put(gsid, info);
            eventData = SJsessionServerUty.convertToHashMap(info);
        }
        SJsessionEventManager.setEvent("INFO_ADD", eventData);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "addSession", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chgSession(String gsid, SJsessionInfoApp infoApp) throws SJsessionException {
        String LOG_SUBTITLE = "chgSession";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "chgSession", "Start. GSID:" + gsid);
        HashMap<String, Object> eventData = null;
        if (gsid == null || infoApp == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "chgSession", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        Object object = this.syncObject;
        synchronized (object) {
            SJsessionInfo session = this.table.get(gsid);
            if (session == null) {
                this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "chgSession", "session not found.");
                throw new SJsessionAuthenticationException("107000");
            }
            String appID = infoApp.getAppID();
            session.setLoginInfo(appID, infoApp);
            eventData = SJsessionServerUty.convertToHashMap(session, appID);
            eventData.put("CHG_INFO_TYPE", "INFO_ADD");
        }
        SJsessionEventManager.setEvent("INFO_CHG", eventData);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "chgSession", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chgSession(String gsid, SJsessionInfo sessionInfo, SJsessionInfoApp infoApp) throws SJsessionException {
        String LOG_SUBTITLE = "chgSession";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "chgSession", "Start. GSID:" + gsid);
        HashMap<String, Object> eventData = null;
        if (gsid == null || sessionInfo == null || infoApp == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "chgSession", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        Object object = this.syncObject;
        synchronized (object) {
            SJsessionInfo session = this.table.get(gsid);
            if (session == null) {
                this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "chgSession", "session not found.");
                throw new SJsessionAuthenticationException("107000");
            }
            String appID = infoApp.getAppID();
            session.setLoginInfo(appID, infoApp);
            session = SJsessionServerUty.changeSessionInfo(session, sessionInfo);
            this.table.put(gsid, session);
            eventData = SJsessionServerUty.convertToHashMap(session, appID);
            eventData.put("CHG_INFO_TYPE", "INFO_ADD");
        }
        SJsessionEventManager.setEvent("INFO_CHG", eventData);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "chgSession", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String gsid) throws SJsessionException {
        String LOG_SUBTITLE = "removeSession";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "removeSession", "Start. GSID:" + gsid);
        HashMap<String, Object> eventData = null;
        SJsessionInfo session = null;
        if (gsid == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "removeSession", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        Object object = this.syncObject;
        synchronized (object) {
            session = this.table.get(gsid);
            if (session == null) {
                this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "removeSession", "session not found.");
                throw new SJsessionAuthenticationException("107000");
            }
            eventData = SJsessionServerUty.convertToHashMap(session);
            this.table.remove(gsid);
        }
        SJsessionEventManager.setEvent("INFO_DEL", eventData);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "removeSession", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoginInfo(String gsid, String appID) throws SJsessionException {
        String LOG_SUBTITLE = "removeLoginInfo";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "removeLoginInfo", "Start. GSID:" + gsid + " APP:" + appID);
        HashMap<String, Object> eventData = null;
        String eventKind = null;
        SJsessionInfo session = null;
        if (gsid == null || appID == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "removeLoginInfo", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        Object object = this.syncObject;
        synchronized (object) {
            session = this.table.get(gsid);
            if (session == null) {
                this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "removeLoginInfo", "session not found.");
                throw new SJsessionAuthenticationException("107000");
            }
            boolean bl = session.isExits(appID);
            if (!bl) {
                this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "removeLoginInfo", "LoginInfo not found.");
                throw new SJsessionAuthenticationException("107000");
            }
            eventData = SJsessionServerUty.convertToHashMap(session, appID);
            session.removeLoginInfo(appID);
            if (session.isEmptyLoginInfo()) {
                try {
                    SJsessionUniqueIDManager.releaseID(gsid);
                }
                catch (SJsessionException ex) {
                    this.logger.warn(LOG_FUNCTION, this.LOG_TITLE, "removeLoginInfo", "release connection unique ID error.");
                }
                this.table.remove(gsid);
                eventKind = "INFO_DEL";
            } else {
                eventKind = "INFO_CHG";
                eventData.put("CHG_INFO_TYPE", "INFO_DEL");
            }
        }
        SJsessionEventManager.setEvent(eventKind, eventData);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "removeLoginInfo", "End.");
    }

    public void removeLoginInfoAll(String appID) throws SJsessionException {
        String LOG_SUBTITLE = "removeLoginInfoAll";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "removeLoginInfoAll", "Start. APP:" + appID);
        if (appID == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "removeLoginInfoAll", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        List<SJsessionInfo> sessionList = this.getSessionInfoList();
        for (SJsessionInfo session : sessionList) {
            if (!session.isExits(appID)) continue;
            try {
                this.removeLoginInfo(session.getGlobalSessionID(), appID);
            }
            catch (SJsessionException ex) {
                this.logger.warn(LOG_FUNCTION, this.LOG_TITLE, "removeLoginInfoAll", "removeLoginInfo error.");
            }
        }
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "removeLoginInfoAll", "End.");
    }

    public SJsessionInfo getSession(String gsid) throws SJsessionException {
        String LOG_SUBTITLE = "getSession";
        if (gsid == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "getSession", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        SJsessionInfo result = this.table.get(gsid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HashMap<String, Object>> getSessionList() {
        ArrayList<HashMap<String, Object>> sessionList = new ArrayList<HashMap<String, Object>>();
        Object object = this.syncObject;
        synchronized (object) {
            for (String gsid : this.table.keySet()) {
                SJsessionInfo session = this.table.get(gsid);
                HashMap<String, Object> map = SJsessionServerUty.convertToHashMap(session);
                sessionList.add(map);
            }
        }
        return sessionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SJsessionInfo> getSessionInfoList() {
        ArrayList<SJsessionInfo> sessionList = new ArrayList<SJsessionInfo>();
        Object object = this.syncObject;
        synchronized (object) {
            for (String gsid : this.table.keySet()) {
                SJsessionInfo session = this.table.get(gsid);
                sessionList.add(session);
            }
        }
        return sessionList;
    }

    public void reauthenticateSession(String gsid, String appID) throws SJsessionException {
        String LOG_SUBTITLE = "reauthenticateSession";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "reauthenticateSession", "Start. GSID:" + gsid + " APP:" + appID);
        if (gsid == null || appID == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "reauthenticateSession", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        SJsessionInfo session = this.getSession(gsid);
        if (session == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "reauthenticateSession", "session not found.");
            throw new SJsessionAuthenticationException("107000");
        }
        SJsessionInfoApp loginInfo = session.getLoginInfo(appID);
        if (loginInfo == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "reauthenticateSession", "LoginInfo not found.");
            throw new SJsessionAuthenticationException("107000");
        }
        String user_id = loginInfo.getUserID();
        String password = loginInfo.getPassword();
        SJbaseAuthenticationModulePluginInterface auth = loginInfo.getAuthInstance();
        if (auth == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "reauthenticateSession", "AuthInstance is null.");
            throw new SJsessionAuthenticationException("107000");
        }
        int rtnAuthResult = auth.authentication(user_id, password);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "reauthenticateSession", "result:" + rtnAuthResult);
        if (rtnAuthResult != 0) {
            throw new SJsessionAuthenticationException("107000");
        }
        loginInfo.setReauthTime(new Date());
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "reauthenticateSession", "End.");
    }

    public List<String> notifyAlive(String appID, List<String> gsidList) throws SJsessionException {
        String LOG_SUBTITLE = "notifyAlive";
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "notifyAlive", "Start. APP:" + appID);
        if (appID == null || gsidList == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "notifyAlive", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        ArrayList<String> aliveList = new ArrayList<String>();
        HashMap<String, SJsessionInfoApp> aliveMap = new HashMap<String, SJsessionInfoApp>();
        List<SJsessionInfo> sessionList = this.getSessionInfoList();
        ArrayList<String> appUserList = new ArrayList<String>();
        for (SJsessionInfo session : sessionList) {
            SJsessionInfoApp loginInfo = session.getLoginInfo(appID);
            if (loginInfo == null) continue;
            appUserList.add(session.getGlobalSessionID());
            aliveMap.put(session.getGlobalSessionID(), loginInfo);
        }
        Iterator itKey = aliveMap.keySet().iterator();
        while (itKey.hasNext()) {
            String gsid = (String)itKey.next();
            boolean aliveFlg = gsidList.contains(gsid);
            if (aliveFlg) continue;
            itKey.remove();
        }
        for (String gsid : aliveMap.keySet()) {
            SJsessionInfoApp loginInfo = (SJsessionInfoApp)aliveMap.get(gsid);
            loginInfo.setAliveLastTime(SJsessionServerUty.getSystemTime());
            aliveList.add(gsid);
        }
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "notifyAlive", "End.");
        return aliveList;
    }

    public boolean isExsist(String gsid) {
        return this.table.containsKey(gsid);
    }
}

