/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.common;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import sanproject.serverux.ssl.uty.SSLUty;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseCustomSocketFactory
extends SSLSocketFactory {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseCustomSocketFactory";
    private SSLSocketFactory src = null;

    public void customSocket(SSLSocket socket) throws IOException {
        SSLUty.setEnabledProtocols(socket);
        SSLUty.setEnabledCipherSuites(socket);
        Object[] enabledProtocols = socket.getEnabledProtocols();
        Object[] enabledCipherSuites = socket.getEnabledCipherSuites();
        logger.info(module, "customSocket", "Protocol", Arrays.toString(enabledProtocols));
        logger.info(module, "customSocket", "CipherSuite", Arrays.toString(enabledCipherSuites));
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket socket = (SSLSocket)this.src.createSocket();
        this.customSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket socket = (SSLSocket)this.src.createSocket(s, host, port, autoClose);
        this.customSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.src.createSocket(host, port);
        this.customSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.src.createSocket(host, port, clientHost, clientPort);
        this.customSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.src.createSocket(host, port);
        this.customSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.src.createSocket(address, port, clientAddress, clientPort);
        this.customSocket(socket);
        return socket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.src.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.src.getSupportedCipherSuites();
    }

    public SJbaseCustomSocketFactory(SSLSocketFactory src) {
        this.src = src;
    }

    public static synchronized SSLSocketFactory getDefault() {
        SJbaseCustomSocketFactory sslSocketFactory;
        String method = "getDefault";
        logger.info(module, method, "", "start");
        try {
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(new FileInputStream(System.getProperty("KEY_SNBASE_KEYSTORE")), null);
            logger.info(module, method, "keystoreFileName=", System.getProperty("KEY_SNBASE_KEYSTORE"));
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            sslSocketFactory = new SJbaseCustomSocketFactory(sslContext.getSocketFactory());
        }
        catch (KeyStoreException e) {
            logger.info(module, method, "try to create SocketFactory for TLS", "failed by KeyStoreException");
            throw new SJbaseExCommunicationException();
        }
        catch (NoSuchAlgorithmException e) {
            logger.info(module, method, "try to create SocketFactory for TLS", "failed by NoSuchAlgorithmException");
            throw new SJbaseExCommunicationException();
        }
        catch (CertificateException e) {
            logger.info(module, method, "try to create SocketFactory for TLS", "failed by CertificateException");
            throw new SJbaseExCommunicationException();
        }
        catch (KeyManagementException e) {
            logger.info(module, method, "try to create SocketFactory for TLS", "failed by KeyManagementException");
            throw new SJbaseExCommunicationException();
        }
        catch (IOException e) {
            logger.info(module, method, "try to create SocketFactory for TLS", "failed by IOException");
            throw new SJbaseExCommunicationException();
        }
        logger.info(module, method, "", "end");
        return sslSocketFactory;
    }
}

