/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.ldap;

import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseConfigurationFactory;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalConst;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfiguration;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseLdapConfigurationFactory
extends SJbaseConfigurationFactory
implements SJbaseExternalConst {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseLdapConfigurationFactory";
    public static final String PROTOCOL = "protocol";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String RETRY_TIMES = "retry.times";
    public static final String RETRY_INTERVAL = "retry.interval";
    public static final String TIMEOUT = "timeout";
    public static final String LDAP_BASE = "auth.ldap";
    public static final String LDAP_SEARCH_PW = "searchpw";
    public static final String LDAP_SEARCH_DN = "searchdn";
    public static final String LDAP_USER_ATTR = "attr";
    public static final String LDAP_SEARCH_BASE = "basedn";
    public static final String DOMAIN_NAME = "domain.name";
    public static final String DNS_LOOKUP = "dns_lookup";
    public static final String GRP_MAPPING = "auth.group.mapping";

    public SJbaseLdapConfigurationFactory() {
    }

    public SJbaseLdapConfigurationFactory(Properties properties) {
        super(properties);
    }

    public SJbaseLdapConfiguration[] getConfigurations() {
        SJbaseLdapConfiguration[] configs;
        String method = "getConfigurations";
        logger.info(module, method, "", "start");
        if (this.properties == null) {
            logger.info(module, method, "check the configuration file object ", "object does not exist");
            configs = new SJbaseLdapConfiguration[]{};
        } else {
            String serverList = this.properties.getProperty("auth.server.name");
            if (serverList == null || serverList.length() == 0) {
                logger.info(module, method, "check the server name", "invlaid");
                configs = new SJbaseLdapConfiguration[]{};
            } else {
                String[] serverListArry = serverList.split(",");
                configs = new SJbaseLdapConfiguration[serverListArry.length];
                for (int i = 0; i < serverListArry.length; ++i) {
                    String tmpServerName = serverListArry[i];
                    logger.info(module, method, "start to construct the configuration object", tmpServerName + ":[" + i + "]");
                    SJbaseLdapConfiguration tmpConf = new SJbaseLdapConfiguration();
                    this.setServerName(tmpConf, tmpServerName);
                    this.setLdapProtocol(tmpConf, tmpServerName);
                    this.setHost(tmpConf, tmpServerName);
                    this.setPort(tmpConf, tmpServerName);
                    this.setTimeout(tmpConf, tmpServerName);
                    this.setRetryTimes(tmpConf, tmpServerName);
                    this.setRetryInterval(tmpConf, tmpServerName);
                    this.setSearchUserPassword(tmpConf, tmpServerName);
                    this.setSearchUserDN(tmpConf, tmpServerName);
                    this.setUserAttr(tmpConf, tmpServerName);
                    this.setSearchDN(tmpConf, tmpServerName);
                    this.setDnsLookup(tmpConf, tmpServerName);
                    this.setDomainName(tmpConf, tmpServerName);
                    this.setGrpMapping(tmpConf, tmpServerName);
                    logger.info(module, method, "finish constructing the configuration object", tmpServerName + ":[" + i + "]");
                    configs[i] = tmpConf;
                }
            }
        }
        logger.info(module, method, "", "end");
        return configs;
    }

    public void setServerName(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setServerName";
        logger.info(module, method, "", "start");
        if (serverName == null || serverName.length() == 0) {
            logger.info(module, method, "the value is invalid", "server name");
            conf.setServerErrCode(10);
        } else {
            conf.setServerName(serverName);
        }
        logger.info(module, method, "", "end");
    }

    public void setLdapProtocol(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setLdapProtocol";
        logger.info(module, method, "", "start");
        String tmpProtocol = this.properties.getProperty("auth.ldap." + serverName + "." + PROTOCOL);
        String dnsLookup = this.properties.getProperty("auth.ldap." + serverName + "." + DNS_LOOKUP);
        if (tmpProtocol == null) {
            logger.info(module, method, "the value is invalid", PROTOCOL);
            conf.setServerErrCode(10);
        } else if (tmpProtocol.equalsIgnoreCase("ldap")) {
            conf.setProtocol("ldap");
        } else if (tmpProtocol.equalsIgnoreCase("ldaps") && (dnsLookup == null || dnsLookup.length() == 0 || dnsLookup.compareToIgnoreCase("true") != 0)) {
            conf.setProtocol("ldaps");
        } else if (tmpProtocol.equalsIgnoreCase("starttls")) {
            conf.setProtocol("starttls");
        } else {
            logger.info(module, method, "the value is invalid", PROTOCOL);
            conf.setServerErrCode(10);
        }
        logger.info(module, method, "", "end");
    }

    public void setHost(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setHost";
        logger.info(module, method, "", "start");
        String tmpHost = this.properties.getProperty("auth.ldap." + serverName + "." + HOST);
        String dnsLookup = this.properties.getProperty("auth.ldap." + serverName + "." + DNS_LOOKUP);
        if (tmpHost == null || tmpHost.length() == 0) {
            if (dnsLookup == null || dnsLookup.length() == 0 || dnsLookup.compareToIgnoreCase("true") != 0) {
                logger.info(module, method, "the value is invalid", "host name");
                conf.setServerErrCode(10);
            } else {
                logger.info(module, method, "host is not registered", "use dns lookup");
                conf.setHost("");
            }
        } else {
            conf.setHost(tmpHost);
        }
        logger.info(module, method, "", "end");
    }

    public void setPort(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setPort";
        logger.info(module, method, "", "start");
        int tmpPort = 389;
        try {
            tmpPort = Integer.parseInt(this.properties.getProperty("auth.ldap." + serverName + "." + PORT));
            if (tmpPort < 1 || tmpPort > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "port number");
            tmpPort = 389;
        }
        conf.setPort(tmpPort);
        logger.info(module, method, "", "end");
    }

    public void setTimeout(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setTimeout";
        logger.info(module, method, "", "start");
        int tmpTimeout = 10;
        try {
            tmpTimeout = Integer.parseInt(this.properties.getProperty("auth.ldap." + serverName + "." + TIMEOUT));
            if (tmpTimeout < 0 || tmpTimeout > 120) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", TIMEOUT);
            tmpTimeout = 10;
        }
        conf.setTimeout(tmpTimeout);
        logger.info(module, method, "", "end");
    }

    public void setRetryTimes(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setRetryTimes";
        logger.info(module, method, "", "start");
        int tmpRetryTimes = 3;
        try {
            tmpRetryTimes = Integer.parseInt(this.properties.getProperty("auth.ldap." + serverName + "." + RETRY_TIMES));
            if (tmpRetryTimes < 0 || tmpRetryTimes > 50) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "retry times");
            tmpRetryTimes = 3;
        }
        conf.setRetryTimes(tmpRetryTimes);
        logger.info(module, method, "", "end");
    }

    public void setRetryInterval(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setRetryInterval";
        logger.info(module, method, "", "start");
        int tmpRetryInterval = 1;
        try {
            tmpRetryInterval = Integer.parseInt(this.properties.getProperty("auth.ldap." + serverName + "." + RETRY_INTERVAL));
            if (tmpRetryInterval < 1 || tmpRetryInterval > 60) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "retry interval");
            tmpRetryInterval = 1;
        }
        conf.setRetryInterval(tmpRetryInterval);
        logger.info(module, method, "", "end");
    }

    public void setSearchUserPassword(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setSearchUserPassword";
        logger.info(module, method, "", "start");
        String tmpSearchPW = this.properties.getProperty("auth.ldap." + serverName + "." + LDAP_SEARCH_PW);
        if (tmpSearchPW != null && tmpSearchPW.length() > 0) {
            conf.setSearchUserPassword(tmpSearchPW);
        } else {
            logger.info(module, method, "", "search user password is not registered");
            conf.setSearchUserPassword("");
        }
        logger.info(module, method, "", "end");
    }

    public void setSearchUserDN(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setSearchUserDN";
        logger.info(module, method, "", "start");
        String tmpSearchDN = this.properties.getProperty("auth.ldap." + serverName + "." + LDAP_SEARCH_DN);
        if (tmpSearchDN != null && tmpSearchDN.length() > 0) {
            conf.setSearchUserDN(tmpSearchDN);
        } else {
            logger.info(module, method, "", "search user is not registered");
            conf.setSearchUserDN("");
        }
        logger.info(module, method, "", "end");
    }

    public void setUserAttr(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setUserAttr";
        logger.info(module, method, "", "start");
        String tmpUserAttr = this.properties.getProperty("auth.ldap." + serverName + "." + LDAP_USER_ATTR);
        if (tmpUserAttr == null || tmpUserAttr.length() == 0) {
            logger.info(module, method, "the value is invalid", "attribute");
            conf.setServerErrCode(10);
        } else {
            conf.setUserAttr(tmpUserAttr);
        }
        logger.info(module, method, "", "end");
    }

    public void setSearchDN(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setSearchDN";
        logger.info(module, method, "", "start");
        String tmpSearchBase = this.properties.getProperty("auth.ldap." + serverName + "." + LDAP_SEARCH_BASE);
        if (tmpSearchBase == null || tmpSearchBase.length() == 0) {
            logger.info(module, method, "the value is invalid", "search DN");
            conf.setServerErrCode(10);
        } else {
            conf.setSearchDN(tmpSearchBase);
        }
        logger.info(module, method, "", "end");
    }

    public void setDomainName(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setDomainName";
        logger.info(module, method, "", "start");
        String tmpDomainName = this.properties.getProperty("auth.ldap." + serverName + "." + DOMAIN_NAME);
        String dnsLookup = this.properties.getProperty("auth.ldap." + serverName + "." + DNS_LOOKUP);
        if (dnsLookup == null || dnsLookup.length() == 0) {
            logger.info(module, method, "", "domain name is not registered");
            conf.setDomainName("");
        } else if (tmpDomainName == null || tmpDomainName.length() == 0) {
            logger.info(module, method, "the value is invalid", "DomainName");
            conf.setServerErrCode(10);
        } else {
            conf.setDomainName(tmpDomainName);
        }
        logger.info(module, method, "", "end");
    }

    public void setDnsLookup(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setDnsLookUp";
        logger.info(module, method, "", "start");
        String tmpDnsLookUp = this.properties.getProperty("auth.ldap." + serverName + "." + DNS_LOOKUP);
        String host = this.properties.getProperty("auth.ldap." + serverName + "." + HOST);
        String port = this.properties.getProperty("auth.ldap." + serverName + "." + PORT);
        if (host == null || host.length() == 0 || port == null || port.length() == 0) {
            if (tmpDnsLookUp == null || tmpDnsLookUp.length() == 0) {
                logger.info(module, method, "the value is invalid", "dns lookup");
                conf.setDnsLookup("false");
            } else if (tmpDnsLookUp.equalsIgnoreCase("true") || tmpDnsLookUp.equalsIgnoreCase("false")) {
                conf.setDnsLookup(tmpDnsLookUp);
            } else {
                logger.info(module, method, "the value is invalid", "dns lookup");
                conf.setDnsLookup("false");
            }
        } else {
            conf.setDnsLookup("false");
        }
        logger.info(module, method, "", "end");
    }

    public void setGrpMapping(SJbaseLdapConfiguration conf, String serverName) {
        String method = "setGrpMapping";
        logger.info(module, method, "", "start");
        String tmpGrpMapping = this.properties.getProperty(GRP_MAPPING);
        if (tmpGrpMapping == null || tmpGrpMapping.length() == 0) {
            logger.info(module, method, "the value is invalid", "GroupMapping");
            conf.setGrpMapping("false");
        } else {
            conf.setGrpMapping(tmpGrpMapping);
        }
        logger.info(module, method, "", "end");
    }
}

