/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.radius;

import java.util.Arrays;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseAccessRequestPacket;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadUtils;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusFormatException;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusPacket;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusPacketValidator;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseAccessResponseValidator
implements SJbaseRadiusPacketValidator {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseRadiusPacketHandler";
    private SJbaseRadiusPacket request;
    private SJbaseRadiusPacket response;
    private byte[] secretBytes;

    public SJbaseAccessResponseValidator(SJbaseAccessRequestPacket request, byte[] secret) {
        this.request = request;
        this.secretBytes = secret;
    }

    @Override
    public void validate(SJbaseRadiusPacket packet) throws SJbaseRadiusFormatException {
        String method = "validate";
        logger.info(module, method, "", "start");
        this.response = packet;
        this.checkCode();
        this.checkId();
        this.checkAuthenticator();
        logger.info(module, method, "", "end");
    }

    private void checkCode() throws SJbaseRadiusFormatException {
        String method = "checkCode";
        logger.info(module, method, "", "start");
        int code = this.response.getCode();
        if (code != 2 && code != 3 && code != 11) {
            logger.info(module, method, "check the packet code", "invalid");
            throw new SJbaseRadiusFormatException();
        }
        logger.info(module, method, "", "end");
    }

    private void checkId() throws SJbaseRadiusFormatException {
        String method = "checkId";
        logger.info(module, method, "", "start");
        if (this.request.getId() != this.response.getId()) {
            logger.info(module, method, "check the packet id", "invalid");
            throw new SJbaseRadiusFormatException();
        }
        logger.info(module, method, "", "end");
    }

    private void checkAuthenticator() throws SJbaseRadiusFormatException {
        String method = "checkAuthenticator";
        logger.info(module, method, "", "start");
        byte[] responseBytes = this.response.toBytes();
        byte[] input = new byte[responseBytes.length + this.secretBytes.length];
        byte[] requestAuthenticator = this.request.getAuthenticator();
        System.arraycopy(responseBytes, 0, input, 0, responseBytes.length);
        System.arraycopy(this.secretBytes, 0, input, responseBytes.length, this.secretBytes.length);
        System.arraycopy(requestAuthenticator, 0, input, 4, requestAuthenticator.length);
        byte[] output = SJbaseRadUtils.createMD5(input);
        if (!Arrays.equals(output, this.response.getAuthenticator())) {
            logger.info(module, method, "check the authenticator", "invalid");
            throw new SJbaseRadiusFormatException();
        }
        logger.info(module, method, "", "end");
    }
}

