/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseHCSCVAEInfoUtility {
    private static final String LOG_FUNCTION = "HCS";
    private static final String LOG_TITLE = SJbaseHCSCVAEInfoUtility.class.getSimpleName();
    private static final SJcLoggerInterface logger = SJcLogUty.getLogger("SN_HCS.log");
    private static final String CVAE_INFO_PATH = SJcEnvUty.getSnBasePath() + "config\\Ctrack_CVAEInfo.txt";
    private static final String ENCODE = "UTF-8";
    private static final String SEPARATOR = "\t";

    public static boolean checkEnabled(String ipAddress) {
        String LOG_SUBTITLE = "checkEnabled";
        logger.info(LOG_FUNCTION, LOG_TITLE, "checkEnabled", "Start. IP = " + ipAddress);
        boolean result = false;
        if (ipAddress == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "checkEnabled", "Parameter Error.");
            return result;
        }
        File cvaeFile = new File(CVAE_INFO_PATH);
        if (cvaeFile.exists()) {
            result = SJbaseHCSCVAEInfoUtility.checkCVAEInfo(ipAddress);
        } else {
            logger.info(LOG_FUNCTION, LOG_TITLE, "checkEnabled", "CVAE Info File not found.");
            result = false;
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "checkEnabled", "End.");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkCVAEInfo(String ipAddress) {
        String LOG_SUBTITLE = "checkCVAEInfo";
        logger.info(LOG_FUNCTION, LOG_TITLE, "checkCVAEInfo", "Start.");
        boolean result = false;
        BufferedReader br = null;
        ArrayList<Long> lastTimeList = new ArrayList<Long>();
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(CVAE_INFO_PATH), ENCODE));
            String line = null;
            while ((line = br.readLine()) != null) {
                Long lastTime = SJbaseHCSCVAEInfoUtility.getLastTime(ipAddress, line);
                if (lastTime == null) continue;
                lastTimeList.add(lastTime);
            }
            result = SJbaseHCSCVAEInfoUtility.checkLastTime(lastTimeList);
        }
        catch (Exception ex) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "checkCVAEInfo", "CVAE Info File Read Error.", ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception ex) {
                    logger.warn(LOG_FUNCTION, LOG_TITLE, "checkCVAEInfo", "BufferedReader Close Error.", ex);
                }
            }
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "checkCVAEInfo", "End.");
        return result;
    }

    private static Long getLastTime(String ipAddress, String line) {
        String LOG_SUBTITLE = "getLastTime";
        logger.trace(LOG_FUNCTION, LOG_TITLE, "getLastTime", "Start.");
        Long result = null;
        int count = POSITION.values().length;
        String[] info = line.split(SEPARATOR);
        if (info.length >= count - 1) {
            String cvaeIP = info[POSITION.IPADDRES.ordinal()];
            String product = info[POSITION.PRODUCT.ordinal()];
            if (ipAddress.equals(cvaeIP)) {
                String lastTime = info[POSITION.LAST_TIME.ordinal()];
                logger.info(LOG_FUNCTION, LOG_TITLE, "getLastTime", "IPAddress = " + cvaeIP + ", ProductName = " + product + ", LastAccessTime = " + lastTime);
                try {
                    result = Long.valueOf(lastTime);
                }
                catch (NumberFormatException ex) {
                    logger.error(LOG_FUNCTION, LOG_TITLE, "getLastTime", "CVAE Info LastAccessTime FormatError.", ex);
                }
            } else {
                logger.warn(LOG_FUNCTION, LOG_TITLE, "getLastTime", "IPAddress = " + cvaeIP + ", ProductName = " + product);
            }
        } else {
            logger.error(LOG_FUNCTION, LOG_TITLE, "getLastTime", "CVAE Info Item Not Enough.");
        }
        logger.trace(LOG_FUNCTION, LOG_TITLE, "getLastTime", "End.");
        return result;
    }

    private static boolean checkLastTime(ArrayList<Long> lastTimeList) {
        String LOG_SUBTITLE = "checkLastTime";
        logger.trace(LOG_FUNCTION, LOG_TITLE, "checkLastTime", "Start.");
        boolean result = false;
        if (lastTimeList.size() > 0) {
            long enableTime = SJbaseHCSCVAEInfoUtility.getEnableExtHCSTime();
            Collections.sort(lastTimeList);
            int index = lastTimeList.size() - 1;
            long lastTimeCVAE = lastTimeList.get(index) * 1000L;
            long now = new Date().getTime();
            if (now - lastTimeCVAE > enableTime) {
                logger.warn(LOG_FUNCTION, LOG_TITLE, "checkLastTime", "Last Access Time Limit Over. Time:" + lastTimeCVAE);
                result = false;
            } else {
                result = true;
            }
        } else {
            logger.warn(LOG_FUNCTION, LOG_TITLE, "checkLastTime", "CVAE Info Item Not Enough.");
        }
        logger.trace(LOG_FUNCTION, LOG_TITLE, "checkLastTime", "End.");
        return result;
    }

    private static long getEnableExtHCSTime() {
        long enableTime = SJcEnvUty.getProperty2int("SN_HCS_ENABLE_TIME", 86400);
        return enableTime *= 1000L;
    }

    private static enum POSITION {
        ID,
        PRODUCT,
        VERSION,
        IPADDRES,
        LICENSE,
        REGISTRY_TIME,
        REGISTRY_STRING,
        LAST_TIME,
        LAST_STRING,
        MEMO;

    }
}

