/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.webapi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.sn2.base.authentication.plugin.SJbaseHCSXMLUtility;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.fileuty.exception.SJcFileUtyException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrQueueBox;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.generated.svp.APIInfo;
import sanproject.sn2.generated.svp.EchoCommand;
import sanproject.sn2.generated.svp.RAIDSVPServerMessage;
import sanproject.sn2.generated.svp.Response;
import sanproject.sn2.generated.svp.ResultList;
import sanproject.sn2.generated.svp.SnTaskInfo;
import sanproject.sn2.generated.svp.SnTaskInfoUserDelete;
import sanproject.sn2.generated.svp.Task;
import sanproject.sn2.servlet.webapi.SJsvlHCSBaseServlet;
import sanproject.sn2.servlet.webapi.SJsvlHCSServletUty;
import sanproject.sn2.servlet.webapi.def.SJsvlErrorCode;
import sanproject.sn2.servlet.webapi.def.SJsvlHcsCommandStatus;
import sanproject.sn2.servlet.webapi.exception.SJsvlWebApiException;
import sanproject.sn2.sn2com.utility.SJsncTaskHashUty;

public class SJsvlSNTaskInfo
extends SJsvlHCSBaseServlet {
    static final long serialVersionUID = 1L;
    private static final Object[][] statusConvList = new Object[][]{{new Integer(0), "REGISTERED"}, {new Integer(1), "QUEUED"}, {new Integer(2), "SNPAUSE"}, {new Integer(256), "RUNNING"}, {new Integer(257), "STOPPING"}, {new Integer(258), "RUNNING"}, {new Integer(512), "COMPLETED"}, {new Integer(513), "FAILED"}, {new Integer(514), "STOPPED"}, {new Integer(515), "DELETING"}};
    private static final String STATUS_DELETED = "DELETED";
    private static final String DIFF = "diff";
    private static final String XML_DIR = "tasks" + File.separator + "xml";
    private static final String XML_FILE = "TaskList.xml";
    private static final String API_VERSION = "1.0";
    public static final String COMMAND_NAME = "GetSnTaskInfo";
    private static Object syncObject = new Object();
    private static final String DIFF_MODE_EXPANTION_PATH = "/diff";
    private static final TaskSubmissionDateComparator taskSubmissionDateComparator = new TaskSubmissionDateComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doGet";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "doGet", "Start.");
        Object object = syncObject;
        synchronized (object) {
            try {
                request.getSession();
                response.setContentType("text/xml");
                this.checkExpantionPath(request.getPathInfo());
                this.execute(request, response);
            }
            catch (SJsvlWebApiException wapiex) {
                SJsvlHCSServletUty.setErrorResponseBody(response, API_VERSION, COMMAND_NAME, wapiex);
            }
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "doGet", "End.");
    }

    private void execute(HttpServletRequest request, HttpServletResponse response) throws SJsvlWebApiException {
        SJbaseUserSessionInterface session = this.getSession(request);
        SJctrUserController ctl = SJsvlHCSServletUty.getUserController(session);
        SJctrQueueBox queueBox = ctl.getQueueBox();
        List taskList = queueBox.getTaskList();
        List deleteTaskList = queueBox.getDeleteTaskList();
        RAIDSVPServerMessage xml = this.makeTaskAllList(taskList, deleteTaskList);
        RAIDSVPServerMessage xmlForResponse = null;
        if (this.isDiffMode(request.getPathInfo())) {
            RAIDSVPServerMessage beforeXml = null;
            try {
                beforeXml = this.loadTaskListXML();
            }
            catch (SJcException ex) {
                throw new SJsvlWebApiException(SJsvlErrorCode.SJSVL_OK, SJsvlHcsCommandStatus.FAILED, ex);
            }
            xmlForResponse = this.makeTaskDiffList(taskList, deleteTaskList, beforeXml);
        } else {
            xmlForResponse = xml;
        }
        try {
            this.saveTaskListXML(xml);
            SJbaseHCSXMLUtility.java2Xml(xmlForResponse, (OutputStream)response.getOutputStream());
        }
        catch (SJcException ex) {
            throw new SJsvlWebApiException(SJsvlErrorCode.SJSVL_OK, SJsvlHcsCommandStatus.FAILED, ex);
        }
        catch (Throwable th) {
            throw new SJsvlWebApiException(SJsvlErrorCode.SJSVL_OK, SJsvlHcsCommandStatus.FAILED, new SJcException("200", "20", "107052"));
        }
    }

    private SJbaseUserSessionInterface getSession(HttpServletRequest request) {
        SJbaseUserSessionInterface session = null;
        String gsid = SJsvlHCSServletUty.getSessionId(request);
        SJsvlHCSServletUty.checkSessionIdFormat(gsid);
        session = SJsvlHCSServletUty.checkAuthority(gsid, 32);
        return session;
    }

    private boolean isDiffMode(String path) {
        boolean diff = false;
        if (path != null && path.endsWith(DIFF)) {
            diff = true;
        }
        return diff;
    }

    private ResultList communicateXML(RAIDSVPServerMessage xml) {
        Response response = new Response();
        ResultList resultList = new ResultList();
        SnTaskInfo taskInfo = new SnTaskInfo();
        SnTaskInfoUserDelete userDelete = new SnTaskInfoUserDelete();
        xml.setAPIInfo(this.makeAPIInfo());
        xml.setResponse(response);
        response.setEchoCommand(this.makeEchoCommand());
        response.setResultList(resultList);
        resultList.setSnTaskInfo(taskInfo);
        resultList.setSnTaskInfoUserDelete(userDelete);
        return resultList;
    }

    private RAIDSVPServerMessage makeTaskAllList(List<SJctrTask> taskList, List<String> deleteTaskList) {
        RAIDSVPServerMessage xml = new RAIDSVPServerMessage();
        ResultList resultList = this.communicateXML(xml);
        List taskListXml = resultList.getSnTaskInfo().getTask();
        List deleteIDList = resultList.getSnTaskInfoUserDelete().getID();
        for (SJctrTask task : taskList) {
            taskListXml.add(this.makeTaskInfo(task));
        }
        Collections.sort(taskListXml, taskSubmissionDateComparator);
        for (String deleteID : deleteTaskList) {
            if (deleteID.length() == 0) continue;
            deleteIDList.add(deleteID);
        }
        Collections.reverse(deleteIDList);
        return xml;
    }

    private RAIDSVPServerMessage makeTaskDiffList(List<SJctrTask> taskList, List<String> deleteTaskList, RAIDSVPServerMessage beforeXml) {
        RAIDSVPServerMessage xml = new RAIDSVPServerMessage();
        ResultList resultList = this.communicateXML(xml);
        List taskListXml = resultList.getSnTaskInfo().getTask();
        Response before_Response = beforeXml.getResponse();
        ResultList before_ResultList = before_Response.getResultList();
        SnTaskInfo before_TaskInfo = before_ResultList.getSnTaskInfo();
        List before_TaskList = before_TaskInfo.getTask();
        HashMap<String, SJctrTask> mapNow = new HashMap<String, SJctrTask>();
        for (SJctrTask task : taskList) {
            String id = SJsncTaskHashUty.createHash((SJctrTask)task);
            mapNow.put(id, task);
        }
        HashMap<String, Task> mapBefore = new HashMap<String, Task>();
        for (Task before_task : before_TaskList) {
            mapBefore.put(before_task.getID(), before_task);
        }
        for (SJctrTask task : taskList) {
            String id = SJsncTaskHashUty.createHash((SJctrTask)task);
            if (!mapBefore.containsKey(id)) {
                taskListXml.add(this.makeTaskInfo(task));
                continue;
            }
            Task before_task = (Task)mapBefore.get(id);
            if (!this.checkDiffTaskStatus(task, before_task)) continue;
            taskListXml.add(this.makeTaskInfo(task));
        }
        for (Task before_task : before_TaskList) {
            if (mapNow.containsKey(before_task.getID())) continue;
            before_task.setStatus(STATUS_DELETED);
            taskListXml.add(before_task);
        }
        Collections.sort(taskListXml, taskSubmissionDateComparator);
        List deleteIDList = resultList.getSnTaskInfoUserDelete().getID();
        SnTaskInfoUserDelete before_DeleteInfo = before_ResultList.getSnTaskInfoUserDelete();
        List before_userDelete = before_DeleteInfo.getID();
        for (String id : deleteTaskList) {
            if (before_userDelete.contains(id) || id.length() == 0) continue;
            deleteIDList.add(id);
        }
        Collections.reverse(deleteIDList);
        return xml;
    }

    private boolean checkDiffTaskStatus(SJctrTask task, Task before_task) {
        boolean diff = false;
        int progressNow = this.getProgress(task);
        int progressBefore = before_task.getProgress();
        String statusNow = this.getStatus(task);
        String statusBefore = before_task.getStatus();
        if (progressNow != progressBefore || !statusNow.equals(statusBefore)) {
            diff = true;
        }
        return diff;
    }

    private Task makeTaskInfo(SJctrTask task) {
        long applyEndTime;
        Task taskXml = new Task();
        String id = SJsncTaskHashUty.createHash((SJctrTask)task);
        String snid = task.getId();
        String name = task.getName();
        String typeJa = this.getCutString(task.getType(), 255);
        String typeEn = this.getCutString(task.getTypeEn(), 255);
        if (typeEn == null) {
            typeEn = "";
        }
        String userID = task.getUserId();
        String status = this.getStatus(task);
        String message = this.getMessage(task);
        int progress = this.getProgress(task);
        long applyStartTime = task.getApplyStartTime();
        if (applyStartTime == 0L) {
            applyStartTime = -1L;
        }
        if ((applyEndTime = task.getApplyEndTime()) == 0L) {
            applyEndTime = -1L;
        }
        long submitTime = task.getSubmitTime();
        long wizardStartTime = task.getWizardStartTime();
        taskXml.setID(id);
        taskXml.setSNID(snid);
        taskXml.setName(name);
        taskXml.setTypeJa(typeJa);
        taskXml.setTypeEn(typeEn);
        taskXml.setUserName(userID);
        taskXml.setStatus(status);
        taskXml.setMessageID(message);
        taskXml.setProgress(progress);
        taskXml.setStartDate(applyStartTime);
        taskXml.setFinishDate(applyEndTime);
        taskXml.setFireDate(submitTime);
        taskXml.setEstimateDate(-1L);
        taskXml.setSubmissionDate(submitTime);
        taskXml.setWizardOpenDate(wizardStartTime);
        return taskXml;
    }

    private APIInfo makeAPIInfo() {
        APIInfo apiInfo = new APIInfo();
        apiInfo.setVersion(API_VERSION);
        return apiInfo;
    }

    private EchoCommand makeEchoCommand() {
        EchoCommand echoCommand = new EchoCommand();
        echoCommand.setName(COMMAND_NAME);
        echoCommand.setStatus(SJsvlHcsCommandStatus.COMPLETED.getStatus());
        echoCommand.setResult("");
        echoCommand.setResultsource("");
        echoCommand.setMessageid("");
        return echoCommand;
    }

    private int getProgress(SJctrTask task) {
        int progress = task.getProgress();
        int statusNum = task.getStatus();
        if (512 == statusNum) {
            progress = 100;
        } else if (256 != statusNum && 258 != statusNum && 257 != statusNum) {
            progress = -1;
        }
        return progress;
    }

    private String getStatus(SJctrTask task) {
        int statusNum = task.getStatus();
        String status = (String)statusConvList[0][1];
        for (int i = 0; i < statusConvList.length; ++i) {
            Integer sts = (Integer)statusConvList[i][0];
            if (sts != statusNum) continue;
            status = (String)statusConvList[i][1];
            break;
        }
        return status;
    }

    private String getMessage(SJctrTask task) {
        String message = "";
        int statusNum = task.getStatus();
        if (513 == statusNum) {
            SJctrError error = task.getError();
            StringBuffer buffer = new StringBuffer();
            buffer.append(String.format("%03d", error.getFunc()));
            buffer.append(String.format("%02d", error.getModule()));
            buffer.append("-");
            buffer.append(String.format("%06d", error.getMsg()));
            message = buffer.toString();
        }
        return message;
    }

    private RAIDSVPServerMessage loadTaskListXML() throws SJcFileUtyException {
        RAIDSVPServerMessage xml = null;
        try {
            xml = (RAIDSVPServerMessage)SJcFileUty.loadXMLData(XML_DIR, XML_FILE, RAIDSVPServerMessage.class);
        }
        catch (SJcFileUtyException ioex) {
            if (ioex.getCause() instanceof FileNotFoundException) {
                xml = new RAIDSVPServerMessage();
                this.communicateXML(xml);
            }
            SJcFileUty.deleteFile(XML_DIR, XML_FILE);
            throw ioex;
        }
        return xml;
    }

    private void saveTaskListXML(RAIDSVPServerMessage xml) throws SJcFileUtyException {
        try {
            SJcFileUty.saveXMLData(XML_DIR, XML_FILE, xml);
        }
        catch (SJcFileUtyException ioex) {
            SJcFileUty.deleteFile(XML_DIR, XML_FILE);
            throw ioex;
        }
    }

    private String getCutString(String target, int maxlength) {
        if (target == null) {
            return target;
        }
        if (maxlength >= target.length()) {
            return target;
        }
        String result = target.substring(0, maxlength);
        return result;
    }

    private void checkExpantionPath(String path) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "checkExpantionPath";
        if (path != null && !path.equals(DIFF_MODE_EXPANTION_PATH)) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "checkExpantionPath", SJsvlErrorCode.EXPANTION_PATH_ILLEGAL.name() + " Expantion Path = " + path);
            throw new SJsvlWebApiException(SJsvlErrorCode.EXPANTION_PATH_ILLEGAL);
        }
    }

    private static class TaskSubmissionDateComparator
    implements Comparator<Task> {
        private TaskSubmissionDateComparator() {
        }

        @Override
        public int compare(Task task1, Task task2) {
            long submissionDate2;
            int ret = 0;
            long submissionDate1 = task1.getSubmissionDate();
            if (submissionDate1 < (submissionDate2 = task2.getSubmissionDate())) {
                ret = 1;
            } else if (submissionDate1 > submissionDate2) {
                ret = -1;
            }
            return ret;
        }
    }
}

